/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.api.backpack.inventory;

import com.google.common.base.Preconditions;
import gr8pefish.ironbackpacks.api.backpack.BackpackInfo;
import gr8pefish.ironbackpacks.api.backpack.inventory.IBackpackInventoryProvider;
import gr8pefish.ironbackpacks.api.backpack.variant.BackpackVariant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.items.IItemHandler;

public class IronBackpacksInventoryHelper {
    @CapabilityInject(value=IBackpackInventoryProvider.class)
    public static Capability<IBackpackInventoryProvider> BACKPACK_INV_CAPABILITY = null;

    @Nullable
    private static IItemHandler getBackpackInventory(@Nonnull ItemStack stack) {
        Preconditions.checkNotNull((Object)stack, (Object)"ItemStack cannot be null.");
        if (stack.hasCapability(BACKPACK_INV_CAPABILITY, null)) {
            BackpackInfo backpackInfo = BackpackInfo.fromStack(stack);
            BackpackVariant backpackVariant = backpackInfo.getVariant();
            return ((IBackpackInventoryProvider)stack.getCapability(BACKPACK_INV_CAPABILITY, null)).getInventory();
        }
        return null;
    }
}

