/*
 * Decompiled with CFR 0.152.
 */
package com.vel0cityx.chameleoncreepers;

import com.vel0cityx.chameleoncreepers.BiomeColors;
import com.vel0cityx.chameleoncreepers.ClientProxy;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelCreeper;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.RenderCreeper;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerCreeperCharge;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class RenderChameleonCreeper
extends RenderLiving<EntityCreeper> {
    static ResourceLocation grayscaleCreeperTexture;
    private FloatBuffer currentGLColor = BufferUtils.createFloatBuffer((int)16);
    private static final ResourceLocation vanillaCreeperTexture;

    public static void convertTextureToGrayScale() throws IOException {
        IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
        try {
            BufferedImage vanillaCreeperTextureData = TextureUtil.func_177053_a((InputStream)resourceManager.func_110536_a(vanillaCreeperTexture).func_110527_b());
            BufferedImage creeperTextureData = new BufferedImage(vanillaCreeperTextureData.getWidth(), vanillaCreeperTextureData.getHeight(), 11);
            Graphics g = creeperTextureData.getGraphics();
            g.drawImage(vanillaCreeperTextureData, 0, 0, null);
            g.dispose();
            DynamicTexture dynamicGrayscaleCreeperTexture = new DynamicTexture(creeperTextureData);
            grayscaleCreeperTexture = new ResourceLocation("chameleoncreepers", "textures/entity/creeper/chameleoncreeper.png");
            Minecraft.func_71410_x().func_110434_K().func_110579_a(grayscaleCreeperTexture, (ITextureObject)dynamicGrayscaleCreeperTexture);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public RenderChameleonCreeper(RenderManager renderManagerIn) throws IOException {
        super(renderManagerIn, (ModelBase)new ModelCreeper(), 0.5f);
        this.func_177094_a((LayerRenderer)new LayerCreeperCharge(new RenderCreeper(this.field_76990_c)));
    }

    protected void preRenderCallback(EntityCreeper entitylivingbaseIn, float partialTickTime) {
        float f = entitylivingbaseIn.func_70831_j(partialTickTime);
        float f1 = 1.0f + MathHelper.func_76126_a((float)(f * 100.0f)) * f * 0.01f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        f *= f;
        f *= f;
        float f2 = (1.0f + f * 0.4f) * f1;
        float f3 = (1.0f + f * 0.1f) / f1;
        GlStateManager.func_179152_a((float)f2, (float)f3, (float)f2);
    }

    protected int getColorMultiplier(EntityCreeper entitylivingbaseIn, float lightBrightness, float partialTickTime) {
        float f = entitylivingbaseIn.func_70831_j(partialTickTime);
        if ((int)(f * 10.0f) % 2 == 0) {
            return 0;
        }
        int i = (int)(f * 0.2f * 255.0f);
        i = MathHelper.func_76125_a((int)i, (int)0, (int)255);
        return i << 24 | 0xFFFFFF;
    }

    protected ResourceLocation getEntityTexture(EntityCreeper entity) {
        return grayscaleCreeperTexture;
    }

    public boolean shouldRender(EntityCreeper livingEntity, ICamera camera, double camX, double camY, double camZ) {
        return super.func_177071_a((EntityLiving)livingEntity, camera, camX, camY, camZ);
    }

    public void doRender(EntityCreeper entity, double x, double y, double z, float entityYaw, float partialTicks) {
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
    }

    protected void renderModel(EntityCreeper entitylivingbaseIn, float p_77036_2_, float p_77036_3_, float p_77036_4_, float p_77036_5_, float p_77036_6_, float p_77036_7_) {
        boolean flag1;
        boolean flag = !entitylivingbaseIn.func_82150_aj();
        boolean bl = flag1 = !flag && !entitylivingbaseIn.func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (flag || flag1) {
            if (!this.func_180548_c((Entity)entitylivingbaseIn)) {
                return;
            }
            if (flag1) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.15f);
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)770, (int)771);
                GlStateManager.func_179092_a((int)516, (float)0.003921569f);
            }
            if (entitylivingbaseIn.field_70737_aN <= 0 || entitylivingbaseIn.field_70725_aQ > 0) {
                GL11.glGetFloat((int)2816, (FloatBuffer)this.currentGLColor);
                int[] colorTint = BiomeColors.getBlockColors((EntityLivingBase)entitylivingbaseIn, this.shouldOnlyUseGrassColors());
                GL11.glColor4f((float)((float)colorTint[0] / 255.0f), (float)((float)colorTint[1] / 255.0f), (float)((float)colorTint[2] / 255.0f), (float)1.0f);
            }
            this.field_77045_g.func_78088_a((Entity)entitylivingbaseIn, p_77036_2_, p_77036_3_, p_77036_4_, p_77036_5_, p_77036_6_, p_77036_7_);
            GL11.glColor4f((float)this.currentGLColor.get(0), (float)this.currentGLColor.get(1), (float)this.currentGLColor.get(2), (float)this.currentGLColor.get(3));
            if (flag1) {
                GlStateManager.func_179084_k();
                GlStateManager.func_179092_a((int)516, (float)0.1f);
                GlStateManager.func_179121_F();
                GlStateManager.func_179132_a((boolean)true);
            }
        }
    }

    protected void renderLeash(EntityCreeper entityLivingIn, double x, double y, double z, float entityYaw, float partialTicks) {
        super.func_110827_b((EntityLiving)entityLivingIn, x, y, z, entityYaw, partialTicks);
    }

    private boolean shouldOnlyUseGrassColors() {
        return ClientProxy.onlyUseGrassColors;
    }

    static {
        vanillaCreeperTexture = new ResourceLocation("textures/entity/creeper/creeper.png");
    }
}

