/*
 * Decompiled with CFR 0.152.
 */
package com.vel0cityx.chameleoncreepers;

import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.BlockVine;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.Biome;

public class BiomeColors {
    public static int[] getBlockColors(EntityLivingBase creeper, boolean onlyDoBiomeColors) {
        int entityX = (int)creeper.field_70165_t;
        int entityY = (int)creeper.field_70163_u;
        int entityZ = (int)creeper.field_70161_v;
        int r = 0;
        int g = 0;
        int b = 0;
        int blocksCalculated = 27;
        if (creeper.func_70090_H()) {
            return new int[]{64, 64, 255};
        }
        if (creeper.func_70055_a(Material.field_151587_i)) {
            return new int[]{255, 64, 64};
        }
        for (int x0 = -1; x0 <= 1; ++x0) {
            for (int y0 = 0; y0 <= 2; ++y0) {
                for (int z0 = -1; z0 <= 1; ++z0) {
                    int currCol;
                    BlockPos blockPos = new BlockPos(entityX + x0, (int)((double)(entityY + y0) - 0.5), entityZ + z0);
                    IBlockState iBlockState = creeper.field_70170_p.func_180495_p(blockPos);
                    Block blockCloseToCreeper = iBlockState.func_177230_c();
                    if (blockCloseToCreeper instanceof BlockAir) {
                        --blocksCalculated;
                        continue;
                    }
                    if (onlyDoBiomeColors || blockCloseToCreeper instanceof BlockGrass || blockCloseToCreeper instanceof BlockTallGrass || blockCloseToCreeper instanceof BlockLeaves || blockCloseToCreeper instanceof BlockVine) {
                        Biome biome = creeper.field_70170_p.getBiomeForCoordsBody(new BlockPos(entityX + x0, entityY + y0, entityZ + z0));
                        currCol = biome.func_180627_b(new BlockPos(entityX + x0, entityY + y0, entityZ + z0));
                    } else {
                        currCol = blockCloseToCreeper.func_180659_g((IBlockState)blockCloseToCreeper.func_176223_P(), (IBlockAccess)creeper.field_70170_p, (BlockPos)blockPos).field_76291_p;
                    }
                    r += (currCol & 0xFF0000) >> 16;
                    g += (currCol & 0xFF00) >> 8;
                    b += currCol & 0xFF;
                }
            }
        }
        if (blocksCalculated == 0) {
            return new int[]{135, 135, 135};
        }
        return new int[]{r /= blocksCalculated, g /= blocksCalculated, b /= blocksCalculated};
    }
}

