/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.station;

import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import zmaster587.advancedRocketry.api.dimension.IDimensionProperties;
import zmaster587.advancedRocketry.api.dimension.solar.StellarBody;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.entity.EntityUIButton;
import zmaster587.advancedRocketry.entity.EntityUIPlanet;
import zmaster587.advancedRocketry.entity.EntityUIStar;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ISliderBar;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleRedstoneOutputButton;
import zmaster587.libVulpes.inventory.modules.ModuleSlider;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.util.INetworkMachine;
import zmaster587.libVulpes.util.ZUtils;

public class TilePlanetaryHologram
extends TileEntity
implements ITickable,
IButtonInventory,
IModularInventory,
ISliderBar,
INetworkMachine {
    private List<EntityUIPlanet> entities = new LinkedList<EntityUIPlanet>();
    private List<EntityUIStar> starEntities = new LinkedList<EntityUIStar>();
    private EntityUIPlanet centeredEntity;
    private EntityUIPlanet selectedPlanet = null;
    private EntityUIStar currentStar;
    private EntityUIButton backButton;
    private StellarBody currentStarBody;
    private ModuleRedstoneOutputButton redstoneControl;
    private ZUtils.RedstoneState state;
    private int selectedId = -2147483647;
    private float onTime = 1.0f;
    private ModuleText targetGrav = new ModuleText(6, 45, LibVulpes.proxy.getLocalizedString("msg.planetholo.size"), 0x202020);
    private float size = 0.02f;
    private static final byte SCALEPACKET = 0;
    private static final byte STATEUPDATE = 1;
    private boolean allowUpdate = true;
    private boolean stellarMode = false;

    public TilePlanetaryHologram() {
        this.redstoneControl = new ModuleRedstoneOutputButton(174, 4, 1, "", (IButtonInventory)this);
        this.state = ZUtils.RedstoneState.OFF;
        this.redstoneControl.setRedstoneState(this.state);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.cleanup();
    }

    private void cleanup() {
        for (EntityUIPlanet planet : this.entities) {
            planet.func_70106_y();
        }
        this.entities.clear();
        for (EntityUIStar star : this.starEntities) {
            star.func_70106_y();
        }
        this.starEntities.clear();
        this.selectedPlanet = null;
        this.centeredEntity = null;
        this.selectedId = -2147483647;
        if (this.currentStar != null) {
            this.currentStar.func_70106_y();
            this.currentStar = null;
        }
        if (this.backButton != null) {
            this.backButton.func_70106_y();
            this.backButton = null;
        }
    }

    public boolean isEnabled() {
        boolean powered = this.field_145850_b.func_175687_A(this.func_174877_v()) > 0;
        return !powered && this.state == ZUtils.RedstoneState.INVERTED || powered && this.state == ZUtils.RedstoneState.ON || this.state == ZUtils.RedstoneState.OFF;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.isEnabled()) {
                if (this.onTime < 1.0f) {
                    this.onTime += 0.2f / this.getHologramSize();
                }
                if (this.allowUpdate) {
                    for (EntityUIPlanet entityUIPlanet : this.entities) {
                        DimensionProperties properties = entityUIPlanet.getProperties();
                        if (entityUIPlanet != this.centeredEntity) {
                            entityUIPlanet.setPositionPolar((double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o() + 1, (double)this.field_174879_c.func_177952_p() + 0.5, (double)this.getInterpHologramSize() * (0.1 + (double)((float)properties.orbitalDist / 100.0f)), properties.orbitTheta);
                        }
                        entityUIPlanet.setScale(this.getInterpHologramSize());
                    }
                    if (this.stellarMode) {
                        for (EntityUIStar entityUIStar : this.starEntities) {
                            entityUIStar.func_70107_b((double)this.field_174879_c.func_177958_n() + 0.5 + (double)(this.getInterpHologramSize() * (float)entityUIStar.getStarProperties().getPosX() / 100.0f), this.field_174879_c.func_177956_o() + 1, (double)this.field_174879_c.func_177952_p() + 0.5 + (double)(this.getInterpHologramSize() * (float)entityUIStar.getStarProperties().getPosZ() / 100.0f));
                            entityUIStar.setScale(this.getInterpHologramSize());
                        }
                    } else if (!this.starEntities.isEmpty()) {
                        float phaseInc = 1440 / this.starEntities.size();
                        float f = 0.0f;
                        for (EntityUIStar entity : this.starEntities) {
                            double deltaX = (double)(entity.getStarProperties().getStarSeparation() * MathHelper.func_76134_b((float)f)) * 0.05;
                            double deltaY = (double)(entity.getStarProperties().getStarSeparation() * MathHelper.func_76126_a((float)f)) * 0.05;
                            entity.func_70107_b((double)this.field_174879_c.func_177958_n() + 0.5 + (double)this.getInterpHologramSize() * deltaX, this.field_174879_c.func_177956_o() + 1, (double)this.field_174879_c.func_177952_p() + 0.5 + (double)this.getInterpHologramSize() * deltaY);
                            entity.setScale(this.getInterpHologramSize() * entity.getStarProperties().getSize());
                            f += phaseInc;
                        }
                    }
                    if (this.currentStar != null) {
                        this.currentStar.setScale(this.getInterpHologramSize());
                        this.currentStar.setPositionPolar((double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o() + 1, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0, 0.0);
                    }
                    if (this.centeredEntity != null) {
                        this.centeredEntity.setPositionPolar((double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o() + 1, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0, 0.0);
                    }
                    if (this.entities.isEmpty() && this.starEntities.isEmpty()) {
                        this.rebuildSystem();
                    }
                    if (this.backButton != null) {
                        this.backButton.func_70107_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5 + (double)(this.getInterpHologramSize() / 10.0f), (double)this.field_174879_c.func_177952_p() + 0.5);
                    }
                } else {
                    this.allowUpdate = true;
                }
            } else if (this.backButton != null) {
                this.cleanup();
            }
        }
    }

    public void selectSystem(int id) {
        if (id >= 10000) {
            if (this.stellarMode) {
                if (this.selectedId != id) {
                    for (EntityUIStar entity : this.starEntities) {
                        if (entity.getPlanetID() + 10000 == id) {
                            entity.setSelected(true);
                            this.selectedPlanet = entity;
                            continue;
                        }
                        entity.setSelected(false);
                    }
                    this.selectedId = id;
                } else {
                    this.stellarMode = false;
                    this.currentStarBody = DimensionManager.getInstance().getStar(id - 10000);
                    this.rebuildSystem();
                    this.selectedId = -2147483647;
                }
            }
        } else {
            ISpaceObject station = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.func_174877_v());
            if (station != null) {
                station.setDestOrbitingBody(id);
                if (this.selectedPlanet != null && this.selectedPlanet.getPlanetID() == id) {
                    this.centeredEntity = this.selectedPlanet;
                    this.stellarMode = false;
                    this.rebuildSystem();
                } else {
                    for (EntityUIPlanet entity : this.entities) {
                        if (entity.getPlanetID() == id) {
                            entity.setSelected(true);
                            this.selectedPlanet = entity;
                            continue;
                        }
                        entity.setSelected(false);
                    }
                }
            }
        }
    }

    private void rebuildSystem() {
        this.onTime = 0.0f;
        for (EntityUIPlanet entityUIPlanet : this.entities) {
            entityUIPlanet.func_70106_y();
        }
        for (EntityUIStar entityUIStar : this.starEntities) {
            entityUIStar.func_70106_y();
        }
        this.starEntities.clear();
        this.entities.clear();
        this.selectedPlanet = null;
        if (this.backButton == null) {
            this.backButton = new EntityUIButton(this.field_145850_b, 0, this);
            this.backButton.func_70107_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5);
            this.func_145831_w().func_72838_d((Entity)this.backButton);
        }
        if (!this.stellarMode) {
            List<IDimensionProperties> planetList;
            List<IDimensionProperties> list = planetList = this.currentStarBody == null ? DimensionManager.getSol().getPlanets() : this.currentStarBody.getPlanets();
            if (this.centeredEntity != null) {
                planetList = new LinkedList<IDimensionProperties>();
                planetList.add(this.centeredEntity.getProperties());
                for (int id : this.centeredEntity.getProperties().getChildPlanets()) {
                    planetList.add(DimensionManager.getInstance().getDimensionProperties(id));
                }
                if (this.currentStar != null) {
                    this.currentStar.func_70106_y();
                    this.currentStar = null;
                }
            } else {
                if (this.currentStarBody == null) {
                    this.currentStarBody = DimensionManager.getSol();
                }
                this.currentStar = new EntityUIStar(this.field_145850_b, this.currentStarBody, this, (double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5);
                this.func_145831_w().func_72838_d((Entity)this.currentStar);
                if (this.currentStarBody.getSubStars() != null && !this.currentStarBody.getSubStars().isEmpty()) {
                    float f = 360 / this.currentStarBody.getSubStars().size();
                    float phase = 0.0f;
                    int count = 0;
                    List<StellarBody> starList = this.currentStarBody.getSubStars();
                    for (StellarBody body : starList) {
                        double deltaX = (double)(body.getStarSeparation() * MathHelper.func_76134_b((float)phase)) * 0.05;
                        double deltaY = (double)(body.getStarSeparation() * MathHelper.func_76126_a((float)phase)) * 0.05;
                        EntityUIStar entity = new EntityUIStar(this.field_145850_b, body, count++, this, (double)this.field_174879_c.func_177958_n() + 0.5 + deltaX, this.field_174879_c.func_177956_o() + 1, (double)this.field_174879_c.func_177952_p() + 0.5 + deltaY);
                        this.func_145831_w().func_72838_d((Entity)entity);
                        this.starEntities.add(entity);
                        phase += f;
                    }
                }
            }
            for (IDimensionProperties properties : planetList) {
                EntityUIPlanet entity = new EntityUIPlanet(this.field_145850_b, (DimensionProperties)properties, this, (double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o() + 1, (double)this.field_174879_c.func_177952_p() + 0.5);
                this.func_145831_w().func_72838_d((Entity)entity);
                this.entities.add(entity);
                if (this.centeredEntity == null || properties != this.centeredEntity.getProperties()) continue;
                this.centeredEntity = entity;
            }
        } else {
            if (this.currentStar != null) {
                this.currentStar.func_70106_y();
                this.currentStar = null;
            }
            Collection<StellarBody> starList = DimensionManager.getInstance().getStars();
            for (StellarBody body : starList) {
                EntityUIStar entity = new EntityUIStar(this.field_145850_b, body, this, (double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5);
                this.func_145831_w().func_72838_d((Entity)entity);
                this.starEntities.add(entity);
            }
        }
        this.allowUpdate = false;
    }

    public List<ModuleBase> getModules(int id, EntityPlayer player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        modules.add((ModuleBase)this.targetGrav);
        modules.add((ModuleBase)new ModuleSlider(6, 60, 0, TextureResources.doubleWarningSideBarIndicator, (ISliderBar)this));
        modules.add((ModuleBase)this.redstoneControl);
        this.updateText();
        return modules;
    }

    private void updateText() {
        if (this.field_145850_b.field_72995_K) {
            this.targetGrav.setText(String.format("%s %f", LibVulpes.proxy.getLocalizedString("msg.planetholo.size"), Float.valueOf(this.getHologramSize())));
        }
    }

    private float getHologramSize() {
        return this.size * 10.0f + 0.8f;
    }

    private float getInterpHologramSize() {
        return this.getHologramSize() * this.onTime;
    }

    public String getModularInventoryName() {
        return "tile.planetHoloSelector.name";
    }

    public boolean canInteractWithContainer(EntityPlayer entity) {
        return true;
    }

    public float getNormallizedProgress(int id) {
        return this.size;
    }

    public void setProgress(int id, int progress) {
        this.size = (float)progress / 100.0f;
    }

    public int getProgress(int id) {
        return (int)(this.size * 100.0f);
    }

    public int getTotalProgress(int id) {
        return 100;
    }

    public void setTotalProgress(int id, int progress) {
    }

    public void setProgressByUser(int id, int progress) {
        this.size = (float)progress / 100.0f;
        PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 0));
        this.updateText();
    }

    public void writeDataToNetwork(ByteBuf out, byte id) {
        if (id == 0) {
            out.writeFloat(this.size);
        }
        if (id == 1) {
            out.writeByte(this.state.ordinal());
        }
    }

    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
        if (packetId == 0) {
            nbt.func_74776_a("scale", in.readFloat());
        } else if (packetId == 1) {
            nbt.func_74774_a("state", in.readByte());
        }
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        if (id == 0) {
            this.size = nbt.func_74760_g("scale");
        } else if (id == 1) {
            this.state = ZUtils.RedstoneState.values()[nbt.func_74771_c("state")];
        }
    }

    public void onInventoryButtonPressed(int buttonId) {
        if (buttonId == 0) {
            if (this.currentStar != null) {
                this.stellarMode = true;
            }
            this.selectedPlanet = null;
            this.centeredEntity = null;
            this.rebuildSystem();
        } else if (buttonId == 1) {
            this.state = this.redstoneControl.getState();
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 1));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        this.state.writeToNBT(compound);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.state = ZUtils.RedstoneState.createFromNBT((NBTTagCompound)compound);
        this.redstoneControl.setRedstoneState(this.state);
    }
}

