/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.betterchests.upgrades.power;

import aroma1997.betterchests.api.ChestModifier;
import aroma1997.betterchests.api.UpgradableBlockType;
import aroma1997.betterchests.upgrades.BasicUpgrade;
import aroma1997.core.util.LocalizationHelper;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PowerBaseUpgrade
extends BasicUpgrade {
    public PowerBaseUpgrade(boolean canBeDisabled, int maxUpgrades, UpgradableBlockType[] type) {
        super(canBeDisabled, maxUpgrades, type);
    }

    public PowerBaseUpgrade(boolean canBeDisabled, int maxUpgrades, UpgradableBlockType[] type, Supplier<Collection<ItemStack>> requiredUpgrades) {
        super(canBeDisabled, maxUpgrades, type, requiredUpgrades);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addTooltips(ItemStack upgrade, List<String> tooltips) {
        int powerProvided;
        Number capacitorIncrease = this.getChestModifier(null, ChestModifier.ENERGY_CAPACITY, upgrade);
        if (capacitorIncrease != null) {
            tooltips.add(LocalizationHelper.localizeFormatted((String)"betterchests:tooltip.capacitorincrease", (Object[])new Object[]{capacitorIncrease}));
        }
        if ((powerProvided = this.getPowerProvided()) > 0) {
            tooltips.add(LocalizationHelper.localizeFormatted((String)"betterchests:tooltip.providesPower", (Object[])new Object[]{powerProvided}));
        }
    }

    public int getPowerProvided() {
        return 0;
    }
}

