/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.betterchests.upgrades.impl.plant;

import aroma1997.betterchests.api.IBetterChest;
import aroma1997.betterchests.api.planter.IHarvestHandler;
import aroma1997.betterchests.api.planter.IPlantHandler;
import aroma1997.betterchests.upgrades.impl.plant.PlantHarvestHelper;
import aroma1997.core.util.ItemUtil;
import aroma1997.core.util.LazyInitializer;
import aroma1997.core.util.WorldUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class TreeHandler
implements IHarvestHandler,
IPlantHandler {
    private static final int MAX_DEPTH = 40;
    private Supplier<Set<Block>> acceptedBlocks = new LazyInitializer(() -> {
        HashSet<Block> blocks = new HashSet<Block>();
        blocks.addAll(TreeHandler.getBlocksMatching("logWood"));
        blocks.addAll(TreeHandler.getBlocksMatching("treeLeaves"));
        return blocks;
    });

    protected static Set<Block> getBlocksMatching(String name) {
        HashSet<Block> set = new HashSet<Block>();
        for (ItemStack stack : OreDictionary.getOres((String)name)) {
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            if (block == Blocks.field_150350_a) continue;
            set.add(block);
        }
        return set;
    }

    @Override
    public boolean canHandleHarvest(IBlockState state, World world, BlockPos pos) {
        return this.canBreak(world, pos);
    }

    @Override
    public boolean handleHarvest(IBetterChest chest, IBlockState state, World world, BlockPos pos) {
        BlockPos.MutableBlockPos start = new BlockPos.MutableBlockPos(pos);
        while (this.canBreak(world, (BlockPos)start)) {
            start.func_189536_c(EnumFacing.UP);
        }
        start.func_189536_c(EnumFacing.DOWN);
        if (start.func_177956_o() >= pos.func_177956_o()) {
            BlockPos target = this.search(world, pos);
            IBlockState targetState = world.func_180495_p(target);
            targetState.func_177230_c().func_180663_b(world, pos, state);
            PlantHarvestHelper.breakBlockHandleDrop(world, target, targetState, chest);
            return true;
        }
        return false;
    }

    protected BlockPos search(World world, BlockPos pos) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        visited.add(pos);
        BlockPos currentPos = pos;
        for (int i = 0; i < 40; ++i) {
            boolean isMatching = false;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                BlockPos newPos;
                if (dir == EnumFacing.DOWN || visited.contains(newPos = currentPos.func_177972_a(dir)) || !this.canBreak(world, newPos)) continue;
                isMatching = true;
                visited.add(newPos);
                currentPos = newPos;
                break;
            }
            if (!isMatching) break;
        }
        return currentPos;
    }

    protected boolean canBreak(World world, BlockPos pos) {
        return this.acceptedBlocks.get().contains(world.func_180495_p(pos).func_177230_c());
    }

    protected boolean isAcceptedSapling(ItemStack stack) {
        for (ItemStack other : OreDictionary.getOres((String)"treeSapling")) {
            if (!ItemUtil.areItemsSameMatching((ItemStack)stack, (ItemStack)other, (ItemUtil.IItemMatchCriteria[])new ItemUtil.IItemMatchCriteria[]{ItemUtil.IItemMatchCriteria.ID, ItemUtil.IItemMatchCriteria.WILDCARD})) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canHandlePlant(Collection<ItemStack> items, World world, BlockPos pos, IBlockState state) {
        if (!WorldUtil.isBlockAir((IBlockState)state)) {
            return false;
        }
        Optional<ItemStack> sapling = items.stream().filter(this::isAcceptedSapling).filter(stack -> world.func_190527_a(Block.func_149634_a((Item)stack.func_77973_b()), pos, true, EnumFacing.UP, null)).findFirst();
        return sapling.isPresent();
    }

    @Override
    public boolean handlePlant(IBetterChest chest, Collection<ItemStack> items, World world, BlockPos pos) {
        ItemStack sapling = items.stream().filter(this::isAcceptedSapling).filter(stack -> world.func_190527_a(Block.func_149634_a((Item)stack.func_77973_b()), pos, true, EnumFacing.UP, null)).findFirst().get();
        world.func_175656_a(pos, Block.func_149634_a((Item)sapling.func_77973_b()).func_180642_a(world, pos, EnumFacing.UP, 0.0f, 0.0f, 0.0f, sapling.func_77960_j(), null));
        sapling.func_190920_e(sapling.func_190916_E() - 1);
        return true;
    }
}

