/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.betterchests.upgrades.impl.plant;

import aroma1997.betterchests.api.IBetterChest;
import aroma1997.betterchests.api.planter.IHarvestHandler;
import aroma1997.betterchests.api.planter.IPlantHandler;
import aroma1997.betterchests.api.planter.PlantHarvestRegistry;
import aroma1997.betterchests.upgrades.impl.plant.CocoaHandler;
import aroma1997.betterchests.upgrades.impl.plant.CropHandler;
import aroma1997.betterchests.upgrades.impl.plant.NetherWartHandler;
import aroma1997.betterchests.upgrades.impl.plant.PumpkinBlockHandler;
import aroma1997.betterchests.upgrades.impl.plant.PumpkinHandler;
import aroma1997.betterchests.upgrades.impl.plant.ReedHandler;
import aroma1997.betterchests.upgrades.impl.plant.TreeHandler;
import aroma1997.core.inventory.InvUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public enum PlantHarvestHelper implements PlantHarvestRegistry.IPlantHarvestRegistry
{
    INSTANCE;

    private List<IPlantHandler> plantHandlers = new ArrayList<IPlantHandler>();
    private List<IHarvestHandler> harvestHandlers = new ArrayList<IHarvestHandler>();

    @Override
    public void registerPlantingHandler(IPlantHandler handler) {
        this.plantHandlers.add(handler);
    }

    @Override
    public void registerHarvestHandler(IHarvestHandler handler) {
        this.harvestHandlers.add(handler);
    }

    @Override
    public <T extends IPlantHandler & IHarvestHandler> void register(T handler) {
        this.registerPlantingHandler(handler);
        this.registerHarvestHandler(handler);
    }

    @Override
    public List<IPlantHandler> getPlantHandlers() {
        return this.plantHandlers;
    }

    @Override
    public List<IHarvestHandler> getHarvestHandlers() {
        return this.harvestHandlers;
    }

    public void prepareLoading() {
        PlantHarvestRegistry.INSTANCE = this;
        this.register(new CropHandler());
        this.registerHarvestHandler(new ReedHandler());
        this.register(new PumpkinBlockHandler());
        this.register(new PumpkinHandler());
        this.registerHarvestHandler(new NetherWartHandler());
        this.register(new TreeHandler());
        this.register(new CocoaHandler());
    }

    public void finishLoading() {
        Collections.sort(this.plantHandlers, new Comparator<IPlantHandler>(){

            @Override
            public int compare(IPlantHandler o1, IPlantHandler o2) {
                return -Integer.compare(o1.getPlantPriority(), o2.getPlantPriority());
            }
        });
        Collections.sort(this.harvestHandlers, new Comparator<IHarvestHandler>(){

            @Override
            public int compare(IHarvestHandler o1, IHarvestHandler o2) {
                return -Integer.compare(o1.getHarvestPriority(), o2.getHarvestPriority());
            }
        });
        this.plantHandlers = Collections.unmodifiableList(this.plantHandlers);
        this.harvestHandlers = Collections.unmodifiableList(this.harvestHandlers);
    }

    public static void breakBlockHandleDrop(World world, BlockPos pos, IBlockState state, IBetterChest chest) {
        NonNullList list = NonNullList.func_191196_a();
        state.func_177230_c().getDrops(list, (IBlockAccess)world, pos, state, 0);
        boolean change = list.isEmpty();
        for (ItemStack stack : list) {
            if (InvUtil.putStackInInventoryInternal((ItemStack)stack, (IInventory)chest, (boolean)false).func_190916_E() == stack.func_190916_E()) continue;
            change = true;
        }
        if (change) {
            world.func_175698_g(pos);
        }
    }
}

