/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.betterchests.upgrades.impl.plant;

import aroma1997.betterchests.api.IBetterChest;
import aroma1997.betterchests.api.planter.IHarvestHandler;
import aroma1997.betterchests.api.planter.IPlantHandler;
import aroma1997.betterchests.upgrades.impl.plant.PlantHarvestHelper;
import aroma1997.core.inventory.InvUtil;
import aroma1997.core.util.WorldUtil;
import java.util.Collection;
import java.util.stream.Stream;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class CropHandler
implements IPlantHandler,
IHarvestHandler {
    @Override
    public boolean canHandleHarvest(IBlockState state, World world, BlockPos pos) {
        return state.func_177230_c() instanceof IGrowable;
    }

    @Override
    public boolean handleHarvest(IBetterChest chest, IBlockState state, World world, BlockPos pos) {
        IGrowable growable = (IGrowable)state.func_177230_c();
        if (!growable.func_176473_a(world, pos, state, chest.getWorldObj().field_72995_K)) {
            PlantHarvestHelper.breakBlockHandleDrop(world, pos, state, chest);
            return true;
        }
        return false;
    }

    @Override
    public boolean canHandlePlant(Collection<ItemStack> items, World world, BlockPos pos, IBlockState state) {
        if (WorldUtil.isBlockAir((IBlockState)state)) {
            return !this.getStackToPlant(items.stream(), world, pos).func_190926_b();
        }
        return false;
    }

    @Override
    public boolean handlePlant(IBetterChest chest, Collection<ItemStack> items, World world, BlockPos pos) {
        ItemStack toPlant = this.getStackToPlant(items.stream(), world, pos);
        IPlantable plantable = (IPlantable)toPlant.func_77973_b();
        IBlockState current = world.func_180495_p(pos.func_177977_b());
        if (current.func_177230_c().canSustainPlant(current, (IBlockAccess)world, pos, EnumFacing.UP, plantable) || CropHandler.makeFarmland(world, pos, chest, false)) {
            world.func_175656_a(pos, plantable.getPlant((IBlockAccess)world, pos));
            toPlant.func_190920_e(toPlant.func_190916_E() - 1);
            return true;
        }
        return false;
    }

    private ItemStack getStackToPlant(Stream<ItemStack> items, World world, BlockPos pos) {
        BlockPos posToCheck = pos.func_177977_b();
        IBlockState other = world.func_180495_p(posToCheck);
        return items.filter(stack -> stack.func_77973_b() instanceof IPlantable).filter(stack -> {
            IPlantable plant = (IPlantable)stack.func_77973_b();
            return other.func_177230_c().canSustainPlant(other, (IBlockAccess)world, posToCheck, EnumFacing.UP, plant) || Blocks.field_150458_ak.canSustainPlant(Blocks.field_150458_ak.func_176223_P(), (IBlockAccess)world, posToCheck, EnumFacing.UP, plant);
        }).findFirst().orElse(ItemStack.field_190927_a);
    }

    static boolean makeFarmland(World world, BlockPos pos, IBetterChest chest, boolean simulate) {
        int hoe;
        BlockPos below = pos.func_177977_b();
        IBlockState blockBelow = world.func_180495_p(below);
        boolean farmland = false;
        if ((blockBelow.func_177230_c() == Blocks.field_150346_d || blockBelow.func_177230_c() == Blocks.field_150349_c) && (hoe = InvUtil.findInInvInternal((IInventory)chest, null, test -> test.func_77973_b() instanceof ItemHoe)) != -1) {
            farmland = true;
            if (!simulate) {
                ItemStack tool = chest.func_70301_a(hoe);
                tool.func_96631_a(1, world.field_73012_v, null);
                if (tool.func_77952_i() > tool.func_77958_k()) {
                    tool.func_77964_b(0);
                    tool.func_190920_e(tool.func_190916_E() - 1);
                }
                world.func_175656_a(below, Blocks.field_150458_ak.func_176223_P());
            }
        }
        return farmland;
    }

    @Override
    public int getHarvestPriority() {
        return -20;
    }

    @Override
    public int getPlantPriority() {
        return -20;
    }
}

