/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.betterchests.upgrades.impl.plant;

import aroma1997.betterchests.api.IBetterChest;
import aroma1997.betterchests.api.planter.IHarvestHandler;
import aroma1997.betterchests.api.planter.IPlantHandler;
import aroma1997.core.util.WorldUtil;
import java.util.Collection;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CocoaHandler
implements IHarvestHandler,
IPlantHandler {
    @Override
    public boolean canHandlePlant(Collection<ItemStack> items, World world, BlockPos pos, IBlockState state) {
        if (!WorldUtil.isBlockAir((IBlockState)state)) {
            return false;
        }
        boolean found = false;
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            BlockPos toCheck = pos.func_177972_a(dir);
            IBlockState other = world.func_180495_p(toCheck);
            if (other.func_177230_c() != Blocks.field_150364_r || other.func_177229_b((IProperty)BlockOldLog.field_176301_b) != BlockPlanks.EnumType.JUNGLE) continue;
            found = true;
            break;
        }
        return found && items.stream().anyMatch(this::canPlantStack);
    }

    @Override
    public boolean handlePlant(IBetterChest chest, Collection<ItemStack> items, World world, BlockPos pos) {
        EnumFacing jungleBlock = EnumFacing.UP;
        for (EnumFacing side : EnumFacing.field_176754_o) {
            if (!this.isJungleTree(world.func_180495_p(pos.func_177972_a(side)))) continue;
            jungleBlock = side;
            break;
        }
        world.func_175656_a(pos, Blocks.field_150375_by.func_176223_P().func_177226_a((IProperty)BlockCocoa.field_185512_D, (Comparable)jungleBlock));
        ItemStack stack = items.stream().filter(this::canPlantStack).findFirst().get();
        stack.func_190920_e(stack.func_190916_E() - 1);
        return true;
    }

    private boolean canPlantStack(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151100_aR && stack.func_77960_j() == EnumDyeColor.BROWN.func_176767_b();
    }

    @Override
    public boolean canHandleHarvest(IBlockState state, World world, BlockPos pos) {
        if (!this.isJungleTree(state)) {
            return false;
        }
        for (EnumFacing side : EnumFacing.field_176754_o) {
            BlockPos toCheck = pos.func_177972_a(side);
            if (world.func_180495_p(toCheck).func_177230_c() != Blocks.field_150375_by) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean handleHarvest(IBetterChest chest, IBlockState state, World world, BlockPos pos) {
        return false;
    }

    @Override
    public int getHarvestPriority() {
        return 10;
    }

    private boolean isJungleTree(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150364_r && state.func_177229_b((IProperty)BlockOldLog.field_176301_b) == BlockPlanks.EnumType.JUNGLE;
    }
}

