/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.betterchests.upgrades.impl;

import aroma1997.betterchests.Config;
import aroma1997.betterchests.api.IBetterChest;
import aroma1997.betterchests.api.IBetterTank;
import aroma1997.betterchests.api.IUpgradableBlock;
import aroma1997.betterchests.api.UpgradableBlockType;
import aroma1997.betterchests.api.UpgradeHelper;
import aroma1997.betterchests.upgrades.BasicUpgrade;
import aroma1997.core.util.ItemUtil;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class UpgradeWater
extends BasicUpgrade {
    private final FluidStack water = new FluidStack(FluidRegistry.WATER, 1000);

    public UpgradeWater() {
        super(true, 1, new UpgradableBlockType[]{UpgradableBlockType.CHEST, UpgradableBlockType.BAG, UpgradableBlockType.TANK});
    }

    @Override
    public void update(IUpgradableBlock chest, ItemStack stack) {
        FluidTank tank;
        if (UpgradeHelper.INSTANCE.getFrequencyTick(chest, stack, 16) != 0 || !this.hasUpgradeOperationCost(chest)) {
            return;
        }
        if (chest instanceof IBetterChest) {
            IBetterChest inv = (IBetterChest)chest;
            int fluidGotten = 0;
            int containerSlot = -1;
            for (int slot : inv.func_180463_a(null)) {
                ItemStack current = inv.func_70301_a(slot);
                current = current.func_77946_l();
                current.func_190920_e(1);
                IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)current);
                if (handler == null) continue;
                FluidStack gotten = handler.drain(this.water, false);
                if (gotten != null) {
                    assert (gotten.getFluid() == this.water.getFluid());
                    fluidGotten += gotten.amount;
                    continue;
                }
                if (containerSlot != -1 || handler.fill(this.water, false) < 1000) continue;
                containerSlot = slot;
            }
            if (fluidGotten >= 2000 && containerSlot != -1) {
                ItemStack current = inv.func_70301_a(containerSlot);
                current = current.func_77946_l();
                current.func_190920_e(1);
                IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)current);
                handler.fill(new FluidStack(FluidRegistry.WATER, 1000), true);
                current = handler.getContainer();
                int maxStackSize = Math.min(inv.func_70297_j_(), current.func_77976_d());
                for (int slot : inv.func_180463_a(null)) {
                    ItemStack other = inv.func_70301_a(slot);
                    if (other.func_190926_b()) {
                        inv.func_70299_a(slot, current);
                    } else {
                        if (other.func_190916_E() + 1 > maxStackSize || !ItemUtil.areItemsSameMatchingIdDamageNbt((ItemStack)other, (ItemStack)current)) continue;
                        other.func_190920_e(other.func_190916_E() + 1);
                    }
                    inv.func_70298_a(containerSlot, 1);
                    this.drawUpgradeOperationCode(chest);
                    inv.func_70296_d();
                    break;
                }
            }
        } else if (chest instanceof IBetterTank && (tank = ((IBetterTank)chest).getTank()).getFluidAmount() >= 2000 && tank.getFluid().getFluid() == FluidRegistry.WATER) {
            tank.fill(new FluidStack(FluidRegistry.WATER, 1000), true);
        }
    }

    @Override
    public int getUpgradeOperationCost() {
        return Config.INSTANCE.energyWater;
    }
}

