/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.betterchests.upgrades.impl;

import aroma1997.betterchests.Config;
import aroma1997.betterchests.api.IBetterChest;
import aroma1997.betterchests.api.IFilter;
import aroma1997.betterchests.api.IUpgradableBlock;
import aroma1997.betterchests.api.UpgradableBlockType;
import aroma1997.betterchests.api.UpgradeHelper;
import aroma1997.betterchests.api.planter.IPlantHandler;
import aroma1997.betterchests.api.planter.PlantHarvestRegistry;
import aroma1997.betterchests.upgrades.BasicUpgrade;
import aroma1997.core.inventory.InvUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class UpgradePlanting
extends BasicUpgrade {
    public UpgradePlanting() {
        super(true, 5, new UpgradableBlockType[]{UpgradableBlockType.CHEST, UpgradableBlockType.BARREL});
    }

    @Override
    public void update(IUpgradableBlock chest, ItemStack stack) {
        if (!UpgradeHelper.INSTANCE.isFirstUpgrade(chest, stack) || chest.getWorldObj().field_72995_K || !this.hasUpgradeOperationCost(chest)) {
            return;
        }
        int range = chest.getAmountUpgrades(stack) * 4 + 1;
        int states = UpgradeHelper.INSTANCE.getFrequencyTick(chest, stack, range * range);
        int xOffset = states % range - range / 2;
        int zOffset = states / range - range / 2;
        World world = chest.getWorldObj();
        BlockPos pos = chest.getPosition().func_177982_a(xOffset, 0, zOffset);
        if (pos.equals((Object)chest.getPosition())) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c().func_176200_f((IBlockAccess)world, pos)) {
            world.func_175698_g(pos);
        }
        this.plantBlock((IBetterChest)chest, pos, stack);
    }

    private void plantBlock(IBetterChest chest, BlockPos pos, ItemStack upgrade) {
        World world = chest.getWorldObj();
        IBlockState state = world.func_180495_p(pos);
        IFilter filter = chest.getFilterFor(upgrade);
        ArrayList availableItems = Lists.newArrayList(InvUtil.getInvStream((IInventory)chest).filter(filter::matchesStack)::iterator);
        for (IPlantHandler handler : PlantHarvestRegistry.INSTANCE.getPlantHandlers()) {
            if (!handler.canHandlePlant(availableItems, world, pos, state)) continue;
            if (handler.handlePlant(chest, availableItems, world, pos)) {
                this.drawUpgradeOperationCode(chest);
            }
            return;
        }
    }

    @Override
    public int getUpgradeOperationCost() {
        return Config.INSTANCE.energyPlanting;
    }
}

