/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.betterchests.upgrades.impl;

import aroma1997.betterchests.Config;
import aroma1997.betterchests.api.IUpgradableBlock;
import aroma1997.betterchests.api.UpgradableBlockType;
import aroma1997.betterchests.api.UpgradeHelper;
import aroma1997.betterchests.upgrades.BasicUpgrade;
import aroma1997.betterchests.upgrades.DummyUpgradeType;
import gnu.trove.map.hash.TObjectIntHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.math.AxisAlignedBB;

public class UpgradeKilling
extends BasicUpgrade {
    private static final String DAMAGE_DESC = "betterchests:damagesource.killingUpgrade";
    private static final DamageSource DAMAGE_SOURCE = new DamageSource("betterchests:damagesource.killingUpgrade");
    private static final int ANIMALS_TO_KEEP_ALIVE = 2;

    public UpgradeKilling() {
        super(true, 1, new UpgradableBlockType[]{UpgradableBlockType.CHEST, UpgradableBlockType.BARREL});
    }

    @Override
    public void update(IUpgradableBlock chest, ItemStack stack) {
        if (UpgradeHelper.INSTANCE.getFrequencyTick(chest, stack, 100) != 0) {
            return;
        }
        AxisAlignedBB bb = new AxisAlignedBB(chest.getPosition()).func_186662_g(3.0);
        TObjectIntHashMap map = new TObjectIntHashMap();
        for (EntityLiving entity : chest.getWorldObj().func_72872_a(EntityLiving.class, bb)) {
            if (entity.field_70128_L) continue;
            if (entity instanceof EntityAnimal) {
                EntityAnimal animal = (EntityAnimal)entity;
                if (entity.func_70631_g_()) continue;
                int currentAnimals = map.get(animal.getClass());
                if (currentAnimals < 2) {
                    map.put(animal.getClass(), currentAnimals + 1);
                    continue;
                }
            }
            if (!this.hasUpgradeOperationCost(chest)) continue;
            EntityPlayerMP source = null;
            if (chest.isUpgradeInstalled(DummyUpgradeType.AI.getStack())) {
                source = chest.getFakePlayer();
            }
            entity.func_70097_a(UpgradeKilling.getDamageSource((EntityPlayer)source), 10.0f);
            this.drawUpgradeOperationCode(chest);
        }
    }

    public static DamageSource getDamageSource(EntityPlayer source) {
        return source == null ? DAMAGE_SOURCE : new EntityDamageSource(DAMAGE_DESC, (Entity)source);
    }

    @Override
    public int getUpgradeOperationCost() {
        return Config.INSTANCE.energyKilling;
    }
}

