/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.betterchests.upgrades.impl;

import aroma1997.betterchests.Config;
import aroma1997.betterchests.api.IBetterChest;
import aroma1997.betterchests.api.IUpgradableBlock;
import aroma1997.betterchests.api.UpgradableBlockType;
import aroma1997.betterchests.api.UpgradeHelper;
import aroma1997.betterchests.upgrades.BasicUpgrade;
import aroma1997.core.inventory.InvUtil;
import java.util.function.Predicate;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class UpgradeCobbestone
extends BasicUpgrade {
    public static final Predicate<ItemStack> water = UpgradeCobbestone.getFluidPredicate(FluidRegistry.WATER);
    public static final Predicate<ItemStack> lava = UpgradeCobbestone.getFluidPredicate(FluidRegistry.LAVA);

    public UpgradeCobbestone() {
        super(true, 1, UpgradableBlockType.NORMAL_INVENTORIES);
    }

    @Override
    public void update(IUpgradableBlock block, ItemStack stack) {
        if (UpgradeHelper.INSTANCE.getFrequencyTick(block, stack, 8) != 0) {
            return;
        }
        IBetterChest chest = (IBetterChest)block;
        if (this.hasUpgradeOperationCost(chest) && InvUtil.getInvStream((IInventory)chest).anyMatch(water) && InvUtil.getInvStream((IInventory)chest).anyMatch(lava) && InvUtil.putStackInInventoryFirst((ItemStack)new ItemStack(Blocks.field_150347_e), (IInventory)chest, (boolean)true, (boolean)false, (boolean)false, null).func_190926_b()) {
            this.drawUpgradeOperationCode(chest);
            chest.func_70296_d();
        }
    }

    public static Predicate<ItemStack> getFluidPredicate(final Fluid fluid) {
        return new Predicate<ItemStack>(){

            @Override
            public boolean test(ItemStack itemStack) {
                IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)itemStack);
                if (handler == null) {
                    return false;
                }
                for (IFluidTankProperties properties : handler.getTankProperties()) {
                    FluidStack stack = properties.getContents();
                    if (stack == null || stack.getFluid() != fluid) continue;
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    public int getUpgradeOperationCost() {
        return Config.INSTANCE.energyCobblestone;
    }
}

