/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.betterchests.upgrades.impl;

import aroma1997.betterchests.api.IBetterChest;
import aroma1997.betterchests.api.IUpgradableBlock;
import aroma1997.betterchests.api.UpgradableBlockType;
import aroma1997.betterchests.api.UpgradeHelper;
import aroma1997.betterchests.upgrades.BasicUpgrade;
import aroma1997.betterchests.upgrades.PowerUpgradeType;
import java.util.Collections;
import java.util.function.BiPredicate;
import net.minecraft.item.ItemStack;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class UpgradeCharging
extends BasicUpgrade {
    public static BiPredicate<ItemStack, IBetterChest> chargeItem = UpgradeCharging::chargeItem;

    public UpgradeCharging() {
        super(true, 1, UpgradableBlockType.NORMAL_INVENTORIES, () -> Collections.singletonList(PowerUpgradeType.CAPACITOR.getStack()));
    }

    @Override
    public void update(IUpgradableBlock chest, ItemStack stack) {
        int idx;
        if (!this.hasUpgradeOperationCost(chest)) {
            return;
        }
        IBetterChest inv = (IBetterChest)chest;
        int[] availableSlots = inv.func_180463_a(null);
        ItemStack itemToCharge = inv.func_70301_a(availableSlots[idx = UpgradeHelper.INSTANCE.getFrequencyTick(chest, stack, availableSlots.length)]);
        if (itemToCharge.func_190916_E() == 1 && chargeItem.test(itemToCharge, inv)) {
            this.drawUpgradeOperationCode(chest);
        }
    }

    private static boolean chargeItem(ItemStack stack, IBetterChest chest) {
        IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        if (storage != null) {
            int maxCharge = chest.getEnergyStorage().getEnergyStored();
            if ((maxCharge = storage.receiveEnergy(maxCharge, false)) > 0) {
                chest.getEnergyStorage().extractEnergy(maxCharge, false);
                return true;
            }
        }
        return false;
    }
}

