/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.betterchests.upgrades.impl;

import aroma1997.betterchests.Config;
import aroma1997.betterchests.api.IBetterChest;
import aroma1997.betterchests.api.IFilter;
import aroma1997.betterchests.api.IUpgradableBlock;
import aroma1997.betterchests.api.UpgradableBlockType;
import aroma1997.betterchests.api.UpgradeHelper;
import aroma1997.betterchests.upgrades.BasicUpgrade;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;

public class UpgradeBreeding
extends BasicUpgrade {
    static final double RADIUS = 3.0;

    public UpgradeBreeding() {
        super(true, 1, new UpgradableBlockType[]{UpgradableBlockType.CHEST, UpgradableBlockType.BARREL});
    }

    @Override
    public void update(IUpgradableBlock chest, ItemStack stack) {
        if (UpgradeHelper.INSTANCE.getFrequencyTick(chest, stack, 200) != 0) {
            return;
        }
        IBetterChest inv = (IBetterChest)chest;
        IFilter filter = ((IBetterChest)chest).getFilterFor(stack);
        AxisAlignedBB bb = new AxisAlignedBB(chest.getPosition()).func_186662_g(3.0);
        LinkedList list = chest.getWorldObj().func_175647_a(EntityAnimal.class, bb, this::isEntityOk);
        if (list.size() > 50 || !this.hasUpgradeOperationCost(chest)) {
            return;
        }
        list = new LinkedList(list);
        for (int i : inv.func_180463_a(null)) {
            ItemStack breedingItem = inv.func_70301_a(i);
            if (!filter.matchesStack(breedingItem)) continue;
            Iterator iter = list.iterator();
            while (iter.hasNext() && !breedingItem.func_190926_b()) {
                EntityAnimal entity = (EntityAnimal)iter.next();
                assert (this.isEntityOk(entity));
                if (!entity.func_70877_b(breedingItem)) continue;
                entity.func_146082_f(null);
                iter.remove();
                breedingItem.func_190920_e(breedingItem.func_190916_E() - 1);
                this.drawUpgradeOperationCode(chest);
                inv.func_70296_d();
            }
            if (list.isEmpty() || !this.hasUpgradeOperationCost(chest)) break;
        }
    }

    private boolean isEntityOk(EntityAnimal entity) {
        return !entity.field_70128_L && !entity.func_70880_s() && entity.func_70874_b() == 0;
    }

    @Override
    public int getUpgradeOperationCost() {
        return Config.INSTANCE.energyBreeding;
    }
}

