/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.betterchests.upgrades.directional;

import aroma1997.betterchests.Config;
import aroma1997.betterchests.api.IBetterChest;
import aroma1997.betterchests.api.IFilter;
import aroma1997.betterchests.api.IUpgradableBlock;
import aroma1997.betterchests.api.UpgradableBlockType;
import aroma1997.betterchests.upgrades.DummyUpgradeType;
import aroma1997.betterchests.upgrades.directional.DirectionalUpgrade;
import aroma1997.core.inventory.InvUtil;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class UpgradeBreaker
extends DirectionalUpgrade {
    public UpgradeBreaker() {
        super(true, 1, UpgradableBlockType.CHEST.array, () -> Collections.singletonList(DummyUpgradeType.AI.getStack()));
        this.tickTime = 64;
    }

    @Override
    public void update(IUpgradableBlock chest, ItemStack stack) {
        ItemStack targetItem;
        if (this.getTickTime(chest, stack) != 0 || !this.hasUpgradeOperationCost(chest)) {
            return;
        }
        IBetterChest inv = (IBetterChest)chest;
        IFilter filter = ((IBetterChest)chest).getFilterFor(stack);
        int slot = InvUtil.findInInvInternal((IInventory)inv, null, filter::matchesStack);
        if (slot != -1) {
            targetItem = inv.func_70301_a(slot);
        } else if (!filter.hasStackFilter()) {
            targetItem = ItemStack.field_190927_a;
        } else {
            return;
        }
        EntityPlayerMP player = chest.getFakePlayer();
        if (player == null) {
            return;
        }
        BlockPos targetPos = this.getPos(chest, stack);
        player.field_71071_by.func_174888_l();
        player.func_184611_a(EnumHand.MAIN_HAND, targetItem);
        if (this.breakBlock(player, targetPos)) {
            this.drawUpgradeOperationCode(chest);
        }
        if (slot != -1) {
            inv.func_70299_a(slot, player.func_184586_b(EnumHand.MAIN_HAND));
            player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
            for (ItemStack current : InvUtil.getFromInv((IInventory)player.field_71071_by)) {
                current.func_190920_e(InvUtil.putStackInInventoryInternal((ItemStack)current, (IInventory)inv, (boolean)false).func_190916_E());
            }
            player.field_71071_by.func_70436_m();
        }
    }

    public boolean breakBlock(EntityPlayerMP player, BlockPos pos) {
        boolean didRemove;
        World world = player.field_70170_p;
        IBlockState state = world.func_180495_p(pos);
        TileEntity te = world.func_175625_s(pos);
        if (state.func_185887_b(world, pos) < 0.0f || !state.func_177230_c().canHarvestBlock((IBlockAccess)world, pos, (EntityPlayer)player)) {
            return false;
        }
        ItemStack stack = player.func_184614_ca();
        if (!stack.func_190926_b() && stack.func_77973_b().onBlockStartBreak(stack, pos, (EntityPlayer)player)) {
            return false;
        }
        world.func_180498_a((EntityPlayer)player, 2001, pos, Block.func_176210_f((IBlockState)state));
        ItemStack itemHand = player.func_184614_ca();
        ItemStack itemHandCopy = itemHand.func_190926_b() ? ItemStack.field_190927_a : itemHand.func_77946_l();
        boolean canHarvest = state.func_177230_c().canHarvestBlock((IBlockAccess)world, pos, (EntityPlayer)player);
        if (!itemHand.func_190926_b()) {
            itemHand.func_179548_a(world, state, pos, (EntityPlayer)player);
            if (itemHand.func_190926_b()) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)itemHandCopy, (EnumHand)EnumHand.MAIN_HAND);
            }
        }
        if ((didRemove = this.removeBlock(player, pos, canHarvest)) && canHarvest) {
            state.func_177230_c().func_180657_a(world, (EntityPlayer)player, pos, state, te, itemHandCopy);
        }
        return didRemove;
    }

    private boolean removeBlock(EntityPlayerMP player, BlockPos pos, boolean canHarvest) {
        World world = player.field_70170_p;
        IBlockState iblockstate = world.func_180495_p(pos);
        boolean didRemove = iblockstate.func_177230_c().removedByPlayer(iblockstate, world, pos, (EntityPlayer)player, canHarvest);
        if (didRemove) {
            iblockstate.func_177230_c().func_176206_d(world, pos, iblockstate);
        }
        return didRemove;
    }

    @Override
    public int getUpgradeOperationCost() {
        return Config.INSTANCE.energyBreaker;
    }
}

