/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.betterchests.upgrades;

import aroma1997.betterchests.upgrades.ItemUpgrade;
import aroma1997.core.util.LocalizationHelper;
import aroma1997.core.util.ServerUtil;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemUpgradeDirectional<T extends Enum<?>>
extends ItemUpgrade<T> {
    public ItemUpgradeDirectional(Class<T> clazz) {
        super(clazz);
    }

    public EnumFacing getSide(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_150297_b("dir", 3)) {
            return null;
        }
        int val = nbt.func_74762_e("dir");
        if (val < 0 || val >= EnumFacing.field_82609_l.length) {
            return null;
        }
        return EnumFacing.field_82609_l[val];
    }

    public void setSide(ItemStack stack, EnumFacing side) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        int target = -1;
        if (side != null) {
            target = side.ordinal();
        }
        nbt.func_74768_a("dir", target);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            this.setSide(stack, null);
            player.func_145747_a(ServerUtil.getChatForString((String)this.getTooltipName(stack)));
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            ItemStack stack = player.func_184586_b(hand);
            EnumFacing currentSide = this.getSide(stack);
            if (currentSide == facing) {
                facing = null;
            }
            this.setSide(stack, facing);
            player.func_145747_a(ServerUtil.getChatForString((String)this.getTooltipName(stack)));
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        tooltip.add(this.getTooltipName(stack));
    }

    private String getTooltipName(ItemStack stack) {
        return LocalizationHelper.localize((String)("betterchests:tooltip.directionalupgrade." + this.getSide(stack)));
    }
}

