/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.betterchests.inventories;

import aroma1997.betterchests.api.IUpgradableBlock;
import aroma1997.betterchests.api.IUpgrade;
import aroma1997.betterchests.inventories.IBetterChestInternal;
import aroma1997.betterchests.inventories.IUpgradableBlockInternal;
import aroma1997.core.block.te.TileEntityBase;
import aroma1997.core.inventory.IInventoryPartContainer;
import aroma1997.core.inventory.inventorypart.InventoryPartBase;
import aroma1997.core.network.AutoEncode;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.StreamSupport;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class InventoryPartUpgrades
extends InventoryPartBase {
    private static final int size = 16;
    @AutoEncode
    private boolean[] disabled = new boolean[16];

    public InventoryPartUpgrades(IInventoryPartContainer container) {
        super(container, "betterchests:inventorypart.upgrades", 16, false, false);
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() instanceof IUpgrade && ((IUpgrade)stack.func_77973_b()).canBePutInChest(this.getChest(), stack) && ((IUpgrade)stack.func_77973_b()).areRequirementsMet(this.getChest(), stack);
    }

    private int getIndex(ItemStack stack) {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack currentStack = this.func_70301_a(i);
            if (currentStack != stack) continue;
            return i;
        }
        throw new IllegalArgumentException("cannot get index of stack, if stack is not in the inventory");
    }

    public boolean isUpgradeDisabled(ItemStack stack) {
        return this.disabled[this.getIndex(stack)];
    }

    public void setUpgradeDisabled(ItemStack stack, boolean value) {
        if (((IUpgrade)stack.func_77973_b()).canBeDisabled(stack)) {
            this.disabled[this.getIndex((ItemStack)stack)] = value;
            this.func_70296_d();
        }
    }

    protected IUpgradableBlockInternal getChest() {
        return (IUpgradableBlockInternal)this.container;
    }

    public void markDirtyInternal() {
        super.markDirtyInternal();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (!this.func_70301_a(i).func_190926_b()) continue;
            this.disabled[i] = false;
        }
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        if (this.getChest() instanceof TileEntityBase) {
            ((TileEntityBase)this.getChest()).sendUpdates();
        }
        if (this.getChest() instanceof IBetterChestInternal) {
            ((IBetterChestInternal)this.getChest()).getChestPart().markDirtyInternal();
        }
    }

    public int func_70297_j_() {
        return 1;
    }

    public Iterator<ItemStack> getActiveUpgrades() {
        return StreamSupport.stream(this.spliterator(), false).filter(stack -> !this.isUpgradeDisabled((ItemStack)stack)).iterator();
    }

    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        Arrays.fill(this.disabled, false);
        NBTTagList list = nbt.func_150295_c("disabled", 3);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            this.disabled[((NBTTagInt)list.func_179238_g((int)i)).func_150287_d()] = true;
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt = super.writeToNBT(nbt);
        NBTTagList disabledList = new NBTTagList();
        for (int i = 0; i < this.disabled.length; ++i) {
            if (!this.disabled[i]) continue;
            disabledList.func_74742_a((NBTBase)new NBTTagInt(i));
        }
        nbt.func_74782_a("disabled", (NBTBase)disabledList);
        return nbt;
    }

    public void tick() {
        for (ItemStack upgrade : this::getActiveUpgrades) {
            try {
                ((IUpgrade)upgrade.func_77973_b()).update((IUpgradableBlock)this.container, upgrade);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.setUpgradeDisabled(upgrade, true);
            }
        }
    }
}

