/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.betterchests.inventories;

import aroma1997.betterchests.UpgradeHelper;
import aroma1997.betterchests.api.ChestModifier;
import aroma1997.betterchests.inventories.IUpgradableBlockInternal;
import aroma1997.betterchests.inventories.InventoryPartChest;
import aroma1997.core.block.te.TileEntityBase;
import aroma1997.core.network.AutoEncode;
import aroma1997.core.util.ItemUtil;
import java.util.BitSet;
import java.util.Iterator;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class InventoryPartBarrel
extends InventoryPartChest {
    private static final int MAX_SIZE = 256;
    private static final int DEFAULT_SIZE = 32;
    private BitSet usedSlots = new BitSet(256);
    @AutoEncode
    private ItemStack dummy = ItemStack.field_190927_a;

    public InventoryPartBarrel(IUpgradableBlockInternal container) {
        super(container, 256);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return !this.isItemSet() || this.dummy.func_190926_b() || ItemUtil.areItemsSameMatchingIdDamageNbt((ItemStack)this.dummy, (ItemStack)stack);
    }

    @Override
    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        return this.func_94041_b(index, stack) && (!this.isItemSet() || ItemUtil.areItemsSameMatchingIdDamageNbt((ItemStack)this.dummy, (ItemStack)stack));
    }

    public int func_70302_i_() {
        return 256;
    }

    @Override
    public int getActualSize() {
        int size = 32 + UpgradeHelper.INSTANCE.intSum(this.getChest(), ChestModifier.SIZE);
        return Math.min(size, 256);
    }

    @Override
    public int getAccessibleBegin() {
        return 0;
    }

    public boolean func_191420_l() {
        return FMLCommonHandler.instance().getEffectiveSide().isServer() ? this.usedSlots.isEmpty() : super.func_191420_l();
    }

    public void func_174888_l() {
        super.func_174888_l();
        this.usedSlots.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack func_70298_a(int index, int count) {
        try {
            ItemStack itemStack = super.func_70298_a(index, count);
            return itemStack;
        }
        finally {
            this.update(index);
        }
    }

    public ItemStack func_70304_b(int index) {
        try {
            ItemStack itemStack = super.func_70304_b(index);
            return itemStack;
        }
        finally {
            this.update(index);
        }
    }

    public void func_70299_a(int index, ItemStack stack) {
        super.func_70299_a(index, stack);
        if (this.dummy.func_190926_b() || this.func_191420_l()) {
            this.dummy = stack.func_77946_l();
        }
        this.update(index);
    }

    protected void update(int slot) {
        this.usedSlots.set(slot, !this.func_70301_a(slot).func_190926_b());
    }

    public ItemStack getDummy() {
        return this.dummy;
    }

    public boolean isItemSet() {
        return !this.func_191420_l() || !this.canChangeItem();
    }

    private boolean canChangeItem() {
        return !UpgradeHelper.INSTANCE.booleanSum(this.getChest(), ChestModifier.ACCEPTANCE_LOCK, false);
    }

    public int getTotalAmountOfItems() {
        int amount = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ItemStack stack = (ItemStack)iterator.next();
            amount += stack.func_190916_E();
        }
        return amount;
    }

    public void markDirtyInternal() {
        super.markDirtyInternal();
        if (this.getChest() instanceof TileEntityBase) {
            ((TileEntityBase)this.getChest()).sendUpdates();
        }
        if (this.func_191420_l() && this.canChangeItem()) {
            this.dummy = ItemStack.field_190927_a;
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.dummy = new ItemStack(nbt.func_74775_l("dummy"));
        super.readFromNBT(nbt);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt = super.writeToNBT(nbt);
        nbt.func_74782_a("dummy", (NBTBase)this.dummy.func_77955_b(new NBTTagCompound()));
        return nbt;
    }

    public String getAmountDescr() {
        ItemStack stack = this.getDummy();
        int stacksize = stack.func_77976_d();
        int totalAmount = this.getTotalAmountOfItems();
        String text = totalAmount >= stacksize && stacksize > 1 ? totalAmount / stacksize + "x" + stacksize + "+" + totalAmount % stacksize : "" + totalAmount;
        return text;
    }
}

