/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.betterchests.integration.storagedrawers;

import aroma1997.betterchests.chest.TileEntityBBarrel;
import aroma1997.betterchests.inventories.InventoryPartBarrel;
import aroma1997.core.inventory.InvUtil;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BlockHandler {
    private static final ResourceLocation rl = new ResourceLocation("betterchests:storagedrawerscaps");
    @CapabilityInject(value=IDrawerGroup.class)
    static Capability<IDrawerGroup> DRAWER_GROUP;

    BlockHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void initTe(AttachCapabilitiesEvent<TileEntity> event) {
        if (event.getObject() instanceof TileEntityBBarrel) {
            TileEntityBBarrel chest = (TileEntityBBarrel)event.getObject();
            event.addCapability(rl, (ICapabilityProvider)new CapabilityHandler(chest));
        }
    }

    private static class CapabilityHandler
    implements ICapabilityProvider,
    IDrawerGroup,
    IDrawer {
        private final TileEntityBBarrel barrel;
        private ItemStack buffer;

        public CapabilityHandler(TileEntityBBarrel barrel) {
            this.barrel = barrel;
        }

        public int getDrawerCount() {
            return 1;
        }

        @Nonnull
        public IDrawer getDrawer(int slot) {
            return this;
        }

        @Nonnull
        public int[] getAccessibleDrawerSlots() {
            return new int[]{0};
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == DRAWER_GROUP;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == DRAWER_GROUP ? this : null);
        }

        @Nonnull
        public ItemStack getStoredItemPrototype() {
            return this.barrel.getChestPart().isItemSet() ? this.barrel.getChestPart().getDummy() : ItemStack.field_190927_a;
        }

        @Nonnull
        public IDrawer setStoredItem(@Nonnull ItemStack itemPrototype) {
            this.buffer = itemPrototype.func_77946_l();
            return this;
        }

        public int getStoredItemCount() {
            return this.barrel.getChestPart().getTotalAmountOfItems();
        }

        public void setStoredItemCount(int amount) {
            int totalAmount = this.getStoredItemCount();
            InventoryPartBarrel part = this.barrel.getChestPart();
            int size = part.getActualSize();
            if (totalAmount >= amount) {
                int diff = totalAmount - amount;
                for (int i = 0; i < size && diff > 0; diff -= part.func_70298_a(i, diff).func_190916_E(), ++i) {
                }
            } else {
                int diff = amount - totalAmount;
                ItemStack stack = this.getBuffer().func_77946_l();
                stack.func_190920_e(diff);
                InvUtil.putStackInInventoryFirst((ItemStack)stack, (IInventory)part, (boolean)true, (boolean)false, (boolean)false, null);
            }
            this.barrel.getChestPart().func_70296_d();
        }

        public int getMaxCapacity(@Nonnull ItemStack itemPrototype) {
            return this.barrel.getChestPart().getActualSize() * itemPrototype.func_77976_d();
        }

        public int getRemainingCapacity() {
            return this.barrel.getChestPart().func_191420_l() ? this.barrel.getChestPart().getActualSize() * 64 : this.getMaxCapacity(this.barrel.getChestPart().getDummy()) - this.getStoredItemCount();
        }

        public boolean canItemBeStored(@Nonnull ItemStack itemPrototype, Predicate<ItemStack> matchPredicate) {
            return this.barrel.getChestPart().func_180462_a(0, itemPrototype, null);
        }

        public boolean canItemBeExtracted(@Nonnull ItemStack itemPrototype, Predicate<ItemStack> matchPredicate) {
            return true;
        }

        public boolean isEmpty() {
            return this.barrel.getChestPart().func_191420_l();
        }

        private ItemStack getBuffer() {
            if (this.isEmpty()) {
                return this.buffer;
            }
            return this.barrel.getChestPart().getDummy();
        }
    }
}

