/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.betterchests.integration.ic2;

import aroma1997.betterchests.api.IUpgradableBlock;
import aroma1997.core.block.te.TileEntityBase;
import aroma1997.core.block.te.element.EnergyElement;
import aroma1997.core.block.te.element.TileEntityElementBase;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.info.ILocatable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BlockHandler {
    public BlockHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void initTe(AttachCapabilitiesEvent<TileEntity> event) {
        if (event.getObject() instanceof IUpgradableBlock && event.getObject() instanceof TileEntityBase) {
            TileEntityBase chest = (TileEntityBase)event.getObject();
            chest.addElement((TileEntityElementBase)new IC2EnergyElement(chest));
        }
    }

    public static class IC2EnergyElement
    extends TileEntityElementBase
    implements IEnergySink,
    ILocatable {
        public IC2EnergyElement(TileEntityBase parent) {
            super(parent);
        }

        public void load() {
            EnergyNet.instance.addTile((ILocatable)this);
        }

        public void unload() {
            EnergyNet.instance.removeTile((IEnergyTile)this);
        }

        public double getDemandedEnergy() {
            return (double)this.getEnergyElement().receiveEnergy(Integer.MAX_VALUE, true) * 0.125;
        }

        public int getSinkTier() {
            return Integer.MAX_VALUE;
        }

        public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
            return amount - (double)this.getEnergyElement().receiveEnergy((int)(amount / 0.125), false) * 0.125;
        }

        public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
            return true;
        }

        public BlockPos getPosition() {
            return this.getParent().func_174877_v();
        }

        public World getWorldObj() {
            return this.getParent().func_145831_w();
        }

        private EnergyElement getEnergyElement() {
            return (EnergyElement)this.getParent().getElement(EnergyElement.class);
        }
    }
}

