/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.betterchests.filter;

import aroma1997.betterchests.api.IUpgrade;
import aroma1997.betterchests.client.gui.GuiFilter;
import aroma1997.betterchests.container.ContainerFilter;
import aroma1997.core.inventory.IInventoryPartContainer;
import aroma1997.core.inventory.ItemInventory;
import aroma1997.core.inventory.inventorypart.InventoryPartBase;
import aroma1997.core.inventory.inventorypart.InventoryPartClass;
import aroma1997.core.network.ClientSettable;
import aroma1997.core.util.ItemUtil;
import java.util.ArrayList;
import java.util.stream.StreamSupport;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class InventoryFilter
extends ItemInventory {
    public final InventoryPartBase filterInv = new InventoryPartBase((IInventoryPartContainer)this, "betterchests:inventorypart.filter", 9, false, false);
    public final InventoryPartBase upgradeInv = new InventoryPartClass((IInventoryPartContainer)this, "betterchests:inventorypart.upgrade", 1, false, false, IUpgrade.class);
    @ClientSettable
    private boolean checknbt;
    @ClientSettable
    private boolean checkdamage;
    @ClientSettable
    boolean isBlacklist;

    public InventoryFilter(ItemStack stack) {
        super(stack);
        this.load();
    }

    public Container getContainer(EntityPlayer player, short id) {
        return new ContainerFilter(this, player);
    }

    @SideOnly(value=Side.CLIENT)
    public Gui getGui(EntityPlayer player, short id) {
        return new GuiFilter(new ContainerFilter(this, player));
    }

    public boolean appliesToUpgrade(ItemStack stack) {
        return this.upgradeInv.func_191420_l() || ItemUtil.areItemsSameMatchingIdDamage((ItemStack)stack, (ItemStack)this.upgradeInv.get());
    }

    public boolean isAffected(ItemStack stack) {
        ItemUtil.IItemMatchCriteria[] crits = this.getMatchCriteria();
        return StreamSupport.stream(this.filterInv.spliterator(), false).anyMatch(other -> ItemUtil.areItemsSameMatching((ItemStack)stack, (ItemStack)other, (ItemUtil.IItemMatchCriteria[])crits));
    }

    ItemUtil.IItemMatchCriteria[] getMatchCriteria() {
        ArrayList<ItemUtil.IItemMatchCriteria> criteria = new ArrayList<ItemUtil.IItemMatchCriteria>(3);
        criteria.add(ItemUtil.IItemMatchCriteria.ID);
        if (this.checkdamage) {
            criteria.add(ItemUtil.IItemMatchCriteria.DAMAGE);
        }
        if (this.checknbt) {
            criteria.add(ItemUtil.IItemMatchCriteria.NBT);
        }
        return criteria.toArray(new ItemUtil.IItemMatchCriteria[0]);
    }

    public boolean isBlacklist() {
        return this.isBlacklist;
    }

    protected void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.checkdamage = compound.func_74767_n("checkdamage");
        this.checknbt = compound.func_74767_n("checknbt");
        this.isBlacklist = compound.func_74767_n("isBlacklist");
    }

    protected NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound = super.writeToNBT(compound);
        compound.func_74757_a("checknbt", this.checknbt);
        compound.func_74757_a("checkdamage", this.checkdamage);
        compound.func_74757_a("isBlacklist", this.isBlacklist);
        return compound;
    }
}

