/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.betterchests.client.model;

import aroma1997.betterchests.filter.ItemFilter;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelFilter
implements IModel {
    private static ResourceLocation whitelistRL = new ResourceLocation("betterchests:item/filter.whitelist");
    private static ResourceLocation blacklistRL = new ResourceLocation("betterchests:item/filter.blacklist");

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.of((Object)whitelistRL, (Object)blacklistRL);
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IBakedModel blacklist;
        IBakedModel whitelist;
        try {
            whitelist = ModelLoaderRegistry.getModel((ResourceLocation)whitelistRL).bake(state, format, bakedTextureGetter);
            blacklist = ModelLoaderRegistry.getModel((ResourceLocation)blacklistRL).bake(state, format, bakedTextureGetter);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new BakedModelFilter(whitelist, blacklist);
    }

    private static class BakedModelFilter
    implements IBakedModel {
        private final IBakedModel whitelist;
        private final IBakedModel blacklist;

        public BakedModelFilter(IBakedModel whitelist, IBakedModel blacklist) {
            this.whitelist = whitelist;
            this.blacklist = blacklist;
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            return this.whitelist.func_188616_a(state, side, rand);
        }

        public boolean func_177555_b() {
            return this.whitelist.func_177555_b();
        }

        public boolean func_177556_c() {
            return this.whitelist.func_177556_c();
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.whitelist.func_177554_e();
        }

        public ItemOverrideList func_188617_f() {
            return new ItemOverrideList(Collections.emptyList()){

                public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
                    if (ItemFilter.getInventoryFor(stack).isBlacklist()) {
                        return blacklist;
                    }
                    return whitelist;
                }
            };
        }
    }
}

