/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.betterchests.client.gui;

import aroma1997.core.client.gui.GuiBase;
import aroma1997.core.client.gui.IRenderable;
import aroma1997.core.client.gui.elements.GuiElementButton;
import aroma1997.core.network.NetworkHelper;
import aroma1997.core.network.packets.PacketContainerUpdate;
import aroma1997.core.util.LocalizationHelper;
import aroma1997.core.util.ReflectionUtil;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.inventory.IInventory;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiElementToggle
extends GuiElementButton {
    private String field;

    public GuiElementToggle(GuiBase<?> gui, int x, int y, String field) {
        super(gui, x, y, 28);
        this.field = field;
        this.addHoverTooltip(() -> LocalizationHelper.localize((String)("betterchests:gui.filter." + field + "." + this.getState())));
    }

    protected void onButtonClick(int x, int y) {
        IInventory inv = this.gui.getContainer().inventory;
        try {
            Field f = ReflectionUtil.getFieldInClassOrSuperclass(inv.getClass(), (String)this.field);
            f.setAccessible(true);
            f.setBoolean(inv, !f.getBoolean(inv));
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            return;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return;
        }
        PacketContainerUpdate update = new PacketContainerUpdate(this.gui.field_147002_h, field -> false, field -> field.getName().equals(this.field));
        NetworkHelper.getCorePacketHandler().sendPacketToPlayers((IMessage)update);
    }

    public boolean getState() {
        IInventory inv = this.gui.getContainer().inventory;
        try {
            Field f = ReflectionUtil.getFieldInClassOrSuperclass(inv.getClass(), (String)this.field);
            f.setAccessible(true);
            return f.getBoolean(inv);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return false;
    }

    public IRenderable getRenderable() {
        return new IRenderable(){

            public void render(int x, int y, Gui gui, TextureManager textureManager) {
                String str = LocalizationHelper.localize((String)("betterchests:gui.filter." + GuiElementToggle.this.field + ".desc"));
                FontRenderer render = Minecraft.func_71410_x().field_71466_p;
                int len = render.func_78256_a(str);
                render.func_78276_b(str, x + GuiElementToggle.this.location.getWidth() / 2 - (len + 1) / 2, y + 6, GuiElementToggle.this.getState() ? -16711936 : -65536);
            }
        };
    }
}

