/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.betterchests.client;

import aroma1997.betterchests.api.IUpgrade;
import aroma1997.betterchests.api.UpgradableBlockType;
import aroma1997.betterchests.client.LayerBag;
import aroma1997.core.coremod.MCPNames;
import aroma1997.core.util.LocalizationHelper;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientEventListener {
    static Set<Integer> entitiesWithBag = Collections.emptySet();
    private LayerBag render;
    private static Field renderLayers;

    public ClientEventListener() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void drawTooltips(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() instanceof IUpgrade) {
            Collection<ItemStack> requiredUpgrades;
            IUpgrade upgrade = (IUpgrade)stack.func_77973_b();
            List tooltips = event.getToolTip();
            Collection<UpgradableBlockType> compatibleBlocks = upgrade.getCompatibleTypes(stack);
            for (UpgradableBlockType type : compatibleBlocks) {
                tooltips.add(LocalizationHelper.localize((String)("betterchests:tooltip.compatible." + type.name().toLowerCase())));
            }
            int maxUpgrades = upgrade.getMaxAmountUpgrades(stack);
            if (maxUpgrades > 0 && maxUpgrades < Integer.MAX_VALUE) {
                tooltips.add(LocalizationHelper.localizeFormatted((String)"betterchests:tooltip.maxUpgrades", (Object[])new Object[]{maxUpgrades}));
            }
            if (!(requiredUpgrades = upgrade.getRequiredUpgrades(stack)).isEmpty()) {
                tooltips.add(LocalizationHelper.localize((String)"betterchests:tooltip.requiredUpgrades"));
                for (ItemStack req : requiredUpgrades) {
                    tooltips.add("  " + req.func_82833_r());
                }
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void render(RenderLivingEvent.Pre<EntityLivingBase> event) throws NoSuchFieldException {
        EntityLivingBase entity = event.getEntity();
        if (entitiesWithBag.contains(entity.func_145782_y())) {
            this.render = new LayerBag();
            if (renderLayers == null) {
                renderLayers = RenderLivingBase.class.getDeclaredField(MCPNames.field((String)"field_177097_h"));
                renderLayers.setAccessible(true);
            }
            event.getRenderer().func_177094_a((LayerRenderer)this.render);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderPost(RenderLivingEvent.Post<EntityLivingBase> event) throws IllegalAccessException {
        if (this.render != null) {
            boolean success = ((List)renderLayers.get(event.getRenderer())).remove((Object)this.render);
            assert (success);
            this.render = null;
        }
    }
}

