/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.betterchests.chest;

import aroma1997.betterchests.UpgradeHelper;
import aroma1997.betterchests.api.ChestModifier;
import aroma1997.betterchests.api.IFilter;
import aroma1997.betterchests.inventories.IUpgradableBlockInternal;
import aroma1997.betterchests.inventories.InventoryPartFilter;
import aroma1997.betterchests.inventories.InventoryPartUpgrades;
import aroma1997.core.block.te.TileEntityBase;
import aroma1997.core.block.te.TileEntityInventory;
import aroma1997.core.block.te.element.EnergyElement;
import aroma1997.core.block.te.element.FakePlayerElement;
import aroma1997.core.block.te.element.RedstoneEmitterElement;
import aroma1997.core.block.te.element.TileEntityElementBase;
import aroma1997.core.container.IGuiProvider;
import aroma1997.core.network.AutoEncode;
import aroma1997.core.util.ItemUtil;
import aroma1997.core.util.Util;
import java.util.stream.StreamSupport;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class TileEntityUpgradableBlockBase
extends TileEntityInventory
implements IUpgradableBlockInternal,
IGuiProvider,
ITickable {
    @AutoEncode
    protected final InventoryPartUpgrades upgradeInv;
    @AutoEncode
    protected final InventoryPartFilter filterInv;
    protected final FakePlayerElement fakePlayer;
    protected final RedstoneEmitterElement redstoneEmitter;
    private int tickCount = Util.getRandom().nextInt();
    @AutoEncode.GuiEncode
    public final EnergyElement energy;
    private Vec3d posPrecise;

    public TileEntityUpgradableBlockBase() {
        this.upgradeInv = new InventoryPartUpgrades(this);
        this.filterInv = new InventoryPartFilter(this);
        this.energy = (EnergyElement)this.addElement((TileEntityElementBase)new EnergyElement((TileEntityBase)this, 0, Integer.MAX_VALUE, 0){

            public int getMaxEnergyStored() {
                return UpgradeHelper.INSTANCE.getPowerCapacity(TileEntityUpgradableBlockBase.this);
            }
        });
        this.fakePlayer = (FakePlayerElement)this.addElement((TileEntityElementBase)new FakePlayerElement((TileEntityBase)this));
        this.comparator.setRedstoneLookup(() -> UpgradeHelper.INSTANCE.intSumFirst(this, ChestModifier.COMPARATOR, 0));
        this.redstoneEmitter = (RedstoneEmitterElement)this.addElement((TileEntityElementBase)new RedstoneEmitterElement((TileEntityBase)this));
        this.redstoneEmitter.setRedstoneLookup(() -> UpgradeHelper.INSTANCE.intSumFirst(this, ChestModifier.REDSTONE, 0));
    }

    @Override
    public Vec3d getPositionPrecise() {
        if (this.posPrecise == null) {
            this.posPrecise = new Vec3d((Vec3i)this.func_174877_v()).func_178787_e(new Vec3d(0.5, 0.5, 0.5));
        }
        return this.posPrecise;
    }

    @Override
    public BlockPos getPosition() {
        return this.field_174879_c;
    }

    @Override
    public World getWorldObj() {
        return this.field_145850_b;
    }

    @Override
    public Iterable<ItemStack> getUpgrades() {
        return this.upgradeInv;
    }

    @Override
    public int getAmountUpgrades(ItemStack stack) {
        return (int)StreamSupport.stream(this.upgradeInv.spliterator(), false).filter(other -> ItemUtil.areItemsSameMatchingIdDamage((ItemStack)stack, (ItemStack)other)).count();
    }

    @Override
    public boolean isUpgradeDisabled(ItemStack stack) {
        return this.upgradeInv.isUpgradeDisabled(stack);
    }

    @Override
    public void setUpgradeDisabled(ItemStack stack, boolean targetVal) {
        this.upgradeInv.setUpgradeDisabled(stack, targetVal);
    }

    public void func_174889_b(EntityPlayer player) {
        super.func_174889_b(player);
        this.func_70296_d();
    }

    public void func_174886_c(EntityPlayer player) {
        super.func_174886_c(player);
        this.func_70296_d();
    }

    @Override
    public IEnergyStorage getEnergyStorage() {
        return this.energy;
    }

    @Override
    public InventoryPartUpgrades getUpgradePart() {
        return this.upgradeInv;
    }

    @Override
    public InventoryPartFilter getFilterPart() {
        return this.filterInv;
    }

    public void func_73660_a() {
        super.func_73660_a();
        ++this.tickCount;
        this.upgradeInv.tick();
    }

    @Override
    public int getTickCount() {
        return this.tickCount;
    }

    @Override
    public EntityPlayerMP getFakePlayer() {
        return this.fakePlayer.getFakePlayer();
    }

    @Override
    public IFilter getFilterFor(ItemStack stack) {
        return this.filterInv.getFilterForUpgrade(stack);
    }
}

