/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.betterchests.bag;

import aroma1997.betterchests.UpgradeHelper;
import aroma1997.betterchests.api.IMobileUpgradableBlock;
import aroma1997.betterchests.inventories.IUpgradableBlockInternal;
import aroma1997.betterchests.inventories.InventoryPartFilter;
import aroma1997.betterchests.inventories.InventoryPartUpgrades;
import aroma1997.core.inventory.ItemInventory;
import aroma1997.core.network.AutoEncode;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class BasicBagInventory
extends ItemInventory
implements IMobileUpgradableBlock,
IUpgradableBlockInternal,
IEnergyStorage {
    private final InventoryPartUpgrades upgradeInv;
    private final InventoryPartFilter filterInv;
    private int currentTime;
    private final IEnergyStorage external = new IEnergyStorage(){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return BasicBagInventory.this.receiveEnergy(maxReceive, simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return BasicBagInventory.this.energy;
        }

        public int getMaxEnergyStored() {
            return BasicBagInventory.this.getMaxEnergyStored();
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }
    };
    @AutoEncode.GuiEncode
    private int energy;
    protected final Entity entity;

    public BasicBagInventory(Entity entity, ItemStack stack) {
        super(stack);
        this.entity = entity;
        this.upgradeInv = new InventoryPartUpgrades(this);
        this.filterInv = new InventoryPartFilter(this);
    }

    @Override
    public Vec3d getPositionPrecise() {
        if (this.getEntity() != null) {
            return this.getEntity().func_174791_d();
        }
        return null;
    }

    @Override
    public BlockPos getPosition() {
        if (this.getEntity() != null) {
            return this.getEntity().func_180425_c();
        }
        return null;
    }

    @Override
    public World getWorldObj() {
        if (this.getEntity() != null) {
            return this.getEntity().field_70170_p;
        }
        return null;
    }

    @Override
    public InventoryPartUpgrades getUpgradePart() {
        return this.upgradeInv;
    }

    @Override
    public InventoryPartFilter getFilterPart() {
        return this.filterInv;
    }

    @Override
    public IEnergyStorage getEnergyStorage() {
        return this;
    }

    @Override
    public int getTickCount() {
        return this.currentTime;
    }

    @Override
    public EntityPlayerMP getFakePlayer() {
        return null;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.external;
        }
        return null;
    }

    protected void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.energy = compound.func_74762_e("energy");
    }

    protected NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound = super.writeToNBT(compound);
        compound.func_74768_a("energy", this.energy);
        return compound;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int ret = Math.max(Math.min(this.getMaxEnergyStored() - this.energy, maxReceive), 0);
        if (!simulate) {
            this.energy += ret;
            this.func_70296_d();
        }
        return ret;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int ret = Math.max(Math.min(this.energy, maxExtract), 0);
        if (!simulate) {
            this.energy -= ret;
            this.func_70296_d();
        }
        return ret;
    }

    public int getEnergyStored() {
        return Math.min(this.energy, this.getMaxEnergyStored());
    }

    public int getMaxEnergyStored() {
        return UpgradeHelper.INSTANCE.getPowerCapacity(this);
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    public void tick() {
        ++this.currentTime;
        this.getUpgradePart().tick();
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }
}

