/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.betterchests;

import aroma1997.betterchests.BlocksItemsBetterChests;
import aroma1997.betterchests.api.ChestModifier;
import aroma1997.betterchests.api.IUpgradableBlock;
import aroma1997.betterchests.api.IUpgrade;
import aroma1997.betterchests.api.UpgradeHelper;
import aroma1997.betterchests.bag.ItemBBag;
import aroma1997.betterchests.bag.ItemBPortableBarrel;
import aroma1997.core.util.ItemUtil;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public enum UpgradeHelper implements UpgradeHelper.IUpgradeHelper
{
    INSTANCE;


    public int intSumInBounds(IUpgradableBlock block, ChestModifier modifier, int lower, int higher) {
        return this.inBounds(this.intSum(block, modifier), lower, higher);
    }

    public int intSum(IUpgradableBlock block, ChestModifier modifier) {
        int i = 0;
        for (ItemStack stack : block.getActiveUpgrades()) {
            Number num = ((IUpgrade)stack.func_77973_b()).getChestModifier(block, modifier, stack);
            if (num == null) continue;
            i += num.intValue();
        }
        return i;
    }

    public int getPowerCapacity(IUpgradableBlock block) {
        return this.intSum(block, ChestModifier.ENERGY_CAPACITY) + 50000;
    }

    public int intSumCapped(IUpgradableBlock block, ChestModifier modifier, int min, int max) {
        int i = this.inBounds(0, min, max);
        for (ItemStack stack : block.getActiveUpgrades()) {
            Number num = ((IUpgrade)stack.func_77973_b()).getChestModifier(block, modifier, stack);
            if (num == null) continue;
            i = this.inBounds(i + num.intValue(), min, max);
        }
        return i;
    }

    public int intSumFirst(IUpgradableBlock block, ChestModifier modifier, int defaultValue) {
        for (ItemStack stack : block.getActiveUpgrades()) {
            Number num = ((IUpgrade)stack.func_77973_b()).getChestModifier(block, modifier, stack);
            if (num == null) continue;
            return num.intValue();
        }
        return defaultValue;
    }

    private int inBounds(int current, int lower, int upper) {
        return Math.max(Math.min(upper, current), lower);
    }

    public boolean booleanSum(IUpgradableBlock block, ChestModifier modifier, boolean defaultValue) {
        for (ItemStack stack : block.getActiveUpgrades()) {
            Number num = ((IUpgrade)stack.func_77973_b()).getChestModifier(block, modifier, stack);
            if (num == null) continue;
            return num.doubleValue() > 0.0;
        }
        return defaultValue;
    }

    @Override
    public boolean isFirstUpgrade(IUpgradableBlock block, ItemStack stack) {
        for (ItemStack current : block.getActiveUpgrades()) {
            if (stack == current) {
                return true;
            }
            if (!ItemUtil.areItemsSameMatchingIdDamage((ItemStack)current, (ItemStack)stack)) continue;
            return false;
        }
        return false;
    }

    @Override
    public int getFrequencyTick(IUpgradableBlock block, ItemStack stack, int frequency) {
        int num = stack.func_77973_b().hashCode() + stack.func_77960_j() + block.getTickCount();
        if ((num %= frequency) < 0) {
            num += frequency;
        }
        return num;
    }

    @Override
    public IUpgradableBlock getInventory(ItemStack stack, Entity containerEntity) {
        if (stack.func_77973_b() instanceof ItemBBag) {
            return BlocksItemsBetterChests.betterbag.getInventoryFor(stack, containerEntity);
        }
        if (stack.func_77973_b() instanceof ItemBPortableBarrel) {
            return BlocksItemsBetterChests.betterportablebarrel.getInventoryFor(stack, containerEntity);
        }
        return null;
    }

    @Override
    public IUpgradableBlock getInventory(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IUpgradableBlock) {
            return (IUpgradableBlock)te;
        }
        return null;
    }
}

