/*
 * Decompiled with CFR 0.152.
 */
package com.samuel.spectrite.world;

import com.samuel.spectrite.SpectriteConfig;
import com.samuel.spectrite.entities.AbstractSpectriteSkeleton;
import com.samuel.spectrite.entities.EntitySpectriteCreeper;
import com.samuel.spectrite.entities.EntitySpectriteSkeleton;
import com.samuel.spectrite.entities.EntitySpectriteWitherSkeleton;
import com.samuel.spectrite.entities.ISpectriteMob;
import com.samuel.spectrite.init.ModBlocks;
import com.samuel.spectrite.init.ModLootTables;
import com.samuel.spectrite.world.BiomeSpectriteDungeon;
import com.samuel.spectrite.world.SpectriteSkullData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class WorldGenSpectriteSkull
implements IWorldGenerator {
    protected Random rand = new Random();
    protected SpectriteSkullData savedData;
    protected World world;
    protected TemplateManager templateManager;
    private static final List<AxisAlignedBB>[] skullBounds = new List[2];
    private static final ResourceLocation SPECTRITE_SKULL;
    private static final int OFFSET_X = 10;
    private static final int OFFSET_Z = 12;
    private static final IBlockState wallState;
    private static final IBlockState stairsState;

    private void initSkullStructure(World worldIn) {
        this.world = worldIn;
        this.templateManager = this.world.func_72860_G().func_186340_h();
        this.savedData = (SpectriteSkullData)this.world.getPerWorldStorage().func_75742_a(SpectriteSkullData.class, "spectriteSkull");
        if (this.savedData == null) {
            this.savedData = new SpectriteSkullData("spectriteSkull");
            this.world.getPerWorldStorage().func_75745_a(this.savedData.field_76190_i, (WorldSavedData)this.savedData);
        } else {
            for (int d = -1; d < 1; ++d) {
                for (ChunkPos cp : this.savedData.getSpawnChunks(d)) {
                    int baseY = this.savedData.getBaseYCoord(cp.field_77276_a, cp.field_77275_b, d);
                    skullBounds[d + 1].add(new AxisAlignedBB(new BlockPos(cp.func_180332_e() - 10, baseY, cp.func_180330_f() - 12), new BlockPos(cp.func_180334_c() + 16 + 10, baseY + 18, cp.func_180333_d() + 16 + 12)));
                }
            }
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World worldIn, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int dimId;
        if (SpectriteConfig.spectriteSkull.generateSpectriteSkull && worldIn.func_72912_H().func_76089_r() && (dimId = worldIn.field_73011_w.getDimension()) + 1 >> 1 == 0) {
            if (this.world == null) {
                this.initSkullStructure(worldIn);
            }
            random.setSeed(worldIn.func_72905_C());
            long j = random.nextLong();
            long k = random.nextLong();
            long j1 = (long)(chunkX >> 1) * j;
            long k1 = (long)(chunkZ >> 1) * k;
            random.setSeed(j1 ^ k1 ^ worldIn.func_72905_C());
            if (SpectriteConfig.spectriteSkull.spectriteSkullSpawnRate > 0.0 && random.nextDouble() * 100.0 < SpectriteConfig.spectriteSkull.spectriteSkullSpawnRate) {
                boolean isOrigChunkZ;
                int origChunkZ;
                boolean isOrigChunkX = chunkX % 2 != 0;
                int origChunkX = chunkX + (isOrigChunkX ? 0 : 1);
                int baseY = this.savedData.getBaseYCoord(origChunkX, origChunkZ = chunkZ + ((isOrigChunkZ = chunkZ % 2 != 0) ? 0 : 1), dimId);
                if (baseY == -1 ? (baseY = WorldGenSpectriteSkull.getGroundY(worldIn, chunkX + 1, chunkZ + 1, EnumFacing.SOUTH, random)) == 0 : baseY == 0) {
                    return;
                }
                int chunksGenerated = this.savedData.getSkullChunksGenerated(origChunkX, origChunkZ, dimId);
                if (chunksGenerated == 0) {
                    this.savedData.setSpawnChunk(origChunkX, origChunkZ, baseY, dimId);
                    skullBounds[dimId + 1].add(new AxisAlignedBB(new BlockPos((origChunkX << 4) + 6, baseY, (origChunkZ << 4) + 4), new BlockPos((origChunkX << 4) + 16 + 10, baseY + 18, (origChunkZ << 4) + 16 + 12)));
                }
                this.savedData.setSkullChunksGenerated(origChunkX, origChunkZ, ++chunksGenerated, dimId);
                this.world.getPerWorldStorage().func_75745_a(this.savedData.field_76190_i, (WorldSavedData)this.savedData);
                if (chunksGenerated == 4) {
                    this.generateSkull(worldIn, origChunkX, origChunkZ, baseY, Rotation.NONE);
                }
            }
        }
    }

    private void generateSkull(World worldIn, int chunkX, int chunkZ, int baseY, Rotation rotationIn) {
        TileEntity te;
        int chunkXOffset = chunkX << 4;
        int chunkZOffset = chunkZ << 4;
        Template template = this.templateManager.func_186237_a(worldIn.func_73046_m(), SPECTRITE_SKULL);
        BlockPos skullPos = new BlockPos(1 + chunkXOffset, baseY, 1 + chunkZOffset);
        PlacementSettings settings = new PlacementSettings();
        settings.func_186220_a(rotationIn);
        template.func_186260_a(worldIn, skullPos, settings);
        boolean highTierChest = SpectriteConfig.spectriteSkull.spectriteSkullHighTierChestRate > 0.0 && (double)(worldIn.field_73012_v.nextFloat() * 100.0f) < SpectriteConfig.spectriteSkull.spectriteSkullHighTierChestRate;
        SpectriteConfig.EnumSpectriteSkullChestMode chestMode = SpectriteConfig.spectriteSkull.spectriteSkullChestMode;
        ResourceLocation lootTable = highTierChest ? ModLootTables.spectrite_dungeon_high : ModLootTables.spectrite_dungeon_mid;
        BlockPos chestPos1 = new BlockPos(11 + chunkXOffset, 13 + baseY, 12 + chunkZOffset);
        BlockPos chestPos2 = new BlockPos(11 + chunkXOffset, 13 + baseY, 13 + chunkZOffset);
        int[] equipmentTypes = AbstractSpectriteSkeleton.EQUIPMENT_TYPES;
        Map entityPositions = template.func_186258_a(skullPos, settings);
        for (Map.Entry e : entityPositions.entrySet()) {
            BlockPos pos = (BlockPos)e.getKey();
            String rawData = (String)e.getValue();
            int[] data = new int[rawData.charAt(0) == '2' ? 2 : equipmentTypes.length + 2];
            for (int d = 0; d < data.length; ++d) {
                int val;
                data[d] = val = rawData.charAt(d) - 48;
            }
            ISpectriteMob entity = null;
            switch (data[0]) {
                case 0: {
                    entity = new EntitySpectriteSkeleton(this.world);
                }
                case 1: {
                    if (entity == null) {
                        entity = new EntitySpectriteWitherSkeleton(this.world);
                    }
                    int equipmentSet = 0;
                    for (int t = 0; t < equipmentTypes.length; ++t) {
                        if (data[t + 2] != 1) continue;
                        equipmentSet |= equipmentTypes[t];
                    }
                    ((AbstractSpectriteSkeleton)entity).setEquipmentSet(equipmentSet);
                    break;
                }
                case 2: {
                    entity = new EntitySpectriteCreeper(this.world);
                }
            }
            this.world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            if (entity == null) continue;
            EnumFacing facing = EnumFacing.values()[data[1] + 2];
            float angle = (float)facing.func_176736_b() * 90.0f;
            if (angle > 180.0f) {
                angle -= 360.0f;
            }
            entity.func_70080_a((float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f, angle, 0.0f);
            entity.func_110163_bv();
            this.world.func_72838_d((Entity)entity);
            entity.func_180482_a(this.world.func_175649_E(pos), null);
        }
        if (chestMode == SpectriteConfig.EnumSpectriteSkullChestMode.NONE || !highTierChest && chestMode == SpectriteConfig.EnumSpectriteSkullChestMode.HIGH_TIER_ONLY) {
            this.world.func_175656_a(chestPos1, Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.EAST));
            this.world.func_175656_a(chestPos2, Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.EAST));
        }
        if ((te = worldIn.func_175625_s(chestPos1)) != null) {
            ((TileEntityChest)te).func_189404_a(lootTable, this.rand.nextLong());
        }
        if ((te = worldIn.func_175625_s(chestPos2)) != null) {
            ((TileEntityChest)te).func_189404_a(lootTable, this.rand.nextLong());
        }
        this.buildSupport(worldIn, new BlockPos(chunkXOffset + 12, baseY, chunkZOffset + 8));
        this.buildSupport(worldIn, new BlockPos(chunkXOffset + 18, baseY, chunkZOffset + 8));
        this.buildSupport(worldIn, new BlockPos(chunkXOffset + 12, baseY, chunkZOffset + 24));
        this.buildSupport(worldIn, new BlockPos(chunkXOffset + 18, baseY, chunkZOffset + 24));
    }

    private void buildSupport(World worldIn, BlockPos pos) {
        int s;
        int y = pos.func_177956_o();
        while (pos.func_177956_o() > 0 && !worldIn.func_175665_u(pos.func_177977_b())) {
            pos = pos.func_177977_b();
            worldIn.func_175656_a(pos, wallState);
        }
        if (pos.func_177956_o() == y || y - pos.func_177956_o() == 1) {
            return;
        }
        BlockPos stairPos = pos.func_177974_f().func_177964_d(2);
        for (s = 0; s < 3; ++s) {
            if (worldIn.func_175665_u(stairPos = stairPos.func_177968_d()) && worldIn.func_175665_u(stairPos.func_177984_a())) continue;
            worldIn.func_175656_a(stairPos, stairsState.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST));
        }
        stairPos = pos.func_177976_e().func_177964_d(2);
        for (s = 0; s < 3; ++s) {
            if (worldIn.func_175665_u(stairPos = stairPos.func_177968_d()) && worldIn.func_175665_u(stairPos.func_177984_a())) continue;
            worldIn.func_175656_a(stairPos, stairsState.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST));
        }
        stairPos = pos.func_177968_d();
        if (!worldIn.func_175665_u(stairPos) || !worldIn.func_175665_u(stairPos.func_177984_a())) {
            worldIn.func_175656_a(stairPos, stairsState.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
        }
        if (!worldIn.func_175665_u(stairPos = pos.func_177978_c()) || !worldIn.func_175665_u(stairPos.func_177984_a())) {
            worldIn.func_175656_a(stairPos, stairsState.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH));
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onWorldLoad(WorldEvent.Load e) {
        if (this.world == null && !e.getWorld().field_72995_K && SpectriteConfig.spectriteSkull.generateSpectriteSkull) {
            this.initSkullStructure(e.getWorld());
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onWorldUnload(WorldEvent.Unload e) {
        this.world = null;
        for (int d = 0; d <= 1; ++d) {
            skullBounds[d].clear();
        }
    }

    public boolean isPosInSkullBounds(BlockPos pos, int dimId) {
        boolean ret = false;
        Vec3d vec = new Vec3d((Vec3i)pos);
        if (dimId + 1 >> 1 == 0) {
            for (AxisAlignedBB b : skullBounds[dimId + 1]) {
                if (!b.func_72318_a(vec)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    public static int getGroundY(World worldIn, int chunkX, int chunkZ, EnumFacing facing, Random rand) {
        int ret;
        int x = chunkX << 4;
        int z = (chunkZ << 4) + 12;
        int dimId = worldIn.field_73011_w.getDimension();
        int n = worldIn.func_175624_G() != WorldType.field_77138_c ? (dimId == -1 ? WorldGenSpectriteSkull.getGroundYNether(worldIn, x, z, facing, rand) : (SpectriteConfig.spectriteSkull.spectriteSkullSurfaceRate > 0.0 && rand.nextDouble() * 100.0 <= SpectriteConfig.spectriteSkull.spectriteSkullSurfaceRate || worldIn.func_180494_b(new BlockPos(x, 1, z)).func_150562_l() == BiomeSpectriteDungeon.class ? WorldGenSpectriteSkull.getGroundYSurfaceGroundLevel(worldIn, x, z, facing) : WorldGenSpectriteSkull.getGroundYSurfaceUnderground(rand))) : (ret = 3);
        if (ret == 0 && dimId == -1) {
            ret = WorldGenSpectriteSkull.getGroundYSurfaceUnderground(rand);
        }
        return ret;
    }

    private static int getGroundYSurfaceGroundLevel(World worldIn, int x, int z, EnumFacing facing) {
        int y;
        for (y = Math.min(128, worldIn.func_72940_L()); y >= 30; --y) {
            BlockPos pos = new BlockPos(x, y, z);
            if (worldIn.func_175623_d(pos) || !worldIn.func_175665_u(pos)) continue;
            Iterator checkPosIterator = BlockPos.func_177980_a((BlockPos)pos, (BlockPos)pos.func_177979_c(3)).iterator();
            boolean sufficientDepth = true;
            while (checkPosIterator.hasNext()) {
                BlockPos checkPos = (BlockPos)checkPosIterator.next();
                if (!worldIn.func_175623_d(checkPos) && worldIn.func_175665_u(checkPos)) continue;
                sufficientDepth = false;
                break;
            }
            if (!sufficientDepth) continue;
            pos = pos.func_177984_a();
            boolean sufficientEntranceSpace = true;
            for (BlockPos checkPos : BlockPos.func_177980_a((BlockPos)pos, (BlockPos)pos.func_177967_a(facing, 3))) {
                if (!worldIn.func_175665_u(checkPos)) continue;
                sufficientEntranceSpace = false;
                break;
            }
            if (sufficientEntranceSpace) break;
        }
        if (y == 29) {
            y = 0;
        }
        return y;
    }

    private static int getGroundYSurfaceUnderground(Random rand) {
        return rand.nextInt(6) + 5;
    }

    private static int getGroundYNether(World worldIn, int x, int z, EnumFacing facing, Random rand) {
        int y;
        int openY = 0;
        for (y = Math.min(96, worldIn.func_72940_L()); y >= 4; --y) {
            BlockPos pos = new BlockPos(x, y, z);
            if (!worldIn.func_175623_d(pos) && worldIn.func_175665_u(pos)) {
                if (openY >= 8) {
                    Iterator checkPosIterator = BlockPos.func_177980_a((BlockPos)pos, (BlockPos)pos.func_177979_c(3)).iterator();
                    boolean sufficientDepth = true;
                    while (checkPosIterator.hasNext()) {
                        BlockPos checkPos = (BlockPos)checkPosIterator.next();
                        if (!worldIn.func_175623_d(checkPos) && worldIn.func_175665_u(checkPos)) continue;
                        sufficientDepth = false;
                        break;
                    }
                    if (sufficientDepth) {
                        pos = pos.func_177981_b(3);
                        boolean sufficientEntranceSpace = true;
                        for (BlockPos checkPos : BlockPos.func_177980_a((BlockPos)pos, (BlockPos)pos.func_177967_a(facing, 3))) {
                            if (!worldIn.func_175665_u(checkPos)) continue;
                            sufficientEntranceSpace = false;
                            break;
                        }
                        if (sufficientEntranceSpace) break;
                    }
                }
                openY = 0;
                continue;
            }
            ++openY;
        }
        if (y == 4) {
            y = 0;
        } else if (y <= 30 && worldIn.func_180495_p(new BlockPos(x, 30, z)).func_177230_c() == Blocks.field_150353_l) {
            y = 31;
        }
        return y;
    }

    static {
        wallState = ModBlocks.spectrite_bricks.func_176223_P();
        stairsState = ModBlocks.spectrite_brick_stairs.func_176223_P();
        SPECTRITE_SKULL = new ResourceLocation("spectrite", "spectrite_skull");
        for (int d = 0; d < skullBounds.length; ++d) {
            WorldGenSpectriteSkull.skullBounds[d] = new ArrayList<AxisAlignedBB>();
        }
    }
}

