/*
 * Decompiled with CFR 0.152.
 */
package com.samuel.spectrite.world;

import com.google.common.collect.Lists;
import com.samuel.spectrite.SpectriteConfig;
import com.samuel.spectrite.init.ModBiomes;
import com.samuel.spectrite.init.ModBlocks;
import com.samuel.spectrite.init.ModLootTables;
import com.samuel.spectrite.init.ModWorldGen;
import com.samuel.spectrite.world.SpectriteDungeonData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class WorldGenSpectriteDungeon
implements IWorldGenerator {
    protected Random rand = new Random();
    protected SpectriteDungeonData savedData;
    protected BlockPos spawnPos;
    protected ChunkPos spawnChunkPos;
    protected Map<ChunkPos, Room>[] posRoomsMap = null;

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (SpectriteConfig.spectriteDungeon.generateSpectriteDungeon && this.spawnPos != null && !world.field_72995_K && world.field_73011_w.func_76569_d() && world.func_72912_H().func_76089_r()) {
            if (this.savedData != null && this.savedData.isDungeonGenerated() && this.posRoomsMap == null || chunkX == this.spawnChunkPos.field_77276_a && chunkZ == this.spawnChunkPos.field_77275_b) {
                int y = WorldGenSpectriteDungeon.getGroundY(chunkX, chunkZ, world);
                boolean i = true;
                this.rand.setSeed(world.func_72905_C());
                long j = this.rand.nextLong();
                long k = this.rand.nextLong();
                EnumFacing facing = null;
                long j1 = (long)this.spawnChunkPos.field_77276_a * j;
                long k1 = (long)this.spawnChunkPos.field_77275_b * k;
                this.rand.setSeed(j1 ^ k1 ^ world.func_72905_C());
                if (facing == null) {
                    facing = EnumFacing.values()[this.rand.nextInt(4) + 2];
                }
                int baseY = 20;
                WorldGenSpectriteDungeon.populateChunkBiome(this.spawnChunkPos.field_77276_a, this.spawnChunkPos.field_77275_b, world);
                CoreRoom coreRoom = new CoreRoom(this.rand, this.spawnChunkPos.field_77276_a, 0, this.spawnChunkPos.field_77275_b, y - 6 - baseY, world, facing);
                this.posRoomsMap = coreRoom.chunkPosRooms;
                if (!this.savedData.isDungeonGenerated()) {
                    coreRoom.build();
                    this.savedData.setDungeonGenerated(true);
                    return;
                }
            }
            if (this.posRoomsMap != null) {
                ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
                boolean biomePopulated = false;
                for (int f = 0; f <= 2; ++f) {
                    Room room;
                    if (this.posRoomsMap[f].isEmpty() || !this.posRoomsMap[f].containsKey(chunkPos)) continue;
                    if (!biomePopulated) {
                        WorldGenSpectriteDungeon.populateChunkBiome(chunkX, chunkZ, world);
                        biomePopulated = true;
                    }
                    if (!((room = this.posRoomsMap[f].get(chunkPos)) instanceof ConnectableRoom) || !((ConnectableRoom)room).isReserved()) continue;
                    ((ConnectableRoom)room).setReserved(false);
                    room.build();
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onWorldLoad(WorldEvent.Load e) {
        World world = e.getWorld();
        if (!world.field_72995_K && world.field_73011_w.func_76569_d() && SpectriteConfig.spectriteDungeon.generateSpectriteDungeon) {
            if (world.func_175624_G() != WorldType.field_77138_c && world.func_72940_L() >= 30) {
                this.initSpawnPoint(e.getWorld());
                this.savedData = (SpectriteDungeonData)world.getPerWorldStorage().func_75742_a(SpectriteDungeonData.class, "spectriteDungeon");
                if (this.savedData == null) {
                    this.savedData = new SpectriteDungeonData("spectriteDungeon");
                    world.getPerWorldStorage().func_75745_a(this.savedData.field_76190_i, (WorldSavedData)this.savedData);
                }
                if (!this.savedData.isDungeonGenerated()) {
                    int chunkX = this.spawnPos.func_177958_n() >> 4;
                    int chunkZ = this.spawnPos.func_177952_p() >> 4;
                    if (e.getWorld().func_190526_b(chunkX, chunkZ)) {
                        this.generate(world.field_73012_v, chunkX, chunkZ, world, null, null);
                        this.savedData.setDungeonGenerated(true);
                    }
                }
            } else {
                this.spawnPos = null;
            }
        }
    }

    public void initSpawnPoint(World world) {
        this.rand.setSeed(world.func_72905_C());
        int spawnChunkX = 0;
        int spawnChunkZ = 0;
        spawnChunkX = (this.rand.nextInt(256) + 4) * (this.rand.nextBoolean() ? 1 : -1);
        spawnChunkZ = (this.rand.nextInt(256) + 4) * (this.rand.nextBoolean() ? 1 : -1);
        this.spawnPos = new BlockPos((spawnChunkX << 4) + 8, 0, (spawnChunkZ << 4) + 8);
        this.spawnChunkPos = new ChunkPos(spawnChunkX, spawnChunkZ);
    }

    private static void populateChunkBiome(int chunkX, int chunkZ, World world) {
        byte sdBiomeId = (byte)Biome.func_185362_a((Biome)ModBiomes.spectrite_dungeon);
        BlockPos pos = new BlockPos(chunkX << 4, 4, chunkZ << 4);
        byte[] biomeArray = world.func_175726_f(pos).func_76605_m();
        for (int p = 0; p < biomeArray.length; ++p) {
            biomeArray[p] = sdBiomeId;
        }
        world.func_175726_f(pos).func_76616_a(biomeArray);
    }

    public static int getGroundY(int chunkX, int chunkZ, World world) {
        int y;
        int x = (chunkX << 4) + 6;
        int z = (chunkZ << 4) + 6;
        block0: for (y = Math.min(128, world.func_72940_L()); y >= 29; --y) {
            BlockPos pos = new BlockPos(x, y, z);
            if (!(world.func_175623_d(pos) || world.func_175623_d(pos.func_177965_g(4)) || world.func_175623_d(pos.func_177970_e(4)) || world.func_175623_d(pos.func_177985_f(4)) || world.func_175623_d(pos.func_177964_d(4)))) {
                for (BlockPos checkPos : BlockPos.func_177980_a((BlockPos)pos, (BlockPos)pos.func_177965_g(2).func_177970_e(2).func_177979_c(3))) {
                    if (!world.func_175623_d(checkPos)) continue;
                    y = checkPos.func_177956_o() - 1;
                    break block0;
                }
                break;
            }
            if (world.func_180495_p(pos).func_177230_c() != Room.wallState.func_177230_c()) continue;
            y -= 3;
            break;
        }
        if (y == 29) {
            y = 0;
        }
        return y;
    }

    public BlockPos getSpawnPos() {
        return this.spawnPos;
    }

    public void setSpawnPos(BlockPos spawnPos) {
        this.spawnPos = spawnPos;
    }

    protected static interface IStartRoom {
        public List<EnumFacing> getBaseDirs();
    }

    protected static class CoreRoom
    extends Room
    implements IStartRoom {
        private final int height;
        private final Map<ChunkPos, Room>[] chunkPosRooms;
        private final List<EnumFacing> baseDirs;

        protected CoreRoom(Random rand, int chunkX, int floor, int chunkZ, int height, World world, EnumFacing facing) {
            super(rand, chunkX, floor, chunkZ, 0, world, facing);
            this.height = height;
            this.baseDirs = Lists.newArrayList((Object[])this.getRandomSortedDirs());
            stairsState = stairsState.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)facing);
            this.chunkPosRooms = new Map[3];
            for (int f = 0; f <= 2; ++f) {
                this.chunkPosRooms[f] = new HashMap<ChunkPos, Room>();
            }
            this.chunkPosRooms[0].put(new ChunkPos(chunkX, chunkZ), this);
            ModWorldGen.spectriteDungeon.posRoomsMap = this.chunkPosRooms;
        }

        @Override
        public void build() {
            this.fillRange(wallState, 6, 1, 6, 8, 9 + this.height, 6, false, true, false, this.facing);
            this.fillRange(wallState, 9, 4, 6, 9, 9 + this.height, 9, false, false, false, this.facing);
            this.fillRange(wallState, 6, 1, 6, 7, 6 + this.height, 8, false, false, false, this.facing);
            this.fillRange(wallState, 7, 10 + this.height, 7, 8, 10 + this.height, 8, false, false, false, this.facing);
            this.fillRange(slabState, 7, 11 + this.height, 7, 8, 11 + this.height, 8, false, false, false, this.facing);
            this.fillRange(stairsState, 6, 10 + this.height, 6, 6, 10 + this.height, 9, true, false, true, this.facing);
            this.fillRange(airState, 7, 12 + this.height, 7, 8, 13 + this.height, 8, false, false, false, this.facing);
            this.fillRange(wallState, 5, 7 + this.height, 6, 5, 8 + this.height, 6, false, true, false, this.facing);
            this.fillRange(stairsState, 5, 9 + this.height, 6, 5, 9 + this.height, 9, false, false, false, this.facing);
            this.fillRange(wallState, 4, 7 + this.height, 6, 4, 7 + this.height, 6, false, true, false, this.facing);
            this.fillRange(stairsState, 4, 8 + this.height, 6, 4, 8 + this.height, 6, false, true, false, this.facing);
            this.fillRange(stairsState, 3, 7 + this.height, 6, 3, 7 + this.height, 6, false, true, false, this.facing);
            this.fillRange(wallState, 3, 6 + this.height, 6, 3, 6 + this.height, 6, false, true, false, this.facing);
            this.fillRange(wallState, 4, 6 + this.height, 6, 5, 6 + this.height, 9, false, false, false, this.facing);
            this.fillRange(airState, 7, 1, 7, 8, 9 + this.height, 8, false, false, false, this.facing);
            this.fillRange(ladderState.func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)this.facing), 7, 1, 7, 7, 6 + this.height, 8, false, false, false, this.facing);
            this.fillRange(slabState.func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.TOP), 9, 3, 7, 9, 3, 8, false, false, false, this.facing);
            this.fillRange(wallState, 9, 1, 6, 9, 3, 6, false, true, false, this.facing);
            this.fillRange(airState, 9, 1, 7, 9, 2, 8, false, false, false, this.facing);
            this.fillRange(airState, 4, 1, 4, 11, 4, 5, false, true, true, this.facing);
            this.fillRange(stairsState.func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), 4, 4, 4, 4, 4, 11, true, false, true, this.facing.func_176734_d(), true);
            this.fillRange(wallState, 3, 5, 3, 12, 6, 5, false, true, true, this.facing);
            this.fillRange(wallState, 3, 0, 3, 12, 0, 12, false, false, false, this.facing);
            this.fillRange(wallState, 3, 1, 3, 6, 4, 3, true, true, true, this.facing);
            this.fillRange(wallState, 7, 4, 3, 8, 4, 3, false, true, true, this.facing);
            this.fillRange(slabState.func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.TOP), 7, 3, 3, 8, 3, 3, false, true, true, this.facing);
            this.fillRange(wallState, 6, 1, 0, 6, 6, 2, true, true, true, this.facing);
            this.fillRange(wallState, 6, 0, 0, 9, 0, 3, false, true, true, this.facing);
            this.fillRange(airState, 7, 1, 3, 8, 2, 3, false, true, true, this.facing);
            this.fillRange(wallState, 7, 5, 0, 8, 6, 2, false, true, true, this.facing);
            this.fillRange(airState, 7, 1, 0, 8, 4, 2, false, true, true, this.facing);
            this.fillRange(stairsState.func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), 2, 4, 7, 2, 4, 8, true, false, true, this.facing);
            this.fillRange(wallState, 1, -2, 1, 14, -2, 14, false, false, false, this.facing);
            this.fillRange(fluidState, 2, -1, 2, 13, -1, 13, false, false, false, this.facing);
            this.fillRange(fluidState, 0, -1, 6, 1, -1, 9, false, true, true, this.facing);
            this.fillRange(wallState, 0, -1, 5, 1, -1, 5, true, true, true, this.facing);
            this.fillRange(wallState, 0, -2, 5, 1, -2, 9, false, true, true, this.facing);
            this.fillRange(wallState, 1, -2, 1, 5, 8, 1, true, true, true, this.facing);
            this.fillRange(fluidState, 2, 0, 2, 5, 7, 2, true, true, true, this.facing);
            this.fillRange(wallState, 0, -2, 4, 1, -2, 10, true, false, true, this.facing);
            this.fillRange(fluidState, 0, -1, 5, 1, -1, 9, true, false, true, this.facing);
            this.fillRange(fluidState, 0, -1, 5, 1, 7, 5, true, true, true, this.facing);
            this.fillRange(wallState, 0, -2, 4, 1, 8, 4, true, true, true, this.facing);
            this.fillRange(wallState, 0, 8, 5, 1, 8, 7, true, true, true, this.facing);
            this.fillRange(wallState, 5, 8, 1, 8, 8, 1, true, true, true, this.facing);
            this.fillRange(fluidState, 2, 7, 2, 5, 7, 13, true, true, true, this.facing);
            this.fillRange(wallState, 1, 8, 1, 14, 8, 5, false, true, true, this.facing);
            this.fillRange(fluidState, 0, 7, 6, 1, 7, 9, true, false, true, this.facing);
            this.reserveConns();
            this.buildConns();
        }

        @Override
        public List<EnumFacing> getBaseDirs() {
            return this.baseDirs;
        }

        @Override
        protected EnumFacing[] getRandomSortedDirs() {
            ArrayList facingList = Lists.newArrayList((Object[])new EnumFacing[]{EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.NORTH});
            ArrayList ret = new ArrayList();
            while (ret.size() < 4) {
                int randDir = this.rand.nextInt(facingList.size());
                ret.add(facingList.get(randDir));
                facingList.remove(randDir);
            }
            return ret.toArray(new EnumFacing[4]);
        }

        @Override
        protected void reserveConns() {
            int connsLeft = this.rand.nextInt(8) + 4;
            BlockPos chunkBlockPos = new BlockPos(this.chunkX << 4, this.baseY, this.chunkZ << 4);
            for (int d = this.baseDirs.size(); d > 0; --d) {
                EnumFacing dir = this.baseDirs.get(d - 1);
                BlockPos pos = chunkBlockPos.func_177967_a(dir, 16);
                ChunkPos chunkPos = new ChunkPos(pos);
                ConnectableRoom newRoom = new ConnectableRoom(new Random(), chunkPos.field_77276_a, this.floor, chunkPos.field_77275_b, this, connsLeft, this.world, dir);
                this.childRooms.add(newRoom);
                newRoom.reserveConns();
                connsLeft = Math.min(this.rand.nextInt(connsLeft) + (d << 1), connsLeft - 1);
            }
        }

        @Override
        protected void buildConns() {
            for (Room connRoom : this.childRooms) {
                if (this.world.func_190526_b(connRoom.chunkX, connRoom.chunkZ)) {
                    connRoom.build();
                    continue;
                }
                ((ConnectableRoom)connRoom).setReserved(true);
            }
        }
    }

    protected static class NewFloorRoom
    extends ConnectableRoom
    implements IStartRoom {
        private final List<EnumFacing> baseDirs = Lists.newArrayList((Object[])this.getRandomSortedDirs());

        protected NewFloorRoom(Random rand, int chunkX, int floor, int chunkZ, ConnectableRoom prevRoom, int connsLeft, boolean sidePath, World world, EnumFacing facing) {
            super(rand, chunkX, floor, chunkZ, (Room)prevRoom, connsLeft, sidePath, world, facing);
            this.baseDir = null;
            this.coreRoom = prevRoom.coreRoom;
            this.coreRoom.chunkPosRooms[floor].put(new ChunkPos(chunkX, chunkZ), this);
            this.floorStartRoom = this;
            ModWorldGen.spectriteDungeon.posRoomsMap[floor].put(new ChunkPos(chunkX, chunkZ), this);
        }

        @Override
        protected EnumFacing[] getRandomSortedDirs() {
            ArrayList facingList = Lists.newArrayList((Object[])new EnumFacing[]{EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.NORTH});
            ArrayList ret = new ArrayList();
            while (ret.size() < 4) {
                int randDir = this.rand.nextInt(facingList.size());
                ret.add(facingList.get(randDir));
                facingList.remove(randDir);
            }
            return ret.toArray(new EnumFacing[4]);
        }

        @Override
        public List<EnumFacing> getBaseDirs() {
            return this.baseDirs;
        }
    }

    protected static class ConnectableRoom
    extends Room {
        protected CoreRoom coreRoom;
        protected Room floorStartRoom;
        protected ConnectableRoom adoptedRoom;
        protected final Room prevRoom;
        protected int size;
        protected final int connsLeft;
        protected boolean mainRoute;
        protected EnumFacing baseDir;
        protected boolean sidePath;
        protected boolean deadEnd = false;
        protected boolean reserved = false;
        protected boolean hasGlassFloor = false;
        protected Map<EnumFacing, ConnectableRoom> reservedConnsMap;

        protected ConnectableRoom(Random rand, int chunkX, int floor, int chunkZ, Room prevRoom, int connsLeft, boolean sidePath, World world, EnumFacing facing) {
            super(rand, chunkX, floor, chunkZ, prevRoom.depth + 1, world, facing);
            this.prevRoom = prevRoom;
            this.connsLeft = connsLeft;
            if (prevRoom instanceof IStartRoom) {
                this.mainRoute = ((IStartRoom)((Object)prevRoom)).getBaseDirs().indexOf(facing) == 3;
                this.floorStartRoom = prevRoom;
            } else {
                this.mainRoute = ((ConnectableRoom)prevRoom).isMainRoute();
                this.floorStartRoom = ((ConnectableRoom)prevRoom).getFloorStartRoom();
            }
            this.sidePath = sidePath;
            this.resetSeed();
            this.size = sidePath || connsLeft > 1 ? (!(this instanceof NewFloorRoom) ? rand.nextInt(5) + 1 << 1 : ((ConnectableRoom)prevRoom).getSize()) : (floor < 2 ? rand.nextInt(3) + 3 << 1 : 10);
            this.hasGlassFloor = (sidePath || !this.mainRoute || floor < 2) && rand.nextInt(Math.max(3, 16 - this.depth)) == 0;
            this.resetSeed();
        }

        protected ConnectableRoom(Random rand, int chunkX, int floor, int chunkZ, CoreRoom prevRoom, int connsLeft, World world, EnumFacing facing) {
            this(rand, chunkX, floor, chunkZ, prevRoom, connsLeft, false, world, facing);
            this.baseDir = facing;
            this.coreRoom = prevRoom;
            this.coreRoom.chunkPosRooms[floor].put(new ChunkPos(chunkX, chunkZ), this);
            ModWorldGen.spectriteDungeon.posRoomsMap[floor].put(new ChunkPos(chunkX, chunkZ), this);
        }

        protected ConnectableRoom(Random rand, int chunkX, int floor, int chunkZ, ConnectableRoom prevRoom, int connsLeft, boolean sidePath, World world, EnumFacing facing) {
            this(rand, chunkX, floor, chunkZ, (Room)prevRoom, connsLeft, sidePath, world, facing);
            this.coreRoom = prevRoom.coreRoom;
            this.baseDir = this.getClass() != NewFloorRoom.class ? (prevRoom.getClass() != NewFloorRoom.class ? prevRoom.facing : facing) : null;
            this.coreRoom.chunkPosRooms[floor].put(new ChunkPos(chunkX, chunkZ), this);
            ModWorldGen.spectriteDungeon.posRoomsMap[floor].put(new ChunkPos(chunkX, chunkZ), this);
        }

        @Override
        public void build() {
            int halfSize = this.size >> 1;
            Room.stairsState = stairsState.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)this.facing);
            this.fillRange(wallState, 0, 1, 6, 8 - halfSize, 5, 6, false, true, false, this.facing);
            this.fillRange(wallState, 0, 0, 6, 8 - halfSize, 0, 9, false, false, false, this.facing);
            this.fillRange(wallState, 0, 5, 6, 8 - halfSize, 6, 9, false, false, false, this.facing);
            this.fillRange(airState, 8 - halfSize, 1, 8 - halfSize, 7 + halfSize, halfSize > 1 ? 5 : 6, 7 + halfSize, false, false, false, this.facing);
            this.fillRange(slabState.func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.TOP), 0, 4, 7, (halfSize > 1 ? 7 : 6) - halfSize, 4, 8, false, false, false, this.facing);
            this.fillRange(airState, 0, 1, 7, 8 - halfSize, 3, 8, false, false, false, this.facing);
            if (halfSize > 1) {
                this.fillRange(stairsState.func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), 8 - halfSize, 5, 8 - halfSize, 8 - halfSize, 5, 7 + halfSize, true, false, true, this.facing.func_176734_d(), true);
            } else {
                this.fillRange(stairsState.func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP).func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)this.facing.func_176734_d()), 7 - halfSize, 5, 7, 7 - halfSize, 5, 8, false, false, false, this.facing);
                this.fillRange(airState, 7 - halfSize, 4, 7, 7 - halfSize, 4, 8, false, false, false, this.facing);
            }
            this.fillRange(wallState, 7 - halfSize, 1, 7 - halfSize, 7 - halfSize, 5, 7 - halfSize + (halfSize - 1), true, true, true, this.facing);
            this.fillRange(stairsState, 7 - halfSize, 6, 7 - halfSize, 7 - halfSize, 6, 8 + halfSize, true, false, true, this.facing);
            this.fillRange(wallState, 0, 0, 6 - halfSize, 9 + halfSize, 0, 9 + halfSize, false, false, false, this.facing);
            this.fillRange(wallState, 8 - halfSize, 6, 8 - halfSize, 7 + halfSize, 6, 7 + halfSize, false, false, false, this.facing);
            this.fillRange(wallState, 5 - halfSize, -2, 5 - halfSize, 10 + halfSize, -2, 10 + halfSize, false, false, false, this.facing);
            this.fillRange(fluidState, 0, -1, 6, 5 - halfSize, -1, 9, false, false, false, this.facing);
            this.fillRange(fluidState, 6 - halfSize, -1, 6 - halfSize, 9 + halfSize, -1, 9 + halfSize, false, false, false, this.facing);
            this.fillRange(wallState, 5 - halfSize, -2, 5 - halfSize, 5, 7, 5 - halfSize, true, true, true, this.facing);
            this.fillRange(wallState, 0, -2, 4, 6 - halfSize, -2, 10, false, false, false, this.facing);
            this.fillRange(fluidState, 0, -1, 5, 6 - halfSize, 7, 5, false, true, false, this.facing);
            this.fillRange(wallState, 0, -2, 4, 6 - halfSize, 7, 4, false, true, false, this.facing);
            this.fillRange(fluidState, 0, 7, 5, 6 - halfSize, 7, 9, false, false, false, this.facing);
            this.fillRange(fluidState, 6 - halfSize, -1, 6 - halfSize, 5, 7, 6 - halfSize, true, true, true, this.facing);
            this.fillRange(wallState, 0, 8, 4, 6 - halfSize, 8, 11, false, false, false, this.facing);
            this.fillRange(fluidState, 6 - halfSize, 7, 6 - halfSize, 9 + halfSize, 7, 9 + halfSize, false, false, false, this.facing);
            this.fillRange(wallState, 5 - halfSize, 8, 5 - halfSize, 10 + halfSize, 8, 10 + halfSize, false, false, true, this.facing);
            if (this.reserved) {
                this.setReserved(false);
                this.buildConns();
            } else {
                this.buildConns();
                WorldGenSpectriteDungeon.populateChunkBiome(this.chunkX, this.chunkZ, this.world);
            }
            if (this.hasGlassFloor) {
                this.buildGlassFloor();
            }
        }

        public void updateSize() {
            if (!this.sidePath) {
                this.size = this.floor < 2 ? this.rand.nextInt(3) + 3 << 1 : 10;
            }
        }

        public Room getPrevRoom() {
            return this.prevRoom;
        }

        public Room getFloorStartRoom() {
            return this.floorStartRoom;
        }

        @Override
        protected EnumFacing[] getRandomSortedDirs() {
            ArrayList facingList = Lists.newArrayList((Object[])new EnumFacing[]{EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.NORTH});
            ArrayList ret = new ArrayList();
            facingList.remove(this.facing.func_176734_d());
            while (ret.size() < 3) {
                int randDir = this.rand.nextInt(facingList.size());
                ret.add(facingList.get(randDir));
                facingList.remove(randDir);
            }
            return ret.toArray(new EnumFacing[3]);
        }

        public boolean isDeadEnd() {
            return this.deadEnd;
        }

        public void setDeadEnd(boolean deadEnd) {
            this.deadEnd = deadEnd;
        }

        public boolean isReserved() {
            return this.reserved;
        }

        public void setReserved(boolean reserved) {
            this.reserved = reserved;
            this.reservedConnsMap = reserved ? new HashMap<EnumFacing, ConnectableRoom>() : null;
        }

        public Map<EnumFacing, ConnectableRoom> getReservedConnsMap() {
            return this.reservedConnsMap;
        }

        public boolean shouldRoomsConnect(ConnectableRoom otherRoom) {
            Random rand = new Random();
            rand.setSeed(this.world.func_72905_C());
            long j = rand.nextLong();
            long k = rand.nextLong();
            long j1 = (long)(this.chunkX * otherRoom.chunkX) * j;
            long k1 = (long)(this.chunkZ * otherRoom.chunkZ) * k;
            rand.setSeed(j1 ^ k1 ^ this.world.func_72905_C());
            return rand.nextInt(4) == 0;
        }

        @Override
        protected void reserveConns() {
            int connsLeft = !this.deadEnd ? this.connsLeft - 1 : 0;
            int halfSize = this.size >> 1;
            boolean sidePath = this.sidePath;
            this.resetSeed();
            EnumFacing[] dirs = !(this instanceof NewFloorRoom) ? this.getRandomSortedDirs() : ((NewFloorRoom)this).baseDirs.toArray(new EnumFacing[4]);
            BlockPos chunkBlockPos = new BlockPos(this.chunkX << 4, this.baseY, this.chunkZ << 4);
            for (int d = dirs.length; d > 0; --d) {
                boolean dirHasConn;
                EnumFacing dir = dirs[d - 1];
                BlockPos pos = chunkBlockPos.func_177967_a(dir, 16);
                ChunkPos chunkPos = new ChunkPos(pos);
                Room connRoom = (Room)this.coreRoom.chunkPosRooms[this.floor].get(chunkPos);
                boolean bl = dirHasConn = connsLeft > 0;
                if (!dirHasConn && connRoom == null) continue;
                if (connRoom == null) {
                    if ((chunkPos.field_77276_a != this.floorStartRoom.chunkX || chunkPos.field_77275_b != this.floorStartRoom.chunkZ - 1 && chunkPos.field_77275_b != this.floorStartRoom.chunkZ + 1) && (chunkPos.field_77275_b != this.floorStartRoom.chunkZ || chunkPos.field_77276_a != this.floorStartRoom.chunkX - 1 && chunkPos.field_77276_a != this.floorStartRoom.chunkX + 1) || this == this.floorStartRoom) {
                        ConnectableRoom newRoom = new ConnectableRoom(new Random(), chunkPos.field_77276_a, this.floor, chunkPos.field_77275_b, this, connsLeft, sidePath, this.world, dir);
                        if (connsLeft <= 1) {
                            newRoom.setDeadEnd(true);
                        } else {
                            boolean newRoomHasConn = false;
                            BlockPos newRoomChunkBlockPos = new BlockPos(chunkPos.field_77276_a << 4, this.baseY, chunkPos.field_77275_b << 4);
                            EnumFacing[] newRoomDirs = newRoom.getRandomSortedDirs();
                            for (int d2 = newRoomDirs.length; d2 > 0; --d2) {
                                EnumFacing newRoomDir = newRoomDirs[d2 - 1];
                                BlockPos newRoomPos = newRoomChunkBlockPos.func_177967_a(newRoomDir, 16);
                                ChunkPos newRoomChunkPos = new ChunkPos(newRoomPos);
                                Room newRoomConnRoom = (Room)this.coreRoom.chunkPosRooms[this.floor].get(newRoomChunkPos);
                                if (newRoomConnRoom != null && (newRoomConnRoom.getClass() != ConnectableRoom.class || ((ConnectableRoom)newRoomConnRoom).isDeadEnd() || !sidePath && !((ConnectableRoom)newRoomConnRoom).isSidePath() || !newRoom.shouldRoomsConnect((ConnectableRoom)newRoomConnRoom))) continue;
                                newRoomHasConn = true;
                                break;
                            }
                            if (!newRoomHasConn) {
                                newRoom.setDeadEnd(true);
                                newRoom.updateSize();
                            }
                        }
                        this.childRooms.add(newRoom);
                        if (!this.world.func_190526_b(chunkPos.field_77276_a, chunkPos.field_77275_b)) {
                            newRoom.setReserved(true);
                        }
                        newRoom.reserveConns();
                        if (!sidePath && this != this.floorStartRoom) {
                            sidePath = !newRoom.isSidePath();
                        }
                    } else {
                        dirHasConn = false;
                    }
                } else if (connRoom instanceof ConnectableRoom && (((ConnectableRoom)connRoom).isDeadEnd() || !sidePath && !((ConnectableRoom)connRoom).isSidePath() || ((ConnectableRoom)connRoom).getAdoptedRoom() != this && !this.shouldRoomsConnect((ConnectableRoom)connRoom))) {
                    dirHasConn = false;
                } else if (connRoom instanceof ConnectableRoom && !sidePath && ((ConnectableRoom)connRoom).isSidePath() && this.shouldRoomsConnect((ConnectableRoom)connRoom)) {
                    this.adoptedRoom = (ConnectableRoom)connRoom;
                    this.adoptPath((ConnectableRoom)connRoom);
                    sidePath = true;
                }
                if (!dirHasConn || connsLeft <= 0) continue;
                connsLeft = Math.min(this.rand.nextInt(connsLeft) + (d << 1), connsLeft - 1);
            }
            if (!sidePath && !this.deadEnd && this.childRooms.isEmpty() && this.prevRoom != this.floorStartRoom) {
                this.setSidePath(true);
            } else if (this.deadEnd && this.mainRoute && !sidePath && this.floor < 2) {
                NewFloorRoom newRoom = new NewFloorRoom(new Random(), this.chunkX, this.floor + 1, this.chunkZ, this, this.rand.nextInt(8) + 4 + 4 * this.floor, false, this.world, this.facing);
                this.childRooms.add(newRoom);
                newRoom.reserveConns();
            }
        }

        protected void adoptPath(ConnectableRoom otherRoom) {
            otherRoom.setSidePath(false);
            otherRoom.setMainRoute(this.mainRoute);
            otherRoom.setBaseDir(this.baseDir);
            if (!otherRoom.childRooms.isEmpty()) {
                otherRoom.adoptPath((ConnectableRoom)otherRoom.getChildRooms().get(0));
            } else {
                otherRoom.updateSize();
            }
        }

        protected void buildGlassFloor() {
            if (this.rand.nextBoolean()) {
                this.fillRange(glassState, 7, 0, 7, 8, 0, 8, false, false, false, this.facing);
            }
            if (this.size >= 4 && this.rand.nextBoolean()) {
                switch (this.rand.nextInt(3)) {
                    case 0: {
                        this.fillRange(glassState, 6, 0, 6, 6, 0, 6, true, true, true, this.facing);
                        break;
                    }
                    case 1: {
                        this.fillRange(glassState, 6, 0, 7, 6, 0, 8, true, false, true, this.facing);
                        break;
                    }
                    case 2: {
                        this.fillRange(glassState, 6, 0, 6, 6, 0, 9, true, false, true, this.facing);
                    }
                }
            }
            if (this.size >= 6 && this.rand.nextBoolean()) {
                switch (this.rand.nextInt(6)) {
                    case 0: {
                        this.fillRange(glassState, 5, 0, 5, 5, 0, 5, true, true, true, this.facing);
                        break;
                    }
                    case 1: {
                        this.fillRange(glassState, 5, 0, 5, 5, 0, 6, true, true, true, this.facing);
                        break;
                    }
                    case 2: {
                        this.fillRange(glassState, 5, 0, 6, 5, 0, 6, true, true, true, this.facing);
                        break;
                    }
                    case 3: {
                        this.fillRange(glassState, 5, 0, 5, 5, 0, 5, true, true, true, this.facing);
                        this.fillRange(glassState, 5, 0, 7, 5, 0, 8, true, false, true, this.facing);
                        break;
                    }
                    case 4: {
                        this.fillRange(glassState, 5, 0, 7, 5, 0, 8, true, false, true, this.facing);
                        break;
                    }
                    case 5: {
                        this.fillRange(glassState, 5, 0, 6, 5, 0, 9, true, false, true, this.facing);
                    }
                }
            }
            if (this.size >= 8 && this.rand.nextBoolean()) {
                switch (this.rand.nextInt(10)) {
                    case 0: {
                        this.fillRange(glassState, 4, 0, 4, 4, 0, 4, true, true, true, this.facing);
                        break;
                    }
                    case 1: {
                        this.fillRange(glassState, 4, 0, 4, 4, 0, 5, true, true, true, this.facing);
                        break;
                    }
                    case 2: {
                        this.fillRange(glassState, 4, 0, 5, 4, 0, 5, true, true, true, this.facing);
                        break;
                    }
                    case 3: {
                        this.fillRange(glassState, 4, 0, 4, 4, 0, 6, true, true, true, this.facing);
                        break;
                    }
                    case 4: {
                        this.fillRange(glassState, 4, 0, 4, 4, 0, 4, true, true, true, this.facing);
                        this.fillRange(glassState, 4, 0, 6, 4, 0, 6, true, true, true, this.facing);
                        break;
                    }
                    case 5: {
                        this.fillRange(glassState, 4, 0, 4, 4, 0, 4, true, true, true, this.facing);
                        this.fillRange(glassState, 4, 0, 6, 4, 0, 9, true, false, true, this.facing);
                        break;
                    }
                    case 6: {
                        this.fillRange(glassState, 4, 0, 6, 4, 0, 6, true, true, true, this.facing);
                        break;
                    }
                    case 7: {
                        this.fillRange(glassState, 4, 0, 6, 4, 0, 9, true, false, true, this.facing);
                        break;
                    }
                    case 8: {
                        this.fillRange(glassState, 4, 0, 7, 4, 0, 8, true, false, true, this.facing);
                        break;
                    }
                    case 9: {
                        this.fillRange(glassState, 4, 0, 4, 4, 0, 11, true, false, true, this.facing);
                    }
                }
            }
            if (this.size >= 10 && this.rand.nextBoolean()) {
                switch (this.rand.nextInt(21)) {
                    case 0: {
                        this.fillRange(glassState, 3, 0, 3, 3, 0, 3, true, true, true, this.facing);
                        break;
                    }
                    case 1: {
                        this.fillRange(glassState, 3, 0, 3, 3, 0, 4, true, true, true, this.facing);
                        break;
                    }
                    case 2: {
                        this.fillRange(glassState, 3, 0, 4, 3, 0, 4, true, true, true, this.facing);
                        break;
                    }
                    case 3: {
                        this.fillRange(glassState, 3, 0, 3, 3, 0, 5, true, true, true, this.facing);
                        break;
                    }
                    case 4: {
                        this.fillRange(glassState, 3, 0, 4, 3, 0, 5, true, true, true, this.facing);
                        break;
                    }
                    case 5: {
                        this.fillRange(glassState, 3, 0, 3, 3, 0, 3, true, true, true, this.facing);
                        this.fillRange(glassState, 3, 0, 5, 3, 0, 5, true, true, true, this.facing);
                        break;
                    }
                    case 6: {
                        this.fillRange(glassState, 3, 0, 5, 3, 0, 5, true, true, true, this.facing);
                        break;
                    }
                    case 7: {
                        this.fillRange(glassState, 3, 0, 3, 3, 0, 6, true, true, true, this.facing);
                        break;
                    }
                    case 8: {
                        this.fillRange(glassState, 3, 0, 4, 3, 0, 6, true, true, true, this.facing);
                        break;
                    }
                    case 9: {
                        this.fillRange(glassState, 3, 0, 4, 3, 0, 4, true, true, true, this.facing);
                        this.fillRange(glassState, 3, 0, 6, 3, 0, 6, true, true, true, this.facing);
                        break;
                    }
                    case 10: {
                        this.fillRange(glassState, 3, 0, 5, 3, 0, 6, true, true, true, this.facing);
                        break;
                    }
                    case 11: {
                        this.fillRange(glassState, 3, 0, 6, 3, 0, 6, true, true, true, this.facing);
                        break;
                    }
                    case 12: {
                        this.fillRange(glassState, 3, 0, 3, 3, 0, 12, true, false, true, this.facing);
                        break;
                    }
                    case 13: {
                        this.fillRange(glassState, 3, 0, 3, 3, 0, 3, true, true, true, this.facing);
                        this.fillRange(glassState, 3, 0, 5, 3, 0, 5, true, true, true, this.facing);
                        this.fillRange(glassState, 3, 0, 7, 3, 0, 7, true, true, true, this.facing);
                        break;
                    }
                    case 14: {
                        this.fillRange(glassState, 3, 0, 3, 3, 0, 3, true, true, true, this.facing);
                        this.fillRange(glassState, 3, 0, 5, 3, 0, 7, true, true, true, this.facing);
                        break;
                    }
                    case 15: {
                        this.fillRange(glassState, 3, 0, 4, 3, 0, 7, true, true, true, this.facing);
                        break;
                    }
                    case 16: {
                        this.fillRange(glassState, 3, 0, 5, 3, 0, 7, true, true, true, this.facing);
                        break;
                    }
                    case 17: {
                        this.fillRange(glassState, 3, 0, 6, 3, 0, 7, true, true, true, this.facing);
                        break;
                    }
                    case 18: {
                        this.fillRange(glassState, 3, 0, 3, 3, 0, 4, true, true, true, this.facing);
                        break;
                    }
                    case 19: {
                        this.fillRange(glassState, 3, 0, 7, 3, 0, 8, true, false, true, this.facing);
                        break;
                    }
                    case 20: {
                        this.fillRange(glassState, 3, 0, 3, 3, 0, 5, true, true, true, this.facing);
                        this.fillRange(glassState, 3, 0, 7, 3, 0, 8, true, false, true, this.facing);
                        break;
                    }
                    case 22: {
                        this.fillRange(glassState, 3, 0, 7, 3, 0, 8, true, false, true, this.facing);
                    }
                }
            }
        }

        @Override
        protected void buildConns() {
            int connsLeft = this.connsLeft - 1;
            boolean sidePath = this.sidePath;
            boolean fakeChest = false;
            int halfSize = this.size >> 1;
            this.resetSeed();
            EnumFacing[] dirs = !(this instanceof NewFloorRoom) ? this.getRandomSortedDirs() : ((NewFloorRoom)this).baseDirs.toArray(new EnumFacing[4]);
            BlockPos chunkBlockPos = new BlockPos(this.chunkX << 4, this.baseY, this.chunkZ << 4);
            for (int d = dirs.length; d > 0; --d) {
                boolean deadEndConn = false;
                EnumFacing dir = dirs[d - 1];
                BlockPos pos = chunkBlockPos.func_177967_a(dir, 16);
                ChunkPos chunkPos = new ChunkPos(pos);
                Room connRoom = (Room)this.coreRoom.chunkPosRooms[this.floor].get(chunkPos);
                boolean dirHasConn = connsLeft > 0;
                boolean hiddenConn = false;
                boolean shouldRoomsConnect = false;
                if (dirHasConn || connRoom != null) {
                    if (this.childRooms.contains(connRoom) || this.adoptedRoom != null && this.adoptedRoom == connRoom) {
                        if (!((ConnectableRoom)connRoom).isReserved()) {
                            connRoom.build();
                        }
                        dirHasConn = true;
                        shouldRoomsConnect = true;
                    } else if (connRoom instanceof ConnectableRoom && !this.deadEnd && !(deadEndConn = ((ConnectableRoom)connRoom).isDeadEnd()) && (shouldRoomsConnect = ((ConnectableRoom)connRoom).getAdoptedRoom() == this || (sidePath || ((ConnectableRoom)connRoom).isSidePath()) && this.shouldRoomsConnect((ConnectableRoom)connRoom))) {
                        EnumFacing connFacing = dir.func_176734_d();
                        int connRoomDepth = connRoom.getDepth();
                        if (!this.world.func_190526_b(connRoom.chunkX, connRoom.chunkZ)) {
                            ((ConnectableRoom)connRoom).getReservedConnsMap().put(connFacing, this);
                        } else {
                            int connHalfSize = ((ConnectableRoom)connRoom).getSize() >> 1;
                            if (Math.abs(this.depth - connRoomDepth) > (connRoomDepth > 1 && this.depth > 1 ? 3 : 7)) {
                                if (connRoomDepth < this.depth) {
                                    connRoom.fillRange(wallState, 8 + connHalfSize, 1, 7, 8 + connHalfSize, 4, 8, false, false, false, connFacing);
                                } else {
                                    hiddenConn = true;
                                }
                            }
                            connRoom.fillRange(wallState, 8 + connHalfSize, 1, 6, 15, 4, 6, false, true, false, connFacing);
                            connRoom.fillRange(wallState, (connHalfSize > 1 ? 8 : 9) + connHalfSize, 5, 6, 15, 6, 9, false, false, false, connFacing);
                            if (connHalfSize == 1) {
                                connRoom.fillRange(Room.stairsState.func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP).func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)connFacing), 8 + connHalfSize, 5, 7, 8 + connHalfSize, 5, 8, false, false, false, connFacing);
                                connRoom.fillRange(airState, 8 + connHalfSize, 4, 7, 8 + connHalfSize, 4, 8, false, false, false, connFacing);
                            }
                            connRoom.fillRange(wallState, 8 + connHalfSize, 0, 6, 15, 0, 9, false, false, false, connFacing);
                            connRoom.fillRange(slabState.func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.TOP), (connHalfSize > 1 ? 8 : 9) + connHalfSize, 4, 7, 15, 4, 8, false, false, false, connFacing);
                            connRoom.fillRange(airState, 7 + connHalfSize, 1, 7, 15, 3, 8, false, false, false, connFacing);
                            connRoom.fillRange(wallState, 9 + connHalfSize, -2, 5, 15, -2, 10, false, false, false, connFacing);
                            connRoom.fillRange(fluidState, 9 + connHalfSize, -1, 5, 15, -1, 10, false, false, false, connFacing);
                            connRoom.fillRange(wallState, 10 + connHalfSize, 1, 4, 15, 6, 4, false, true, false, connFacing);
                            connRoom.fillRange(fluidState, 9 + connHalfSize, 0, 5, 15, 7, 5, false, true, false, connFacing);
                            connRoom.fillRange(wallState, 9 + connHalfSize, 8, 4, 15, 8, 11, false, false, false, connFacing);
                            connRoom.fillRange(fluidState, 9 + connHalfSize, 7, 6, 15, 7, 9, false, false, false, connFacing);
                            connRoom.fillRange(fluidState, 9 + connHalfSize, 0, 5, 15, 7, 5, false, true, false, connFacing);
                        }
                        if (Math.abs(connRoomDepth - this.depth) > (this.depth > 1 && ((ConnectableRoom)connRoom).getDepth() > 1 ? 3 : 7) && this.depth < connRoomDepth) {
                            hiddenConn = true;
                        }
                        dirHasConn = true;
                    }
                    if (dirHasConn) {
                        if (!deadEndConn && shouldRoomsConnect) {
                            this.fillRange(wallState, 8 + halfSize, 1, 6, 15, 4, 6, false, true, false, dir);
                            this.fillRange(wallState, (halfSize > 1 ? 8 : 9) + halfSize, 5, 6, 15, 6, 9, false, false, false, dir);
                            if (halfSize == 1) {
                                this.fillRange(stairsState.func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP).func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)dir), 8 + halfSize, 5, 7, 8 + halfSize, 5, 8, false, false, false, dir);
                                this.fillRange(airState, 8 + halfSize, 4, 7, 8 + halfSize, 4, 8, false, false, false, dir);
                            }
                            this.fillRange(wallState, 8 + halfSize, 0, 6, 15, 0, 9, false, false, false, dir);
                            this.fillRange(slabState.func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.TOP), (halfSize > 1 ? 8 : 9) + halfSize, 4, 7, 15, 4, 8, false, false, false, dir);
                            this.fillRange(airState, 8 + halfSize, 1, 7, 15, 3, 8, false, false, false, dir);
                            if (hiddenConn) {
                                this.fillRange(wallState, 8 + halfSize, 1, 7, 8 + halfSize, 5, 8, false, false, false, dir);
                            }
                            this.fillRange(wallState, 9 + halfSize, -2, 5, 15, -2, 10, false, false, false, dir);
                            this.fillRange(fluidState, 9 + halfSize, -1, 5, 15, -1, 10, false, false, false, dir);
                            this.fillRange(wallState, 10 + halfSize, -2, 4, 15, 7, 4, false, true, false, dir);
                            this.fillRange(fluidState, 9 + halfSize, 0, 5, 15, 7, 5, false, true, false, dir);
                            this.fillRange(wallState, 9 + halfSize, 8, 4, 15, 8, 11, false, false, false, dir);
                            this.fillRange(fluidState, 9 + halfSize, 7, 6, 15, 7, 9, false, false, false, dir);
                            this.fillRange(fluidState, 9 + halfSize, 0, 5, 15, 7, 5, false, true, false, dir);
                        } else {
                            dirHasConn = false;
                        }
                    }
                    if (dirHasConn && connsLeft > 0) {
                        connsLeft = Math.min(this.rand.nextInt(connsLeft) + (d << 1), connsLeft - 1);
                    }
                }
                if (dirHasConn) continue;
                this.fillRange(wallState, 8 + halfSize, 1, 7, 8 + halfSize, 5, 8, false, false, false, dir);
                this.fillRange(wallState, 10 + halfSize, -2, 6, 10 + halfSize, 7, 9, false, false, false, dir);
                this.fillRange(fluidState, 9 + halfSize, 0, 6, 9 + halfSize, 6, 9, false, false, false, dir);
            }
            if (this.deadEnd && (!sidePath || this.depth >= 32 || this.rand.nextInt(Math.max(9 - (this.depth >> 2), 2)) == 0)) {
                boolean highChest;
                fakeChest = this.size == 2 && !this.hasGlassFloor && this.rand.nextInt(4) == 0;
                boolean mainEnd = !sidePath && this.mainRoute;
                boolean bl = highChest = !sidePath && this.floor == 2;
                if (!mainEnd || this.floor == 2) {
                    if (mainEnd || this.prevRoom != this.floorStartRoom) {
                        int xDist;
                        int n = !highChest ? (halfSize > 1 ? 6 : 7) + halfSize : (xDist = 8);
                        if (this.floor < 2 || !mainEnd) {
                            boolean midChest = !highChest;
                            int chestY = !highChest ? 1 : 2;
                            ResourceLocation lootTable = null;
                            if (highChest) {
                                this.fillRange(stairsState.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)this.facing), xDist + 1, 1, 6, xDist + 1, 1, 9, true, false, true, this.facing.func_176734_d(), true);
                                this.fillRange(wallState, xDist - 1, 1, 7, xDist, 1, 8, false, false, false, this.facing);
                                lootTable = ModLootTables.spectrite_dungeon_high;
                            } else if (sidePath || this.floor < 2) {
                                int midChestChance = 4 - (!sidePath ? 2 : 0) - this.floor;
                                midChest = midChestChance == 1 || this.rand.nextInt(midChestChance) == 0;
                                ResourceLocation resourceLocation = lootTable = midChest ? ModLootTables.spectrite_dungeon_mid : ModLootTables.spectrite_dungeon_low;
                            }
                            if (!fakeChest) {
                                if (!(this.getBlockState(xDist, chestY, 7, this.facing).func_177230_c() instanceof BlockChest)) {
                                    this.fillRange((SpectriteConfig.spectriteDungeon.spectriteDungeonChestMode.shouldChestTierUseSpectriteChest(highChest ? 2 : (midChest ? 1 : 0)) ? spectriteChestState : chestState).func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)this.facing.func_176734_d()), xDist, chestY, 7, xDist, chestY, 8, false, false, false, this.facing);
                                    ((TileEntityChest)this.getTileEntity(xDist, chestY, 7, this.facing)).func_189404_a(lootTable, this.rand.nextLong());
                                    ((TileEntityChest)this.getTileEntity(xDist, chestY, 8, this.facing)).func_189404_a(lootTable, this.rand.nextLong());
                                }
                            } else {
                                this.fillRange(SpectriteConfig.spectriteDungeon.spectriteDungeonChestMode.shouldChestTierUseSpectriteChest(midChest ? 1 : 0) ? spectriteFakeTrappedChestState : fakeTrappedChestState, xDist, chestY, 7, xDist, chestY, 8, false, false, false, this.facing);
                                this.fillRange(tntState, xDist, chestY - 1, 7, xDist, chestY - 1, 8, false, false, false, this.facing);
                                this.fillRange(fakeWallState, 0, chestY - 1, 7, xDist - 1, chestY - 1, 8, false, false, false, this.facing);
                                this.fillRange(tntState, 0, chestY - 2, 7, xDist, chestY - 2, 8, false, false, false, this.facing);
                            }
                        } else {
                            this.fillRange(stairsState.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)this.facing.func_176734_d()), xDist + 3, 1, 4, xDist + 3, 1, 11, true, false, true, this.facing, true);
                            this.fillRange(stairsState, xDist + 2, 1, 5, xDist + 2, 1, 10, true, false, true, this.facing);
                            this.fillRange(airState, xDist - 2, 0, 6, xDist + 1, 0, 9, false, false, false, this.facing);
                            this.fillRange(portalState, xDist - 2, 0, 6, xDist + 1, 0, 9, false, false, false, this.facing);
                            this.fillRange(stairsState.func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), 7 - halfSize, 4, 7, 7 - halfSize, 4, 8, false, false, false, this.facing);
                            this.fillRange(stairsState, 8 - halfSize, 4, 8 - halfSize, 8 - halfSize, 4, 7 + halfSize, true, false, true, this.facing.func_176734_d(), true);
                            this.fillRange(stairsState, 9 - halfSize, 1, 8 - halfSize, 9 - halfSize, 1, 8 - halfSize, true, true, true, this.facing.func_176734_d(), true);
                            this.fillRange(wallState, 8 - halfSize, 1, 8 - halfSize, 8 - halfSize, 3, 8 - halfSize, true, true, true, this.facing);
                            this.fillRange(wallState, 8 - halfSize, 1, 11 - halfSize, 8 - halfSize, 3, 11 - halfSize, true, true, true, this.facing);
                            this.fillRange(stairsState, 5 + halfSize, 1, 7 + halfSize, 5 + halfSize, 1, 7 + halfSize, true, true, true, this.facing.func_176734_d(), true);
                            this.fillRange(stairsState.func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), 5 + halfSize, 3, 7 + halfSize, 5 + halfSize, 3, 7 + halfSize, true, true, true, this.facing.func_176734_d(), true);
                            this.fillRange(stairsState.func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), 6 + halfSize, 3, 7 + halfSize, 6 + halfSize, 3, 7 + halfSize, true, true, true, this.facing);
                            this.fillRange(stairsState, 2 + halfSize, 1, 7 + halfSize, 2 + halfSize, 1, 7 + halfSize, true, true, true, this.facing.func_176734_d(), true);
                            this.fillRange(stairsState.func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), 2 + halfSize, 3, 7 + halfSize, 2 + halfSize, 3, 7 + halfSize, true, true, true, this.facing.func_176734_d(), true);
                            this.fillRange(airState, 8 - halfSize, 1, 2 + halfSize, 8 - halfSize, 3, 3 + halfSize, false, false, false, this.facing);
                        }
                    }
                } else if (mainEnd && this.floor < 2) {
                    ((Room)this.childRooms.get(this.childRooms.size() - 1)).build();
                }
            }
            if (this.reserved && !this.reservedConnsMap.isEmpty()) {
                for (EnumFacing dir : this.reservedConnsMap.keySet()) {
                    ConnectableRoom connRoom = this.reservedConnsMap.get(dir);
                    int connHalfSize = connRoom.getSize() >> 1;
                    int connRoomDepth = connRoom.getDepth();
                    EnumFacing connFacing = dir.func_176734_d();
                    connRoom.fillRange(wallState, 8 + connHalfSize, 1, 6, 15, 4, 6, false, true, false, connFacing);
                    connRoom.fillRange(wallState, connHalfSize > 1 ? 8 : 9, 5, 6, 15, 5, 9, false, false, false, connFacing);
                    if (connHalfSize == 1) {
                        connRoom.fillRange(Room.stairsState.func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP).func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)connFacing), 8 + connHalfSize, 5, 7, 8 + connHalfSize, 5, 8, false, false, false, connFacing);
                        connRoom.fillRange(airState, 8 + connHalfSize, 4, 7, 8 + connHalfSize, 4, 8, false, false, false, connFacing);
                    }
                    connRoom.fillRange(wallState, 8 + connHalfSize, 0, 6, 15, 0, 9, false, false, false, connFacing);
                    connRoom.fillRange(slabState.func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.TOP), (connHalfSize > 1 ? 8 : 9) + connHalfSize, 4, 7, 15, 4, 8, false, false, false, connFacing);
                    connRoom.fillRange(airState, 7 + connHalfSize, 1, 7, 15, 3, 8, false, false, false, connFacing);
                    connRoom.fillRange(wallState, 9 + connHalfSize, -2, 5, 15, -2, 10, false, false, false, connFacing);
                    connRoom.fillRange(fluidState, 9 + connHalfSize, -1, 5, 15, -1, 10, false, false, false, connFacing);
                    connRoom.fillRange(wallState, 10 + connHalfSize, 1, 4, 15, 6, 4, false, true, false, connFacing);
                    connRoom.fillRange(fluidState, 9 + connHalfSize, 0, 5, 15, 7, 5, false, true, false, connFacing);
                    connRoom.fillRange(wallState, 9 + connHalfSize, 8, 4, 15, 8, 11, false, false, false, connFacing);
                    connRoom.fillRange(fluidState, 9 + connHalfSize, 7, 6, 15, 7, 9, false, false, false, connFacing);
                    connRoom.fillRange(fluidState, 9 + connHalfSize, 0, 5, 15, 7, 5, false, true, false, connFacing);
                    if (Math.abs(connRoomDepth - this.depth) <= (this.depth > 1 && connRoom.getDepth() > 1 ? 3 : 7) || this.depth >= connRoomDepth) continue;
                    this.fillRange(wallState, 8 + halfSize, 1, 7, 8 + halfSize, 4, 8, false, false, false, dir);
                }
            }
            if (this instanceof NewFloorRoom) {
                this.fillRange(wallState, 6, 4, 6, 9, 7, 6, false, true, true, this.facing);
                this.fillRange(wallState, 6, 1, 6, 9, 3, 6, false, true, false, this.facing);
                this.fillRange(wallState, 6, 1, 6, 6, 3, 9, false, false, false, this.facing);
                this.fillRange(slabState.func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.TOP), 9, 3, 7, 9, 3, 8, false, false, false, this.facing);
                this.fillRange(ladderState.func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)this.facing), 7, 1, 7, 7, 8, 8, false, false, false, this.facing);
                this.fillRange(airState, 8, 1, 7, 8, 8, 8, false, false, false, this.facing);
            }
        }

        public void resetSeed() {
            this.rand.setSeed(this.world.func_72905_C());
            long j = this.rand.nextLong();
            long k = this.rand.nextLong();
            long j1 = (long)this.chunkX * (j ^ (long)(this.floor + 1));
            long k1 = (long)this.chunkZ * (k ^ (long)(this.floor + 1));
            this.rand.setSeed(j1 ^ k1 ^ this.world.func_72905_C());
        }

        public CoreRoom getCoreRoom() {
            return this.coreRoom;
        }

        public ConnectableRoom getAdoptedRoom() {
            return this.adoptedRoom;
        }

        public int getSize() {
            return this.size;
        }

        public boolean isMainRoute() {
            return this.mainRoute;
        }

        public void setMainRoute(boolean mainRoute) {
            this.mainRoute = mainRoute;
        }

        public boolean isSidePath() {
            return this.sidePath;
        }

        public void setSidePath(boolean sidePath) {
            this.sidePath = sidePath;
        }

        public EnumFacing getBaseDir() {
            return this.baseDir;
        }

        public void setBaseDir(EnumFacing baseDir) {
            this.baseDir = baseDir;
        }
    }

    protected static abstract class Room {
        protected static IBlockState airState = Blocks.field_150350_a.func_176223_P();
        protected static IBlockState wallState = ModBlocks.spectrite_bricks.func_176223_P();
        protected static IBlockState stairsState = ModBlocks.spectrite_brick_stairs.func_176223_P();
        protected static IBlockState slabState = ModBlocks.spectrite_brick_slab_half.func_176223_P();
        protected static IBlockState ladderState = ModBlocks.spectrite_ladder.func_176223_P();
        protected static IBlockState glassState = ModBlocks.spectrite_glass.func_176223_P();
        protected static IBlockState chestState = Blocks.field_150486_ae.func_176223_P();
        protected static IBlockState spectriteChestState = ModBlocks.spectrite_chest.func_176223_P();
        protected static IBlockState mineralState = ModBlocks.spectrite_block.func_176223_P();
        protected static IBlockState fluidState = ModBlocks.molten_spectrite.func_176223_P();
        protected static IBlockState portalState = ModBlocks.spectrite_portal.func_176223_P();
        protected static IBlockState fakeWallState = ModBlocks.spectrite_bricks_fake.func_176223_P();
        protected static IBlockState fakeTrappedChestState = Blocks.field_150447_bR.func_176223_P();
        protected static IBlockState spectriteFakeTrappedChestState = ModBlocks.spectrite_chest_trapped_fake.func_176223_P();
        protected static IBlockState tntState = Blocks.field_150335_W.func_176223_P();
        protected final Random rand;
        protected final World world;
        protected final int chunkX;
        protected final int baseY;
        protected final int chunkZ;
        protected final int floor;
        protected final int depth;
        protected final EnumFacing facing;
        protected final List<Room> childRooms;

        protected Room(Random rand, int chunkX, int floor, int chunkZ, int depth, World world, EnumFacing facing) {
            this.rand = rand;
            this.chunkX = chunkX;
            this.baseY = 20 - 8 * floor;
            this.chunkZ = chunkZ;
            this.floor = floor;
            this.depth = depth;
            this.facing = facing;
            this.world = world;
            this.childRooms = new ArrayList<Room>();
        }

        public abstract void build();

        protected abstract void buildConns();

        protected abstract void reserveConns();

        protected void setBlockState(IBlockState state, int x, int y, int z) {
            this.world.func_180501_a(new BlockPos((this.chunkX << 4) + x, this.baseY + y, (this.chunkZ << 4) + z), state, 16);
        }

        protected void fillRange(IBlockState state, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean mirrorX, boolean mirrorZ, boolean mirrorAxis, EnumFacing facing, boolean useAltRotation) {
            boolean tempMirrorX;
            int tempMaxX;
            int tempMinX;
            if (facing == EnumFacing.SOUTH) {
                tempMinX = minX;
                tempMaxX = maxX;
                minX = minZ;
                minZ = tempMinX;
                maxX = maxZ;
                maxZ = tempMaxX;
                if (mirrorX != mirrorZ) {
                    tempMirrorX = mirrorX;
                    mirrorX = mirrorZ;
                    mirrorZ = tempMirrorX;
                }
            } else if (facing == EnumFacing.WEST) {
                minX = 15 - minX;
                maxX = 15 - maxX;
            } else if (facing == EnumFacing.NORTH) {
                tempMinX = minX;
                tempMaxX = maxX;
                minX = 15 - minZ;
                minZ = 15 - tempMinX;
                maxX = 15 - maxZ;
                maxZ = 15 - tempMaxX;
                if (mirrorX != mirrorZ) {
                    tempMirrorX = mirrorX;
                    mirrorX = mirrorZ;
                    mirrorZ = tempMirrorX;
                }
            }
            this.fillRange(state, minX, minY, minZ, maxX, maxY, maxZ, facing);
            if (mirrorX) {
                IBlockState rotatedState = state.func_177230_c() instanceof BlockStairs && facing.func_176740_k() == EnumFacing.Axis.X ? state.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)((EnumFacing)state.func_177229_b((IProperty)BlockStairs.field_176309_a)).func_176734_d()) : state;
                this.fillRange(rotatedState, 15 - minX, minY, minZ, 15 - maxX, maxY, maxZ, facing);
            }
            if (mirrorZ) {
                IBlockState rotatedState = state.func_177230_c() instanceof BlockStairs && facing.func_176740_k() == EnumFacing.Axis.Z ? state.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)((EnumFacing)state.func_177229_b((IProperty)BlockStairs.field_176309_a)).func_176734_d()) : state;
                this.fillRange(rotatedState, minX, minY, 15 - minZ, maxX, maxY, 15 - maxZ, facing);
            }
            if (mirrorX && mirrorZ) {
                IBlockState rotatedState = state.func_177230_c() instanceof BlockStairs ? state.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)((EnumFacing)state.func_177229_b((IProperty)BlockStairs.field_176309_a)).func_176734_d()) : state;
                this.fillRange(rotatedState, 15 - minX, minY, 15 - minZ, 15 - maxX, maxY, 15 - maxZ, facing);
            }
            if (mirrorAxis) {
                boolean isPosDir;
                boolean isXAxis = facing.func_176740_k() == EnumFacing.Axis.X;
                boolean bl = isPosDir = facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
                IBlockState rotatedState = state.func_177230_c() instanceof BlockStairs ? state.func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)(isPosDir ? facing.func_176746_e() : facing.func_176735_f())) : state;
                this.fillRange(rotatedState, isXAxis ? minX : minZ, minY, isXAxis ? minZ : minX, isXAxis ? maxX : maxZ, maxY, isXAxis ? maxZ : maxX, isXAxis ? mirrorX : mirrorZ, isXAxis ? mirrorZ : mirrorX, false, !useAltRotation ? facing.func_176746_e() : facing.func_176735_f());
            }
        }

        protected void fillRange(IBlockState state, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean mirrorX, boolean mirrorZ, boolean mirrorAxis, EnumFacing facing) {
            this.fillRange(state, minX, minY, minZ, maxX, maxY, maxZ, mirrorX, mirrorZ, mirrorAxis, facing, false);
        }

        private void fillRange(IBlockState state, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, EnumFacing facing) {
            Iterator posIterator = BlockPos.func_177980_a((BlockPos)new BlockPos((this.chunkX << 4) + minX, this.baseY + minY, (this.chunkZ << 4) + minZ), (BlockPos)new BlockPos((this.chunkX << 4) + maxX, this.baseY + maxY, (this.chunkZ << 4) + maxZ)).iterator();
            while (posIterator.hasNext()) {
                this.world.func_180501_a((BlockPos)posIterator.next(), state, 16);
            }
        }

        protected IBlockState getBlockState(int x, int y, int z, EnumFacing facing) {
            if (facing == EnumFacing.SOUTH) {
                int tempX = x;
                x = z;
                z = tempX;
            } else if (facing == EnumFacing.WEST) {
                x = 15 - x;
                z = 15 - z;
            } else if (facing == EnumFacing.NORTH) {
                int tempX = x;
                x = 15 - z;
                z = 15 - tempX;
            }
            return this.world.func_180495_p(new BlockPos((this.chunkX << 4) + x, this.baseY + y, (this.chunkZ << 4) + z));
        }

        protected TileEntity getTileEntity(int x, int y, int z, EnumFacing facing) {
            if (facing == EnumFacing.SOUTH) {
                int tempX = x;
                x = z;
                z = tempX;
            } else if (facing == EnumFacing.WEST) {
                x = 15 - x;
                z = 15 - z;
            } else if (facing == EnumFacing.NORTH) {
                int tempX = x;
                x = 15 - z;
                z = 15 - tempX;
            }
            return this.world.func_175625_s(new BlockPos((this.chunkX << 4) + x, this.baseY + y, (this.chunkZ << 4) + z));
        }

        protected abstract EnumFacing[] getRandomSortedDirs();

        public int getDepth() {
            return this.depth;
        }

        public List<Room> getChildRooms() {
            return this.childRooms;
        }
    }
}

