/*
 * Decompiled with CFR 0.152.
 */
package com.samuel.spectrite.world;

import com.google.common.base.Predicate;
import com.samuel.spectrite.SpectriteConfig;
import com.samuel.spectrite.init.ModBiomes;
import com.samuel.spectrite.init.ModBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenSpectrite
implements IWorldGenerator {
    private final WorldGenerator spectriteMinable = new WorldGenSpectriteMinable();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case 0: {
                this.generateSurface(world, random, chunkX, chunkZ);
                break;
            }
            case -1: {
                this.generateNether(world, random, chunkX, chunkZ);
                break;
            }
            case 1: {
                this.generateEnd(world, random, chunkX, chunkZ);
                break;
            }
        }
    }

    private void generateOre(Block block, World world, Random rand, int chunkX, int chunkZ, int chancesToSpawn, int minHeight, int maxHeight) {
        if (minHeight < 0 || maxHeight > 256 || minHeight > maxHeight) {
            throw new IllegalArgumentException("Illegal Height Arguments for WorldGenSpectrite");
        }
        int heightDiff = maxHeight - minHeight + 1;
        for (int i = 0; i < chancesToSpawn; ++i) {
            int x = chunkX * 16 + rand.nextInt(16);
            int y = minHeight + rand.nextInt(heightDiff);
            int z = chunkZ * 16 + rand.nextInt(16);
            this.spectriteMinable.func_180709_b(world, rand, new BlockPos(x, y, z));
        }
    }

    private void generateEnd(World world, Random random, int chunkX, int chunkZ) {
        this.generateOre((Block)ModBlocks.spectrite_ore, world, random, chunkX, chunkZ, SpectriteConfig.spectriteOre.spectriteCountEnd, SpectriteConfig.spectriteOre.spectriteMinYEnd, SpectriteConfig.spectriteOre.spectriteMaxYEnd);
    }

    private void generateSurface(World world, Random random, int chunkX, int chunkZ) {
        int chancesToSpawn = SpectriteConfig.spectriteOre.spectriteCountSurface * (world.func_180494_b(new BlockPos(chunkX << 4, 0, chunkZ << 4)) == ModBiomes.spectrite_dungeon ? 3 : 1);
        this.generateOre((Block)ModBlocks.spectrite_ore, world, random, chunkX, chunkZ, chancesToSpawn, SpectriteConfig.spectriteOre.spectriteMinYSurface, SpectriteConfig.spectriteOre.spectriteMaxYSurface);
    }

    private void generateNether(World world, Random random, int chunkX, int chunkZ) {
        this.generateOre((Block)ModBlocks.spectrite_ore, world, random, chunkX, chunkZ, SpectriteConfig.spectriteOre.spectriteCountNether, SpectriteConfig.spectriteOre.spectriteMinYNether, SpectriteConfig.spectriteOre.spectriteMaxYNether);
    }

    public class WorldGenSpectriteMinable
    extends WorldGenerator {
        private final IBlockState stateSurface = ModBlocks.spectrite_ore.func_176223_P();
        private final IBlockState stateNether = ModBlocks.spectrite_ore.func_176203_a(1);
        private final IBlockState stateEnd = ModBlocks.spectrite_ore.func_176203_a(2);

        public boolean func_180709_b(World world, Random rand, BlockPos pos) {
            IBlockState oreState;
            Block matchBlock;
            boolean isNether;
            boolean isSurface = world.field_73011_w.getDimension() == 0;
            boolean bl = isNether = world.field_73011_w.getDimension() == -1;
            Block block = isSurface ? Blocks.field_150348_b : (matchBlock = isNether ? Blocks.field_150424_aL : Blocks.field_150377_bs);
            IBlockState iBlockState = isSurface ? this.stateSurface : (oreState = isNether ? this.stateNether : this.stateEnd);
            int veinSize = rand.nextInt(rand.nextInt(rand.nextInt((isSurface ? SpectriteConfig.spectriteOre.spectriteMaxSizeSurface : (isNether ? SpectriteConfig.spectriteOre.spectriteMaxSizeNether : SpectriteConfig.spectriteOre.spectriteMaxSizeEnd)) + 1) + 1) + 1) + (isSurface ? SpectriteConfig.spectriteOre.spectriteMinSizeSurface : (isNether ? SpectriteConfig.spectriteOre.spectriteMinSizeNether : SpectriteConfig.spectriteOre.spectriteMinSizeEnd));
            new WorldGenMinable(oreState, veinSize, (Predicate)BlockMatcher.func_177642_a((Block)matchBlock)).func_180709_b(world, rand, pos);
            return true;
        }
    }
}

