/*
 * Decompiled with CFR 0.152.
 */
package com.samuel.spectrite.world;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.storage.WorldSavedData;

public class SpectriteSkullData
extends WorldSavedData {
    private static final String[] dimensions = new String[]{"Nether", "Overworld"};
    private List<ChunkPos>[] spawnChunks = new List[2];
    private List<Integer>[] baseYCoords = new List[2];
    private List<Integer>[] skullChunksGenerated = new List[2];

    public SpectriteSkullData(String name) {
        super(name);
        for (int d = 0; d <= 1; ++d) {
            this.spawnChunks[d] = new ArrayList<ChunkPos>();
            this.baseYCoords[d] = new ArrayList<Integer>();
            this.skullChunksGenerated[d] = new ArrayList<Integer>();
        }
    }

    public void func_76184_a(NBTTagCompound nbt) {
        for (int d = 0; d < dimensions.length; ++d) {
            if (!nbt.func_74764_b("data" + dimensions[d])) continue;
            NBTTagList dataList = nbt.func_150295_c("data" + dimensions[d], 11);
            for (int cp = 0; cp < dataList.func_74745_c(); ++cp) {
                int[] data = dataList.func_150306_c(cp);
                this.spawnChunks[d].add(new ChunkPos(data[0], data[1]));
                this.baseYCoords[d].add(data[2]);
                this.skullChunksGenerated[d].add(data[3]);
            }
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        for (int d = 0; d < dimensions.length; ++d) {
            NBTTagList dataList = new NBTTagList();
            for (int cp = 0; cp < this.spawnChunks[d].size(); ++cp) {
                ChunkPos chunkPos = this.spawnChunks[d].get(cp);
                dataList.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{chunkPos.field_77276_a, chunkPos.field_77275_b, this.baseYCoords[d].get(cp), this.skullChunksGenerated[d].get(cp)}));
            }
            compound.func_74782_a("data" + dimensions[d], (NBTBase)dataList);
        }
        return compound;
    }

    public List<ChunkPos> getSpawnChunks(int dimensionId) {
        return this.spawnChunks[dimensionId + 1];
    }

    public void setSpawnChunk(int chunkX, int chunkZ, int baseY, int dimensionId) {
        this.spawnChunks[dimensionId + 1].add(new ChunkPos(chunkX, chunkZ));
        this.baseYCoords[dimensionId + 1].add(baseY);
        this.skullChunksGenerated[dimensionId + 1].add(0);
        this.func_76185_a();
    }

    public int getBaseYCoord(int chunkX, int chunkZ, int dimensionId) {
        int i = this.spawnChunks[dimensionId + 1].indexOf(new ChunkPos(chunkX, chunkZ));
        return i > -1 ? this.baseYCoords[dimensionId + 1].get(i) : -1;
    }

    public int getSkullChunksGenerated(int chunkX, int chunkZ, int dimensionId) {
        int i = this.spawnChunks[dimensionId + 1].indexOf(new ChunkPos(chunkX, chunkZ));
        return i > -1 ? this.skullChunksGenerated[dimensionId + 1].get(i) : 0;
    }

    public void setSkullChunksGenerated(int chunkX, int chunkZ, int generatedChunkCount, int dimensionId) {
        int i = this.spawnChunks[dimensionId + 1].indexOf(new ChunkPos(chunkX, chunkZ));
        this.skullChunksGenerated[dimensionId + 1].set(i, generatedChunkCount);
        this.func_76185_a();
    }
}

