/*
 * Decompiled with CFR 0.152.
 */
package com.samuel.spectrite.update;

import com.samuel.spectrite.SpectriteConfig;
import com.samuel.spectrite.helpers.SpectriteHelper;
import com.samuel.spectrite.update.UpdateCheckThread;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class UpdateNotifier {
    public static final String DOWNLOAD_URL = "https://minecraft.curseforge.com/projects/spectrite-mod/files";
    public static boolean success;
    private static boolean notified;
    public static String updateVersion;
    public static boolean newVersion;
    private static int ticksElapsed;
    private UpdateCheckThread updateCheckThread = null;

    public UpdateNotifier() {
        if (SpectriteConfig.checkForUpdates) {
            this.updateCheckThread = new UpdateCheckThread();
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    @SideOnly(value=Side.CLIENT)
    public void onTick(TickEvent.ClientTickEvent event) {
        if (SpectriteConfig.checkForUpdates && !notified && (newVersion || !success) && Minecraft.func_71410_x().field_71439_g != null && ++ticksElapsed >= 700) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            String modName = SpectriteHelper.getMultiColouredString(I18n.func_74838_a((String)"spectrite.update.modname"), false);
            if (!success) {
                player.func_145747_a(ITextComponent.Serializer.func_150699_a((String)String.format(I18n.func_74838_a((String)"spectrite.update.failed"), modName)));
            } else {
                player.func_145747_a(ITextComponent.Serializer.func_150699_a((String)String.format(I18n.func_74838_a((String)"spectrite.update.update").replace("{MCVERSION}", "1.12.1"), modName)));
                player.func_145747_a(ITextComponent.Serializer.func_150699_a((String)String.format(I18n.func_74838_a((String)"spectrite.update.versions"), "1.7.1", updateVersion)));
                player.func_145747_a(ITextComponent.Serializer.func_150699_a((String)String.format(I18n.func_74838_a((String)"spectrite.update.download"), DOWNLOAD_URL)));
            }
            notified = true;
            ticksElapsed = 0;
        }
    }

    static {
        notified = false;
        updateVersion = "";
        newVersion = false;
        ticksElapsed = 0;
    }
}

