/*
 * Decompiled with CFR 0.152.
 */
package com.samuel.spectrite.update;

import com.samuel.spectrite.update.UpdateNotifier;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;

public class UpdateCheckThread
extends Thread {
    public UpdateCheckThread() {
        this.setName("Spectrite Update Check Thread");
        this.setDaemon(true);
        this.start();
    }

    @Override
    public void run() {
        try {
            String inputLine;
            String currentMcVersion = "1.12.1";
            URL buildFileUrl = new URL(String.format("https://raw.githubusercontent.com/Samuel-Harbord/Spectrite/%s/build.gradle", currentMcVersion));
            BufferedReader in = new BufferedReader(new InputStreamReader(buildFileUrl.openStream()));
            while ((inputLine = in.readLine()) != null) {
                if (!inputLine.startsWith("version = ")) continue;
                UpdateNotifier.updateVersion = inputLine.substring(11, inputLine.lastIndexOf("\""));
                break;
            }
            in.close();
            if (!StringUtils.isEmpty((CharSequence)UpdateNotifier.updateVersion)) {
                String clientVersionString = "1.7.1";
                String[] updateVersionComponents = UpdateNotifier.updateVersion.split("\\.");
                String[] currentVersionComponents = clientVersionString.split("\\.");
                int minComponents = Math.min(updateVersionComponents.length, currentVersionComponents.length);
                for (int i = 0; i < minComponents; ++i) {
                    int currentVersionComponent;
                    int updateVersionComponent = Integer.parseInt(updateVersionComponents[i]);
                    if (updateVersionComponent != (currentVersionComponent = Integer.parseInt(currentVersionComponents[i]))) {
                        if (updateVersionComponent <= currentVersionComponent) break;
                        UpdateNotifier.newVersion = true;
                        break;
                    }
                    if (i != minComponents - 1 || currentVersionComponents.length == updateVersionComponents.length || currentVersionComponents.length != minComponents) continue;
                    UpdateNotifier.newVersion = true;
                }
                UpdateNotifier.success = true;
            } else {
                UpdateNotifier.success = false;
            }
        }
        catch (Exception e) {
            UpdateNotifier.success = false;
            System.err.println("Spectrite failed to check for updates.");
        }
    }
}

