/*
 * Decompiled with CFR 0.152.
 */
package com.samuel.spectrite.tileentity;

import com.samuel.spectrite.SpectriteConfig;
import com.samuel.spectrite.blocks.BlockSpectriteChest;
import com.samuel.spectrite.containers.ContainerSpectriteChest;
import com.samuel.spectrite.helpers.SpectriteHelper;
import com.samuel.spectrite.init.ModEnchantments;
import com.samuel.spectrite.inventory.InventoryLargeSpectriteChest;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntitySpectriteChest
extends TileEntityChest {
    private int ticksSinceSync;
    private BlockChest.Type cachedChestType = null;
    private String customName;

    public String func_70005_c_() {
        return this.func_145748_c_().func_150260_c();
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void func_190575_a(String name) {
        super.func_190575_a(name);
        this.customName = name;
    }

    public ITextComponent func_145748_c_() {
        if (this.field_145854_h == null) {
            this.field_145854_h = this.func_145838_q();
        }
        String name = this.field_145854_h.func_149739_a() + ".name";
        if (((BlockSpectriteChest)this.field_145854_h).func_176454_e(this.field_145850_b, this.field_174879_c)) {
            name = name.substring(0, 5) + "large_" + name.substring(5);
        }
        return new TextComponentTranslation(name, new Object[0]);
    }

    public BlockChest.Type func_145980_j() {
        if (this.cachedChestType == null) {
            if (this.field_145850_b == null || !(this.func_145838_q() instanceof BlockSpectriteChest)) {
                return BlockChest.Type.BASIC;
            }
            this.cachedChestType = ((BlockSpectriteChest)this.func_145838_q()).field_149956_a;
        }
        return this.cachedChestType.ordinal() == 0 ? BlockChest.Type.BASIC : BlockChest.Type.TRAP;
    }

    public BlockChest.Type getMineralChestType() {
        if (this.cachedChestType == null) {
            if (this.field_145850_b == null || !(this.func_145838_q() instanceof BlockSpectriteChest)) {
                return BlockChest.Type.BASIC;
            }
            this.cachedChestType = ((BlockSpectriteChest)this.func_145838_q()).field_149956_a;
        }
        return this.cachedChestType;
    }

    protected TileEntityChest func_174911_a(EnumFacing side) {
        TileEntity tileentity;
        BlockPos blockpos = this.field_174879_c.func_177972_a(side);
        if (this.isChestAt(blockpos) && (tileentity = this.field_145850_b.func_175625_s(blockpos)) instanceof TileEntitySpectriteChest) {
            TileEntitySpectriteChest tileentitychest = (TileEntitySpectriteChest)tileentity;
            tileentitychest.func_174910_a(this, side.func_176734_d());
            return tileentitychest;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-1, 0, -1), this.field_174879_c.func_177982_a(2, 2, 2));
    }

    private boolean isChestAt(BlockPos posIn) {
        if (this.field_145850_b == null) {
            return false;
        }
        Block block = this.field_145850_b.func_180495_p(posIn).func_177230_c();
        return block instanceof BlockSpectriteChest && ((BlockSpectriteChest)block).field_149956_a == this.getMineralChestType();
    }

    private void func_174910_a(TileEntitySpectriteChest chestTe, EnumFacing side) {
        if (chestTe.func_145837_r()) {
            this.field_145984_a = false;
        } else if (this.field_145984_a) {
            switch (side) {
                case NORTH: {
                    if (this.field_145992_i == chestTe) break;
                    this.field_145984_a = false;
                    break;
                }
                case SOUTH: {
                    if (this.field_145988_l == chestTe) break;
                    this.field_145984_a = false;
                    break;
                }
                case EAST: {
                    if (this.field_145990_j == chestTe) break;
                    this.field_145984_a = false;
                    break;
                }
                case WEST: {
                    if (this.field_145991_k == chestTe) break;
                    this.field_145984_a = false;
                }
            }
        }
    }

    public void func_73660_a() {
        this.func_145979_i();
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        ++this.ticksSinceSync;
        if (!this.field_145850_b.field_72995_K && (this.ticksSinceSync + i + j + k) % 200 == 0) {
            if (this.field_145987_o != 0) {
                this.field_145987_o = 0;
                for (EntityPlayer entityplayer : this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)((float)i - 5.0f), (double)((float)j - 5.0f), (double)((float)k - 5.0f), (double)((float)(i + 1) + 5.0f), (double)((float)(j + 1) + 5.0f), (double)((float)(k + 1) + 5.0f)))) {
                    IInventory iinventory;
                    if (!(entityplayer.field_71070_bA instanceof ContainerSpectriteChest) || (iinventory = ((ContainerSpectriteChest)entityplayer.field_71070_bA).func_85151_d()) != this && (!(iinventory instanceof InventoryLargeSpectriteChest) || !((InventoryLargeSpectriteChest)iinventory).func_90010_a((IInventory)this))) continue;
                    ++this.field_145987_o;
                }
            }
            if (this.trySpectriteEnhance()) {
                ((WorldServer)this.field_145850_b).func_180505_a(EnumParticleTypes.FIREWORKS_SPARK, EnumParticleTypes.FIREWORKS_SPARK.func_179344_e(), (double)i + 0.5, (double)j + 1.5, (double)k + 0.5, 7, this.field_145850_b.field_73012_v.nextGaussian() * 0.125, this.field_145850_b.field_73012_v.nextGaussian() * 0.125, this.field_145850_b.field_73012_v.nextGaussian() * 0.125, 0.1, new int[0]);
                this.field_145850_b.func_184148_a((EntityPlayer)null, (double)i + 0.5, (double)j + 0.5, (double)k + 0.5, SoundEvents.field_187802_ec, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.4f + 1.0f);
            }
        }
        this.field_145986_n = this.field_145989_m;
        if (this.field_145987_o > 0 && this.field_145989_m == 0.0f && this.field_145992_i == null && this.field_145991_k == null) {
            double d1 = (double)i + 0.5;
            double d2 = (double)k + 0.5;
            if (this.field_145988_l != null) {
                d2 += 0.5;
            }
            if (this.field_145990_j != null) {
                d1 += 0.5;
            }
            this.field_145850_b.func_184148_a((EntityPlayer)null, d1, (double)j + 0.5, d2, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.field_145987_o == 0 && this.field_145989_m > 0.0f || this.field_145987_o > 0 && this.field_145989_m < 1.0f) {
            float f2 = this.field_145989_m;
            this.field_145989_m = this.field_145987_o > 0 ? (this.field_145989_m += 0.1f) : (this.field_145989_m -= 0.1f);
            if (this.field_145989_m > 1.0f) {
                this.field_145989_m = 1.0f;
            }
            if (this.field_145989_m < 0.5f && f2 >= 0.5f && this.field_145992_i == null && this.field_145991_k == null) {
                double d3 = (double)i + 0.5;
                double d0 = (double)k + 0.5;
                if (this.field_145988_l != null) {
                    d0 += 0.5;
                }
                if (this.field_145990_j != null) {
                    d3 += 0.5;
                }
                this.field_145850_b.func_184148_a((EntityPlayer)null, d3, (double)j + 0.5, d0, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.field_145989_m < 0.0f) {
                this.field_145989_m = 0.0f;
            }
        }
    }

    public Block func_145838_q() {
        if (this.field_145854_h == null && this.field_145850_b != null) {
            this.field_145854_h = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
            this.cachedChestType = this.getMineralChestType();
        }
        return this.field_145854_h;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.func_145836_u();
        this.func_145979_i();
    }

    public String func_174875_k() {
        return "minecraft:chest";
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerSpectriteChest((IInventory)playerInventory, (IInventory)this, playerIn);
    }

    private Map<Integer, ItemStack> getPerfectSpectriteItemsAndSlots() {
        LinkedHashMap<Integer, ItemStack> ret = new LinkedHashMap<Integer, ItemStack>();
        Iterator inventoryIterator = this.func_190576_q().iterator();
        int i = 0;
        while (inventoryIterator.hasNext()) {
            ItemStack s = (ItemStack)inventoryIterator.next();
            if (ModEnchantments.spectrite_enhance.canApplyAtSpectriteAnvil(s)) {
                ret.put(i, s);
            }
            ++i;
        }
        return ret;
    }

    public boolean trySpectriteEnhance() {
        double enchantRate = SpectriteConfig.blocks.spectriteChestEnchantRate;
        if (enchantRate > 0.0 && this.field_145850_b.field_73012_v.nextInt((int)(100.0 / enchantRate)) == 0) {
            ItemStack enchantedStack;
            int index = this.field_145850_b.field_73012_v.nextInt(this.func_70302_i_());
            Map<Integer, ItemStack> slotStacks = this.getPerfectSpectriteItemsAndSlots();
            if (slotStacks.containsKey(index) && !SpectriteHelper.isStackSpectriteEnhanced(enchantedStack = slotStacks.get(index))) {
                enchantedStack.func_77966_a((Enchantment)ModEnchantments.spectrite_enhance, 1);
                this.func_70299_a(index, enchantedStack);
                return true;
            }
        }
        return false;
    }
}

