/*
 * Decompiled with CFR 0.152.
 */
package com.samuel.spectrite.proxy;

import com.samuel.spectrite.Spectrite;
import com.samuel.spectrite.SpectriteConfig;
import com.samuel.spectrite.client.gui.GuiHandlerSpectriteRepair;
import com.samuel.spectrite.client.particles.EnumSpectriteParticleTypes;
import com.samuel.spectrite.entities.EntitySpectriteEnderman;
import com.samuel.spectrite.entities.EntitySpectriteWitherSkull;
import com.samuel.spectrite.etc.SpectriteExplosion;
import com.samuel.spectrite.eventhandlers.SpectriteGeneralEventHandler;
import com.samuel.spectrite.helpers.SpectriteHelper;
import com.samuel.spectrite.init.ModBiomes;
import com.samuel.spectrite.init.ModBlocks;
import com.samuel.spectrite.init.ModCrafting;
import com.samuel.spectrite.init.ModDamageSources;
import com.samuel.spectrite.init.ModDispenserBehavior;
import com.samuel.spectrite.init.ModEnchantments;
import com.samuel.spectrite.init.ModEntities;
import com.samuel.spectrite.init.ModItems;
import com.samuel.spectrite.init.ModLootTables;
import com.samuel.spectrite.init.ModPotions;
import com.samuel.spectrite.init.ModSounds;
import com.samuel.spectrite.init.ModTileEntities;
import com.samuel.spectrite.init.ModWorldGen;
import com.samuel.spectrite.packets.PacketSpectriteExplosion;
import com.samuel.spectrite.packets.PacketSpectriteParticles;
import com.samuel.spectrite.update.UpdateNotifier;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CommonProxy {
    public void preInit(FMLPreInitializationEvent e) {
        ModEntities.initEntities(Spectrite.Instance);
        Spectrite.ItemPropertyGetterSpectrite = new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                EntityLivingBase entity;
                boolean flag = entityIn != null;
                Object object = entity = flag ? entityIn : stack.func_82836_z();
                if (worldIn == null && entity != null) {
                    worldIn = entity.field_70170_p;
                }
                if (worldIn == null) {
                    return 0.0f;
                }
                float time = (float)MathHelper.func_76123_f((float)((float)((worldIn.func_82737_E() >> 1) % 36L) * 0.2777f * 1000.0f)) / 10000.0f;
                return time;
            }
        };
        ModPotions.initPotionEffects();
        ModBlocks.createBlocks();
        ModItems.createItems();
        ModLootTables.registerLootTables();
        ModSounds.initSounds();
        ModTileEntities.initTileEntities();
        ModDispenserBehavior.initDispenserBehavior();
        ModEnchantments.initEnchantments();
        ModDamageSources.initDamageSources();
        ModBiomes.initBiomes();
        ModWorldGen.initWorldGen();
        NBTTagCompound tinkersSmelteryTag = new NBTTagCompound();
        tinkersSmelteryTag.func_74778_a("fluid", ModBlocks.fluid_molten_spectrite.getName());
        tinkersSmelteryTag.func_74778_a("ore", "Spectrite");
        tinkersSmelteryTag.func_74757_a("toolforge", true);
        FMLInterModComms.sendMessage((String)"tconstruct", (String)"integrateSmeltery", (NBTTagCompound)tinkersSmelteryTag);
        FMLCommonHandler.instance().bus().register((Object)Spectrite.Instance);
        MinecraftForge.EVENT_BUS.register((Object)new ModBlocks());
        MinecraftForge.EVENT_BUS.register((Object)new ModItems());
        MinecraftForge.EVENT_BUS.register((Object)new ModEntities());
        MinecraftForge.EVENT_BUS.register((Object)new ModBiomes());
        MinecraftForge.EVENT_BUS.register((Object)new ModPotions());
        MinecraftForge.EVENT_BUS.register((Object)new ModEnchantments());
        MinecraftForge.EVENT_BUS.register((Object)new ModSounds());
        MinecraftForge.EVENT_BUS.register((Object)new SpectriteGeneralEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)ModWorldGen.spectriteDungeon);
        MinecraftForge.EVENT_BUS.register((Object)ModWorldGen.spectriteSkull);
        MinecraftForge.EVENT_BUS.register((Object)Spectrite.Instance);
        MinecraftForge.EVENT_BUS.register((Object)new UpdateNotifier());
    }

    public void init(FMLInitializationEvent e) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)Spectrite.Instance, (IGuiHandler)new GuiHandlerSpectriteRepair());
        ModCrafting.initSmelting();
        ModCrafting.initBrewing();
    }

    public void postInit(FMLPostInitializationEvent e) {
        ModItems.populateBowItems();
        EntitySpectriteEnderman.initCarriableBlocks();
    }

    public void performDispersedSpectriteDamage(World world, int power, int explosionPower, Vec3d hitCoords, Entity source, Entity indirectSource, Random rand) {
        if (!world.field_72995_K) {
            BlockPos hitPos = new BlockPos(hitCoords);
            List surrounding = world.func_72839_b(source, new AxisAlignedBB(hitPos.func_177964_d(power).func_177985_f(power).func_177979_c(power), hitPos.func_177970_e(power).func_177965_g(power).func_177981_b(power)));
            boolean arrow = source instanceof EntityArrow;
            if (indirectSource == null) {
                indirectSource = source;
            }
            power = SpectriteHelper.getSpectriteDamageAmplifierAfterStrength(power, indirectSource);
            if (explosionPower > -1) {
                boolean allowGriefing = source instanceof EntitySpectriteWitherSkull ? (indirectSource != null && indirectSource instanceof EntityPlayer ? SpectriteConfig.items.spectriteWitherRodGriefing : world.func_82736_K().func_82766_b("mobGriefing")) : world.func_82736_K().func_82766_b("mobGriefing");
                Spectrite.Proxy.newSpectriteExplosion(world, source, source.field_70165_t, source.field_70163_u + (double)(source.field_70131_O / 2.0f), source.field_70161_v, new Integer(explosionPower).floatValue(), false, allowGriefing, true);
            }
            for (int s = 0; s < surrounding.size(); ++s) {
                double health;
                if (!(surrounding.get(s) instanceof EntityLivingBase) || indirectSource != null && (((Entity)surrounding.get(s)).func_184191_r(indirectSource) || ((Entity)surrounding.get(s)).equals((Object)indirectSource))) continue;
                EntityLivingBase curEntity = (EntityLivingBase)surrounding.get(s);
                double distance = curEntity.func_70092_e(hitCoords.field_72450_a, hitCoords.field_72448_b - (double)(curEntity.field_70131_O / 2.0f), hitCoords.field_72449_c);
                double d = health = distance >= 1.0 ? 1.0 - Math.sqrt(distance) / (double)(power + 2) : 1.0;
                if (!(health > 0.0) || arrow && SpectriteConfig.items.spectriteArrowDamageMode == SpectriteConfig.EnumSpectriteArrowDamageMode.EXPLOSION) continue;
                ModPotions.SPECTRITE_DAMAGE.func_180793_a(source, indirectSource, curEntity, power, health);
            }
            try {
                if (power == 1) {
                    world.func_184133_a(null, hitPos, SoundEvents.field_187625_bm, SoundCategory.PLAYERS, 1.0f + Math.max((float)explosionPower, 0.0f), 1.0f + rand.nextFloat() * 0.4f);
                } else if (power == 2) {
                    world.func_184133_a(null, hitPos, SoundEvents.field_187539_bB, SoundCategory.PLAYERS, 0.75f + Math.max((float)explosionPower, 0.0f), 1.6f + rand.nextFloat() * 0.4f);
                } else if (power == 3) {
                    world.func_184133_a(null, hitPos, SoundEvents.field_187539_bB, SoundCategory.PLAYERS, 0.75f + Math.max((float)explosionPower, 0.0f), 1.0f + rand.nextFloat() * 0.4f);
                } else if (power == 4) {
                    world.func_184133_a(null, hitPos, ModSounds.explosion, SoundCategory.PLAYERS, 0.75f + Math.max((float)explosionPower, 0.0f), 1.0f + rand.nextFloat() * 0.4f);
                } else if (power == 5) {
                    world.func_184133_a(null, hitPos, ModSounds.explosion, SoundCategory.PLAYERS, 0.75f + Math.max((float)explosionPower, 0.0f), 0.75f + world.field_73012_v.nextFloat() * 0.4f);
                    world.func_184133_a(null, hitPos, ModSounds.fatality, SoundCategory.PLAYERS, 1.0f + Math.max((float)explosionPower, 0.0f), 1.0f);
                } else if (power >= 6) {
                    world.func_184133_a(null, hitPos, ModSounds.explosion, SoundCategory.PLAYERS, 0.75f + Math.max((float)explosionPower, 0.0f), 0.5f + world.field_73012_v.nextFloat() * 0.4f);
                    world.func_184133_a(null, hitPos, ModSounds.fatality, SoundCategory.PLAYERS, 1.0f + Math.max((float)explosionPower, 0.0f), 0.75f);
                }
                if (explosionPower < 0) {
                    if (power == 1) {
                        Spectrite.Proxy.spawnSpectriteExplosionParticle(world, true, hitCoords.field_72450_a, hitCoords.field_72448_b, hitCoords.field_72449_c, 0.0, 0.0, 0.0);
                    } else {
                        Spectrite.Proxy.spawnSpectriteExplosionHugeParticle(world, hitCoords.field_72450_a, hitCoords.field_72448_b, hitCoords.field_72449_c, 0.0, 0.0, 0.0, power);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void spawnSpectriteSpellParticle(World world, double posX, double posY, double posZ, double r, double g, double b, float hueOffset) {
        this.spawnSpectriteParticle(world, EnumSpectriteParticleTypes.SPECTRITE_SPELL, posX, posY, posZ, r, g, b, hueOffset);
    }

    public void spawnSpectriteExplosionParticle(World world, boolean isLarge, double posX, double posY, double posZ, double xSpeed, double ySpeed, double zSpeed) {
        this.spawnSpectriteParticle(world, isLarge ? EnumSpectriteParticleTypes.SPECTRITE_EXPLOSION_LARGE : EnumSpectriteParticleTypes.SPECTRITE_EXPLOSION_NORMAL, posX, posY, posZ, xSpeed, ySpeed, zSpeed, 0.0);
    }

    public void spawnSpectriteExplosionHugeParticle(World world, double posX, double posY, double posZ, double xSpeed, double ySpeed, double zSpeed, double strength) {
        this.spawnSpectriteParticle(world, EnumSpectriteParticleTypes.SPECTRITE_EXPLOSION_HUGE, posX, posY, posZ, xSpeed, ySpeed, zSpeed, strength);
    }

    public void spawnSpectriteSmokeNormalParticle(World world, double posX, double posY, double posZ, double xSpeed, double ySpeed, double zSpeed) {
        this.spawnSpectriteParticle(world, EnumSpectriteParticleTypes.SPECTRITE_SMOKE_NORMAL, posX, posY, posZ, xSpeed, ySpeed, zSpeed, 0.0);
    }

    public void spawnSpectriteSmokeLargeParticle(World world, double posX, double posY, double posZ, double xSpeed, double ySpeed, double zSpeed) {
        this.spawnSpectriteParticle(world, EnumSpectriteParticleTypes.SPECTRITE_SMOKE_LARGE, posX, posY, posZ, xSpeed, ySpeed, zSpeed, 0.0);
    }

    public void spawnSpectritePortalParticle(World world, double posX, double posY, double posZ, double xSpeed, double ySpeed, double zSpeed) {
        this.spawnSpectriteParticle(world, EnumSpectriteParticleTypes.SPECTRITE_PORTAL, posX, posY, posZ, xSpeed, ySpeed, zSpeed, 0.0);
    }

    private void spawnSpectriteParticle(World world, EnumSpectriteParticleTypes particleTypes, double posX, double posY, double posZ, double xSpeed, double ySpeed, double zSpeed, double hueOffset) {
        for (int i = 0; i < world.field_73010_i.size(); ++i) {
            EntityPlayerMP entityPlayerMP = (EntityPlayerMP)world.field_73010_i.get(i);
            if (!(entityPlayerMP.func_180425_c().func_185332_f((int)posX, (int)posY, (int)posZ) <= 1024.0)) continue;
            PacketSpectriteParticles spectriteParticlesPacket = new PacketSpectriteParticles(particleTypes, (float)posX, (float)posY, (float)posZ, (float)xSpeed, (float)ySpeed, (float)zSpeed, 0.0f, 1, hueOffset);
            Spectrite.Network.sendTo((IMessage)spectriteParticlesPacket, entityPlayerMP);
        }
    }

    public SpectriteExplosion newSpectriteExplosion(World world, Entity entityIn, double x, double y, double z, float strength, boolean isFlaming, boolean isSmoking, boolean overrideSound) {
        SpectriteExplosion explosion = new SpectriteExplosion(world, entityIn, x, y, z, strength, isFlaming, isSmoking, overrideSound);
        if (ForgeEventFactory.onExplosionStart((World)world, (Explosion)explosion)) {
            return explosion;
        }
        explosion.func_77278_a();
        explosion.func_77279_a(true);
        if (!world.field_72995_K) {
            if (!isSmoking) {
                explosion.func_180342_d();
            }
            for (EntityPlayer entityPlayer : ((WorldServer)world).field_73010_i) {
                if (!(entityPlayer.func_70092_e(x, y, z) < 4096.0)) continue;
                Spectrite.Network.sendTo((IMessage)new PacketSpectriteExplosion(x, y, z, strength, isSmoking, explosion.func_180343_e(), (Vec3d)explosion.func_77277_b().get(entityPlayer)), (EntityPlayerMP)entityPlayer);
            }
        }
        return explosion;
    }

    static {
        FluidRegistry.enableUniversalBucket();
    }
}

