/*
 * Decompiled with CFR 0.152.
 */
package com.samuel.spectrite.proxy;

import com.samuel.spectrite.client.eventhandlers.SpectriteClientEventHandler;
import com.samuel.spectrite.client.model.ModelMoltenSpectrite;
import com.samuel.spectrite.client.particles.ParticleSpectriteExplosionHuge;
import com.samuel.spectrite.client.particles.ParticleSpectriteExplosionLarge;
import com.samuel.spectrite.client.particles.ParticleSpectriteSpell;
import com.samuel.spectrite.client.renderer.BlockRenderRegister;
import com.samuel.spectrite.client.renderer.EntityRenderRegister;
import com.samuel.spectrite.client.renderer.ItemRenderRegister;
import com.samuel.spectrite.client.renderer.SpectriteParticleManager;
import com.samuel.spectrite.client.renderer.TileEntityRenderRegister;
import com.samuel.spectrite.helpers.SpectriteHelper;
import com.samuel.spectrite.init.ModItems;
import com.samuel.spectrite.items.ItemSpectriteOrb;
import com.samuel.spectrite.proxy.CommonProxy;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleExplosion;
import net.minecraft.client.particle.ParticlePortal;
import net.minecraft.client.particle.ParticleSmokeLarge;
import net.minecraft.client.particle.ParticleSmokeNormal;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    private SpectriteClientEventHandler clientEventHandler = null;

    @Override
    public void preInit(FMLPreInitializationEvent e) {
        super.preInit(e);
        this.clientEventHandler = new SpectriteClientEventHandler();
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)ModelMoltenSpectrite.FluidLoader.INSTANCE);
        Field configsField = ReflectionHelper.findField(ConfigManager.class, (String[])new String[]{"CONFIGS"});
        try {
            Map configs = (Map)configsField.get(null);
            Optional<String> key = configs.keySet().stream().filter(c -> c.contains("spectrite")).findFirst();
            if (key.isPresent()) {
                Configuration config = (Configuration)configs.get(key.get());
                config.getCategory("spectriteore").entrySet().forEach(p -> ((Property)p.getValue()).setConfigEntryClass(GuiConfigEntries.NumberSliderEntry.class));
            }
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
        }
        MinecraftForge.EVENT_BUS.register((Object)new BlockRenderRegister());
        MinecraftForge.EVENT_BUS.register((Object)new ItemRenderRegister());
        MinecraftForge.EVENT_BUS.register((Object)new EntityRenderRegister());
        MinecraftForge.EVENT_BUS.register((Object)new TileEntityRenderRegister());
        MinecraftForge.EVENT_BUS.register((Object)this.clientEventHandler);
    }

    @Override
    public void init(FMLInitializationEvent e) {
        super.init(e);
        ItemColors itemColors = Minecraft.func_71410_x().getItemColors();
        itemColors.func_186730_a(new IItemColor(){
            Int2ObjectMap<Integer[]> colourCache = new Int2ObjectOpenHashMap();
            Int2ObjectMap<Integer[]> coloursListCache = new Int2ObjectOpenHashMap();

            @SideOnly(value=Side.CLIENT)
            public int func_186726_a(ItemStack stack, int tintIndex) {
                int ret = 0xFFFFFF;
                if (tintIndex < 17) {
                    int spectriteFrame = SpectriteHelper.getCurrentSpectriteFrame(null);
                    int itemDamage = stack.func_77952_i();
                    if (itemDamage > 0) {
                        if (this.colourCache.containsKey(itemDamage) && ((Integer[])this.colourCache.get(itemDamage))[tintIndex * 36 + spectriteFrame] != null) {
                            ret = ((Integer[])this.colourCache.get(itemDamage))[tintIndex * 36 + spectriteFrame];
                        } else {
                            Integer[] colours;
                            if (this.coloursListCache.containsKey(itemDamage)) {
                                colours = (Integer[])this.coloursListCache.get(itemDamage);
                            } else {
                                ArrayList<Integer> coloursList = new ArrayList<Integer>();
                                int[] orbTypes = ItemSpectriteOrb.ORB_COLOURS;
                                int[][] orbTypeRGB = ItemSpectriteOrb.ORB_COLOUR_RGB;
                                for (int c = 0; c < orbTypes.length; ++c) {
                                    if ((itemDamage & orbTypes[c]) <= 0) continue;
                                    for (int rgb = 0; rgb < 3; ++rgb) {
                                        coloursList.add(orbTypeRGB[c][rgb]);
                                    }
                                }
                                colours = coloursList.toArray(new Integer[0]);
                                this.coloursListCache.put(itemDamage, (Object)colours);
                            }
                            if (colours.length == 3) {
                                ret = new Color(colours[0], colours[1], colours[2]).getRGB();
                            } else {
                                float partSize = 51.0f / (float)colours.length - 1.0f;
                                float progress = ((float)tintIndex / partSize + (float)colours.length / 108.0f * (float)spectriteFrame) % (float)(colours.length / 3);
                                int startIndex = (int)Math.floor(progress);
                                progress -= (float)startIndex;
                                int[] rgb = new int[3];
                                for (int c = 0; c < 3; ++c) {
                                    rgb[c] = Math.round((float)colours[startIndex * 3 + c].intValue() * (1.0f - progress) + (float)colours[(startIndex < colours.length / 3 - 1 ? startIndex + 1 : 0) * 3 + c].intValue() * progress);
                                }
                                ret = new Color(rgb[0], rgb[1], rgb[2]).getRGB();
                            }
                            if (this.colourCache.containsKey(itemDamage)) {
                                ((Integer[])this.colourCache.get((int)itemDamage))[tintIndex * 36 + spectriteFrame] = ret;
                            } else {
                                Integer[] colourCacheEntry = new Integer[612];
                                colourCacheEntry[tintIndex * 36 + spectriteFrame] = ret;
                                this.colourCache.put(itemDamage, (Object)colourCacheEntry);
                            }
                        }
                    }
                }
                return ret;
            }
        }, new Item[]{ModItems.spectrite_orb});
        final HashMap spectriteEntityIndexes = new HashMap();
        EntityList.field_75627_a.entrySet().stream().filter(ee -> ee.getKey() != null && "spectrite".equals(((ResourceLocation)ee.getKey()).func_110624_b())).map(ee -> (ResourceLocation)ee.getKey()).forEach(ee -> spectriteEntityIndexes.put(ee, spectriteEntityIndexes.size()));
        itemColors.func_186730_a(new IItemColor(){
            Map<Integer, int[][]> colourCache = new HashMap<Integer, int[][]>();

            @SideOnly(value=Side.CLIENT)
            public int func_186726_a(ItemStack stack, int tintIndex) {
                int ret = -1;
                ResourceLocation entityRL = ItemMonsterPlacer.func_190908_h((ItemStack)stack);
                if (entityRL != null) {
                    if ("spectrite".equals(entityRL.func_110624_b())) {
                        int[][] entityColourCache;
                        Integer entityCacheIndex = (Integer)spectriteEntityIndexes.get(entityRL);
                        int spectriteFrame = SpectriteHelper.getCurrentSpectriteFrame(null);
                        if (!this.colourCache.containsKey(entityCacheIndex)) {
                            this.colourCache.put(entityCacheIndex, new int[34][36]);
                        }
                        if ((entityColourCache = this.colourCache.get(entityCacheIndex))[tintIndex][spectriteFrame] != 0) {
                            ret = entityColourCache[tintIndex][spectriteFrame];
                        } else {
                            int[][] colours = ItemSpectriteOrb.ORB_COLOUR_RGB;
                            int tintIndex2 = tintIndex % 17;
                            float partSize = 17.0f / (float)(colours.length - 1);
                            float progress = ((float)tintIndex2 / partSize + (float)colours.length / 36.0f * (float)spectriteFrame + (float)(tintIndex > 16 ? 34 : 0) + 36.0f * ((float)entityCacheIndex.intValue() / (float)spectriteEntityIndexes.size())) % (float)colours.length;
                            int startIndex = (int)Math.floor(progress);
                            progress -= (float)startIndex;
                            int[] rgb = new int[3];
                            for (int c = 0; c < 3; ++c) {
                                rgb[c] = Math.round((float)colours[startIndex][c] * (1.0f - progress) + (float)colours[startIndex < colours.length - 1 ? startIndex + 1 : 0][c] * progress);
                            }
                            entityColourCache[tintIndex][spectriteFrame] = ret = new Color(rgb[0], rgb[1], rgb[2]).getRGB();
                        }
                    } else {
                        EntityList.EntityEggInfo entityEggInfo = (EntityList.EntityEggInfo)EntityList.field_75627_a.get(entityRL);
                        ret = entityEggInfo == null ? -1 : (tintIndex == 0 ? entityEggInfo.field_75611_b : entityEggInfo.field_75612_c);
                    }
                }
                return ret;
            }
        }, new Item[]{Items.field_151063_bx});
    }

    @Override
    public void postInit(FMLPostInitializationEvent e) {
        super.postInit(e);
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)this.clientEventHandler);
    }

    @Override
    public void spawnSpectriteSpellParticle(World world, double posX, double posY, double posZ, double r, double g, double b, float offsetLevel) {
        ParticleSpectriteSpell particle = new ParticleSpectriteSpell(world, posX, posY, posZ, r, g, b, offsetLevel);
        SpectriteParticleManager.INSTANCE.addParticle((Particle)particle);
    }

    @Override
    public void spawnSpectriteExplosionParticle(World world, boolean isLarge, double posX, double posY, double posZ, double xSpeed, double ySpeed, double zSpeed) {
        ParticleSpectriteExplosionLarge particle = isLarge ? new ParticleSpectriteExplosionLarge(Minecraft.func_71410_x().func_110434_K(), world, posX, posY, posZ, xSpeed, ySpeed, zSpeed) : new ParticleExplosion.Factory().func_178902_a(EnumParticleTypes.EXPLOSION_NORMAL.func_179348_c(), world, posX, posY, posZ, xSpeed, ySpeed, zSpeed, new int[0]);
        float offsetLevel = 18.0f * (new Double(Math.abs(posX + posZ) + posY).floatValue() % 20.0f);
        float[] c = SpectriteHelper.getCurrentSpectriteRGBColour(offsetLevel);
        particle.func_70538_b(c[0], c[1], c[2]);
        if (isLarge) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
        } else {
            SpectriteParticleManager.INSTANCE.addParticle((Particle)particle);
        }
    }

    @Override
    public void spawnSpectriteExplosionHugeParticle(World world, double posX, double posY, double posZ, double xSpeed, double ySpeed, double zSpeed, double strength) {
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleSpectriteExplosionHuge(world, posX, posY, posZ, strength));
    }

    @Override
    public void spawnSpectriteSmokeNormalParticle(World world, double posX, double posY, double posZ, double xSpeed, double ySpeed, double zSpeed) {
        ParticleSmokeNormal particle = (ParticleSmokeNormal)new ParticleSmokeNormal.Factory().func_178902_a(EnumParticleTypes.SMOKE_NORMAL.func_179348_c(), world, posX, posY, posZ, xSpeed, ySpeed, zSpeed, new int[0]);
        float[] c = SpectriteHelper.getCurrentSpectriteRGBColour(0.0f);
        particle.func_70538_b(c[0], c[1], c[2]);
        SpectriteParticleManager.INSTANCE.addParticle((Particle)particle);
    }

    @Override
    public void spawnSpectriteSmokeLargeParticle(World world, double posX, double posY, double posZ, double xSpeed, double ySpeed, double zSpeed) {
        ParticleSmokeLarge particle = (ParticleSmokeLarge)new ParticleSmokeLarge.Factory().func_178902_a(EnumParticleTypes.SMOKE_LARGE.func_179348_c(), world, posX, posY, posZ, xSpeed, ySpeed, zSpeed, new int[0]);
        float[] c = SpectriteHelper.getCurrentSpectriteRGBColour(0.0f);
        particle.func_70538_b(c[0], c[1], c[2]);
        SpectriteParticleManager.INSTANCE.addParticle((Particle)particle);
    }

    @Override
    public void spawnSpectritePortalParticle(World world, double posX, double posY, double posZ, double xSpeed, double ySpeed, double zSpeed) {
        ParticlePortal particle = (ParticlePortal)new ParticlePortal.Factory().func_178902_a(EnumParticleTypes.PORTAL.func_179348_c(), world, posX, posY, posZ, xSpeed, ySpeed, zSpeed, new int[0]);
        float[] c = SpectriteHelper.getCurrentSpectriteRGBColour(0.0f);
        particle.func_70538_b(c[0], c[1], c[2]);
        SpectriteParticleManager.INSTANCE.addParticle((Particle)particle);
    }
}

