/*
 * Decompiled with CFR 0.152.
 */
package com.samuel.spectrite.packets;

import com.google.common.collect.Lists;
import com.samuel.spectrite.etc.SpectriteExplosion;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSpectriteExplosion
implements IMessage {
    private double posX;
    private double posY;
    private double posZ;
    private float strength;
    private boolean damagesTerrain = false;
    private List<BlockPos> affectedBlockPositions;
    private float motionX;
    private float motionY;
    private float motionZ;

    public PacketSpectriteExplosion() {
    }

    public PacketSpectriteExplosion(double posX, double posY, double posZ, float strength, boolean damagesTerrain, List<BlockPos> affectedBlockPositions, Vec3d motion) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.strength = strength;
        this.damagesTerrain = damagesTerrain;
        this.affectedBlockPositions = affectedBlockPositions;
        if (motion != null) {
            this.motionX = (float)motion.field_72450_a;
            this.motionY = (float)motion.field_72448_b;
            this.motionZ = (float)motion.field_72449_c;
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
        this.strength = buf.readFloat();
        this.damagesTerrain = buf.readBoolean();
        int numAffectedPositions = buf.readInt();
        this.affectedBlockPositions = Lists.newArrayListWithCapacity((int)numAffectedPositions);
        for (int p = 0; p < numAffectedPositions; ++p) {
            this.affectedBlockPositions.add(new PacketBuffer(buf).func_179259_c());
        }
        this.motionX = buf.readFloat();
        this.motionY = buf.readFloat();
        this.motionZ = buf.readFloat();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeFloat(this.strength);
        buf.writeBoolean(this.damagesTerrain);
        int numAffectedPositions = this.affectedBlockPositions.size();
        buf.writeInt(numAffectedPositions);
        for (int p = 0; p < numAffectedPositions; ++p) {
            new PacketBuffer(buf).func_179255_a(this.affectedBlockPositions.get(p));
        }
        buf.writeFloat(this.motionX);
        buf.writeFloat(this.motionY);
        buf.writeFloat(this.motionZ);
    }

    public static class Handler
    implements IMessageHandler<PacketSpectriteExplosion, IMessage> {
        public IMessage onMessage(final PacketSpectriteExplosion message, MessageContext ctx) {
            Minecraft mainThread = Minecraft.func_71410_x();
            mainThread.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    Minecraft minecraft = Minecraft.func_71410_x();
                    SpectriteExplosion explosion = new SpectriteExplosion((World)minecraft.field_71441_e, null, message.posX, message.posY, message.posZ, message.strength, false, message.damagesTerrain, false, message.affectedBlockPositions);
                    explosion.func_77279_a(true);
                    minecraft.field_71439_g.field_70159_w += (double)message.motionX;
                    minecraft.field_71439_g.field_70181_x += (double)message.motionY;
                    minecraft.field_71439_g.field_70179_y += (double)message.motionZ;
                }
            });
            return null;
        }
    }
}

