/*
 * Decompiled with CFR 0.152.
 */
package com.samuel.spectrite.items;

import com.google.common.collect.Multimap;
import com.samuel.spectrite.SpectriteConfig;
import com.samuel.spectrite.entities.EntitySpectriteWitherSkull;
import com.samuel.spectrite.helpers.SpectriteHelper;
import com.samuel.spectrite.items.IPerfectSpectriteItem;
import com.samuel.spectrite.items.ISpectriteCustomTooltipItem;
import com.samuel.spectrite.items.ItemSpectriteSimple;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemSpectriteWitherRod
extends ItemSpectriteSimple
implements IPerfectSpectriteItem,
ISpectriteCustomTooltipItem {
    private final boolean invulnerable;
    private final float attackDamage;
    private final Item.ToolMaterial material;

    public ItemSpectriteWitherRod(Item.ToolMaterial material, boolean invulnerable) {
        this.material = material;
        this.field_77777_bU = 1;
        this.func_77656_e(material.func_77997_a());
        this.attackDamage = 1.0f + material.func_78000_c();
        this.invulnerable = invulnerable;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addTooltipLines(ItemStack stack, List<String> list) {
        int lineCount = 0;
        boolean isLastLine = false;
        double rodCooldown = SpectriteConfig.items.spectriteWitherRodCooldown;
        double weaponCooldown = SpectriteConfig.items.spectriteWeaponCooldown;
        if (SpectriteHelper.isStackSpectriteEnhanced(stack)) {
            rodCooldown *= 0.5;
            weaponCooldown *= 0.5;
        }
        while (!isLastLine) {
            String curLine = I18n.func_74838_a((String)("iteminfo." + this.func_77658_a().substring(5) + ".l" + ++lineCount));
            isLastLine = curLine.endsWith("@");
            if (lineCount % 2 == 1) {
                curLine = curLine.replace("#", String.format("%.2f", lineCount == 1 ? rodCooldown : weaponCooldown));
            }
            list.add(!isLastLine ? curLine : curLine.substring(0, curLine.length() - 1));
        }
        list.set(0, this.getMultiColouredDisplayName(stack, stack.func_82833_r()));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        playerIn.func_184609_a(handIn);
        if (!worldIn.field_72995_K && playerIn.func_184811_cZ().func_185143_a((Item)this, 0.0f) == 0.0f) {
            this.launchWitherSkull(worldIn, (EntityLivingBase)playerIn, this.invulnerable || field_77697_d.nextInt(8) == 0);
            playerIn.func_184586_b(handIn).func_77972_a(1, (EntityLivingBase)playerIn);
            if (!playerIn.func_184812_l_()) {
                boolean isEnhanced = SpectriteHelper.isStackSpectriteEnhanced(playerIn.func_184586_b(handIn));
                playerIn.func_184811_cZ().func_185145_a((Item)this, (int)Math.round(SpectriteConfig.items.spectriteWitherRodCooldown * (double)(isEnhanced ? 10 : 20)));
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    private void launchWitherSkull(World world, EntityLivingBase shooter, boolean invulnerable) {
        world.func_180498_a(null, 1024, new BlockPos((Entity)shooter), 0);
        double d0 = shooter.field_70165_t;
        double d1 = shooter.field_70163_u + (double)shooter.func_70047_e();
        double d2 = shooter.field_70161_v;
        EntitySpectriteWitherSkull entitySpectriteWitherSkull = new EntitySpectriteWitherSkull(world, shooter, 0.0, 0.0, 0.0);
        entitySpectriteWitherSkull.setAim((Entity)shooter, shooter.field_70125_A, shooter.field_70177_z, 2.0f);
        if (invulnerable) {
            entitySpectriteWitherSkull.setInvulnerable(true);
        }
        entitySpectriteWitherSkull.field_70163_u = d1;
        entitySpectriteWitherSkull.field_70165_t = d0;
        entitySpectriteWitherSkull.field_70161_v = d2;
        entitySpectriteWitherSkull.field_70177_z = (entitySpectriteWitherSkull.field_70177_z + 360.0f) % 360.0f - 180.0f;
        world.func_72838_d((Entity)entitySpectriteWitherSkull);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.func_77972_a(2, attacker);
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        if ((double)state.func_185887_b(worldIn, pos) != 0.0) {
            stack.func_77972_a(3, entityLiving);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public int func_77619_b() {
        return this.material.func_77995_e();
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        ItemStack mat = this.material.getRepairItemStack();
        if (!mat.func_190926_b() && OreDictionary.itemMatches((ItemStack)mat, (ItemStack)repair, (boolean)false)) {
            return true;
        }
        return super.func_82789_a(toRepair, repair);
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.attackDamage, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -1.80000007153, 0));
        }
        return multimap;
    }
}

