/*
 * Decompiled with CFR 0.152.
 */
package com.samuel.spectrite.items;

import com.samuel.spectrite.Spectrite;
import com.samuel.spectrite.blocks.BlockSpectriteSkull;
import com.samuel.spectrite.helpers.SpectriteHelper;
import com.samuel.spectrite.init.ModBlocks;
import com.samuel.spectrite.init.ModItems;
import com.samuel.spectrite.init.ModPotions;
import com.samuel.spectrite.items.ISpectriteCustomTooltipItem;
import com.samuel.spectrite.tileentity.TileEntitySpectriteSkull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemSpectriteSkull
extends ItemArmor
implements ISpectriteCustomTooltipItem {
    public static final String[] SKULL_TYPES = new String[]{"wither_skeleton", "wither", "wither_invulnerable"};
    private final int skullType;

    protected ItemSpectriteSkull(int skullType) {
        super(skullType == 0 ? Spectrite.SPECTRITE_WITHER_SKELETON_SKULL : (skullType == 1 ? Spectrite.SPECTRITE_WITHER_SKULL : Spectrite.SPECTRITE_WITHER_INVULNERABLE_SKULL), 4, EntityEquipmentSlot.HEAD);
        this.skullType = skullType;
    }

    public ItemSpectriteSkull() {
        this(0);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack;
        IBlockState iblockstate;
        Block block;
        boolean flag;
        if (facing == EnumFacing.DOWN) {
            return EnumActionResult.FAIL;
        }
        if (worldIn.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos)) {
            facing = EnumFacing.UP;
            pos = pos.func_177977_b();
        }
        if (!(flag = (block = (iblockstate = worldIn.func_180495_p(pos)).func_177230_c()).func_176200_f((IBlockAccess)worldIn, pos))) {
            if (!worldIn.func_180495_p(pos).func_185904_a().func_76220_a() && !worldIn.isSideSolid(pos, facing, true)) {
                return EnumActionResult.FAIL;
            }
            pos = pos.func_177972_a(facing);
        }
        if (player.func_175151_a(pos, facing, itemstack = player.func_184586_b(hand)) && ModBlocks.spectrite_skull.func_176196_c(worldIn, pos)) {
            TileEntity tileentity;
            if (worldIn.field_72995_K) {
                return EnumActionResult.SUCCESS;
            }
            worldIn.func_180501_a(pos, ModBlocks.spectrite_skull.func_176223_P().func_177226_a((IProperty)BlockSpectriteSkull.TYPE, (Comparable)Integer.valueOf(this.skullType)).func_177226_a((IProperty)BlockSpectriteSkull.field_176418_a, (Comparable)facing), 11);
            int i = 0;
            if (facing == EnumFacing.UP) {
                i = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 16.0f / 360.0f) + 0.5)) & 0xF;
            }
            if ((tileentity = worldIn.func_175625_s(pos)) instanceof TileEntitySpectriteSkull) {
                TileEntitySpectriteSkull tileEntitySpectriteWitherSkeletonSkull = (TileEntitySpectriteSkull)tileentity;
                tileEntitySpectriteWitherSkeletonSkull.func_152107_a(this.skullType);
                tileEntitySpectriteWitherSkeletonSkull.setDamage(this.getDamage(itemstack));
                tileEntitySpectriteWitherSkeletonSkull.func_145903_a(i);
                ModBlocks.spectrite_skull.func_180679_a(worldIn, pos, tileEntitySpectriteWitherSkeletonSkull);
            }
            if (player instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, itemstack);
            }
            itemstack.func_190918_g(1);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        String domain = "spectrite";
        int curFrame = SpectriteHelper.getCurrentSpectriteFrame(entity.func_130014_f_());
        return String.format("%s:textures/models/armor/spectrite%s_layer_1/%d.png", domain, "_wither_" + (this == ModItems.spectrite_wither_skeleton_skull ? "skeleton_" : (this == ModItems.spectrite_wither_skull ? "" : "invulnerable_")) + "skull", curFrame);
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public int getSkullType() {
        return this.skullType;
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public String func_77667_c(ItemStack stack) {
        return "item.spectrite_" + SKULL_TYPES[this.skullType] + "_skull";
    }

    public boolean func_179215_a(NBTTagCompound nbt) {
        super.func_179215_a(nbt);
        return false;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (!world.field_72995_K && player.func_70660_b(ModPotions.SPECTRITE_RESISTANCE) == null) {
            player.func_70690_d(new PotionEffect(ModPotions.SPECTRITE_RESISTANCE, 16, 0, true, true));
        }
    }
}

