/*
 * Decompiled with CFR 0.152.
 */
package com.samuel.spectrite.items;

import com.samuel.spectrite.Spectrite;
import com.samuel.spectrite.SpectriteConfig;
import com.samuel.spectrite.etc.ISpectriteTool;
import com.samuel.spectrite.helpers.SpectriteHelper;
import com.samuel.spectrite.init.ModSounds;
import com.samuel.spectrite.items.IPerfectSpectriteItem;
import com.samuel.spectrite.items.ISpectriteCustomTooltipItem;
import com.samuel.spectrite.items.ItemSpectritePickaxeSpecial;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSpectritePickaxe
extends ItemPickaxe
implements ISpectriteTool,
ISpectriteCustomTooltipItem {
    public ItemSpectritePickaxe(Item.ToolMaterial material) {
        super(material);
        this.func_185043_a(new ResourceLocation("time"), Spectrite.ItemPropertyGetterSpectrite);
        this.field_185065_c = -3.0f;
    }

    public ItemSpectritePickaxe() {
        this(Spectrite.SPECTRITE_TOOL);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addTooltipLines(ItemStack stack, List<String> list) {
        int lineCount = 0;
        boolean isLastLine = false;
        double toolCooldown = SpectriteConfig.items.spectriteToolCooldown;
        double weaponCooldown = SpectriteConfig.items.spectriteWeaponCooldown;
        if (SpectriteHelper.isStackSpectriteEnhanced(stack)) {
            toolCooldown *= 0.5;
            weaponCooldown *= 0.5;
        }
        while (!isLastLine) {
            String curLine = I18n.func_74838_a((String)("iteminfo." + this.func_77658_a().substring(5) + ".l" + ++lineCount));
            isLastLine = curLine.endsWith("@");
            if (lineCount % 2 == 1) {
                curLine = curLine.replace("#", String.format("%.2f", lineCount == 1 ? toolCooldown : weaponCooldown));
            }
            list.add(!isLastLine ? curLine : curLine.substring(0, curLine.length() - 1));
        }
        list.set(0, this.getMultiColouredDisplayName(stack, stack.func_82833_r()));
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return state.func_177230_c() instanceof BlockSkull || state.func_177230_c() instanceof BlockBreakable ? this.field_77864_a : super.func_150893_a(stack, state);
    }

    public boolean func_150897_b(IBlockState blockIn) {
        return !(blockIn instanceof BlockSkull) && super.func_150897_b(blockIn);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        Iterator<BlockPos> targetBlocks;
        World worldIn = player.field_70170_p;
        if (player.func_184811_cZ().func_185143_a((Item)this, 0.0f) == 0.0f && !player.func_70093_af() && (targetBlocks = this.getPlayerBreakableBlocks(itemstack, pos, player).iterator()).hasNext()) {
            do {
                NetHandlerPlayClient netHandlerPlayClient;
                boolean removedByPlayer;
                boolean canHarvest;
                BlockPos curPos = targetBlocks.next();
                IBlockState curState = worldIn.func_180495_p(curPos);
                Block curBlock = curState.func_177230_c();
                int exp = !worldIn.field_72995_K ? ForgeHooks.onBlockBreakEvent((World)worldIn, (GameType)((EntityPlayerMP)player).field_71134_c.func_73081_b(), (EntityPlayerMP)((EntityPlayerMP)player), (BlockPos)curPos) : -1;
                boolean bl = canHarvest = !player.func_184812_l_() && ForgeHooks.canHarvestBlock((Block)curBlock, (EntityPlayer)player, (IBlockAccess)worldIn, (BlockPos)curPos) && curBlock.canHarvestBlock((IBlockAccess)worldIn, curPos, player);
                if (player.func_184812_l_()) {
                    curBlock.func_176208_a(worldIn, curPos, curState, player);
                }
                if (removedByPlayer = curBlock.removedByPlayer(curState, worldIn, curPos, player, canHarvest)) {
                    curBlock.func_176206_d(worldIn, curPos, curState);
                }
                itemstack.func_179548_a(worldIn, curState, curPos, player);
                if (!worldIn.field_72995_K) {
                    if (!player.func_184812_l_() && removedByPlayer) {
                        curBlock.func_180657_a(worldIn, player, curPos, curState, worldIn.func_175625_s(curPos), itemstack);
                        if (exp > 0) {
                            curBlock.func_180637_b(worldIn, curPos, exp);
                        }
                    }
                    ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketBlockChange(worldIn, curPos));
                    Spectrite.Proxy.spawnSpectriteExplosionParticle(worldIn, true, (float)curPos.func_177958_n() + 0.5f, (float)curPos.func_177956_o() + 0.5f, (float)curPos.func_177952_p() + 0.5f, 0.0, 0.0, 0.0);
                    continue;
                }
                worldIn.func_175718_b(2001, curPos, Block.func_176210_f((IBlockState)curState));
                if (curBlock.removedByPlayer(curState, worldIn, curPos, player, true)) {
                    curBlock.func_176206_d(worldIn, curPos, curState);
                }
                itemstack.func_179548_a(worldIn, curState, curPos, player);
                if (itemstack.func_190926_b() && itemstack == player.func_184614_ca()) {
                    ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)itemstack, (EnumHand)EnumHand.MAIN_HAND);
                    player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                }
                if ((netHandlerPlayClient = Minecraft.func_71410_x().func_147114_u()) == null) continue;
                netHandlerPlayClient.func_147297_a((Packet)new CPacketPlayerDigging(CPacketPlayerDigging.Action.STOP_DESTROY_BLOCK, curPos, Minecraft.func_71410_x().field_71476_x.field_178784_b));
            } while (targetBlocks.hasNext());
            if (!worldIn.field_72995_K) {
                if (!(this instanceof IPerfectSpectriteItem)) {
                    worldIn.func_184133_a(null, pos, SoundEvents.field_187539_bB, SoundCategory.PLAYERS, 0.75f, 1.0f + worldIn.field_73012_v.nextFloat() * 0.4f);
                } else {
                    worldIn.func_184133_a(null, pos, ModSounds.explosion, SoundCategory.PLAYERS, 0.75f, 1.0f + worldIn.field_73012_v.nextFloat() * 0.4f);
                }
                if (!player.func_184812_l_()) {
                    boolean isEnhanced = SpectriteHelper.isStackSpectriteEnhanced(itemstack);
                    player.func_184811_cZ().func_185145_a((Item)this, (int)Math.round(SpectriteConfig.items.spectriteToolCooldown * (double)(isEnhanced ? 10 : 20)));
                }
            }
        }
        return super.onBlockStartBreak(itemstack, pos, player);
    }

    @Override
    public List<BlockPos> getPlayerBreakableBlocks(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        World worldIn = player.field_70170_p;
        ArrayList<BlockPos> breakableBlocks = new ArrayList<BlockPos>();
        float centerBlockStrVsBlock = this.func_150893_a(itemstack, worldIn.func_180495_p(pos));
        if (centerBlockStrVsBlock > 1.0f) {
            Vec3d lookVec = player.func_70040_Z();
            EnumFacing facing = EnumFacing.func_176737_a((float)((float)lookVec.field_72450_a), (float)((float)lookVec.field_72448_b), (float)((float)lookVec.field_72449_c));
            float relYaw = !worldIn.field_72995_K ? (player.func_70079_am() >= 0.0f ? player.func_70079_am() % 90.0f : 90.0f - Math.abs(player.func_70079_am() % 90.0f)) : player.func_70079_am() % 90.0f + (float)(player.func_70079_am() >= 0.0f ? 0 : 90);
            boolean isDiagonalFacing = relYaw >= 22.5f && relYaw < 67.5f;
            EnumFacing.Axis axis = facing.func_176740_k();
            IBlockState centerState = worldIn.func_180495_p(pos);
            int posX = pos.func_177958_n();
            int posY = pos.func_177956_o();
            int posZ = pos.func_177952_p();
            int blockCount = 0;
            float centerBlockHardness = centerState.func_177230_c().func_180647_a(centerState, player, worldIn, pos);
            if (axis != EnumFacing.Axis.Y && (double)posY < player.field_70163_u) {
                axis = EnumFacing.Axis.Y;
            }
            for (BlockPos curPos : BlockPos.func_177980_a((BlockPos)new BlockPos(axis == EnumFacing.Axis.X ? posX : posX - 1, axis == EnumFacing.Axis.Y ? posY : posY - 1, axis == EnumFacing.Axis.Z ? posZ : posZ - 1), (BlockPos)new BlockPos(axis == EnumFacing.Axis.X ? posX : posX + 1, axis == EnumFacing.Axis.Y ? posY : posY + 1, axis == EnumFacing.Axis.Z ? posZ : posZ + 1))) {
                IBlockState curState = worldIn.func_180495_p(curPos);
                Block curBlock = curState.func_177230_c();
                float curBlockHardness = curBlock.func_180647_a(curState, player, worldIn, curPos);
                if (!(itemstack.func_77973_b() instanceof ItemSpectritePickaxeSpecial) && (isDiagonalFacing && (++blockCount == 2 || blockCount == 4 || blockCount == 6 || blockCount == 8) || !isDiagonalFacing && (blockCount == 1 || blockCount == 3 || blockCount == 7 || blockCount == 9)) || this.func_150893_a(itemstack, curState) < 10.0f || curBlockHardness == -1.0f || centerBlockHardness > curBlockHardness) continue;
                boolean isVisible = false;
                for (EnumFacing side : EnumFacing.values()) {
                    BlockPos offsetPos = curPos.func_177972_a(side);
                    if (!offsetPos.equals((Object)pos) && !worldIn.func_180495_p(curPos.func_177972_a(side)).func_185904_a().equals(Material.field_151579_a) && worldIn.func_180495_p(curPos.func_177972_a(side)).func_185913_b()) continue;
                    isVisible = true;
                    break;
                }
                if (!isVisible) continue;
                breakableBlocks.add(curPos);
            }
        }
        return breakableBlocks;
    }
}

