/*
 * Decompiled with CFR 0.152.
 */
package com.samuel.spectrite.items;

import com.samuel.spectrite.SpectriteConfig;
import com.samuel.spectrite.helpers.SpectriteHelper;
import com.samuel.spectrite.init.ModItems;
import com.samuel.spectrite.init.ModPotions;
import com.samuel.spectrite.items.IPerfectSpectriteItem;
import com.samuel.spectrite.items.ISpectriteCustomTooltipItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSpectriteOrb
extends Item
implements IPerfectSpectriteItem,
ISpectriteCustomTooltipItem {
    public static final int RED = 1;
    public static final int ORANGE = 2;
    public static final int YELLOW = 4;
    public static final int GREEN = 8;
    public static final int BLUE = 16;
    public static final int INDIGO = 32;
    public static final int VIOLET = 64;
    public static final int[] ORB_COLOURS = new int[]{1, 2, 4, 8, 16, 32, 64};
    public static final int[][] ORB_COLOUR_RGB = new int[][]{{255, 0, 0}, {255, 128, 0}, {255, 255, 0}, {0, 255, 0}, {0, 0, 255}, {128, 0, 255}, {188, 0, 255}};
    public static final EntityEquipmentSlot[] ORB_EQUIPMENT_SLOTS = new EntityEquipmentSlot[]{EntityEquipmentSlot.CHEST, EntityEquipmentSlot.FEET, EntityEquipmentSlot.HEAD, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.HEAD};
    public final Potion[] ORB_POTIONS;

    public ItemSpectriteOrb() {
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.ORB_POTIONS = new Potion[]{ModPotions.BERSERK, ModPotions.LIGHTWEIGHT, ModPotions.PROSPERITY, ModPotions.AGILITY, ModPotions.AMPHIBIOUS, ModPotions.ENDURANCE, ModPotions.RESILIENCE};
    }

    public String func_77653_i(ItemStack stack) {
        String displayName = I18n.func_74838_a((String)(this.func_77657_g(stack) + (stack.func_77952_i() == 127 ? "_perfect" : "") + ".name"));
        return displayName;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addTooltipLines(ItemStack stack, List<String> list) {
        int damage = stack.func_77952_i();
        if (damage > 0) {
            int c;
            double cooldown = SpectriteConfig.items.spectriteOrbCooldown * (SpectriteHelper.isStackSpectriteEnhanced(stack) ? 0.5 : 1.0);
            double duration = SpectriteConfig.items.spectriteOrbDuration;
            String name = this.func_77658_a().substring(5);
            String level1 = net.minecraft.client.resources.I18n.func_135052_a((String)("iteminfo." + name + ".effect.level.1"), (Object[])new Object[0]);
            String level2 = net.minecraft.client.resources.I18n.func_135052_a((String)("iteminfo." + name + ".effect.level.2"), (Object[])new Object[0]);
            ArrayList<Integer> colours = new ArrayList<Integer>();
            ArrayList<String> lines = new ArrayList<String>();
            boolean[] armourSlotCompatibility = new boolean[4];
            lines.add(net.minecraft.client.resources.I18n.func_135052_a((String)("iteminfo." + name + ".l1"), (Object[])new Object[0]));
            for (c = 0; c < ORB_COLOURS.length; ++c) {
                if ((damage & ORB_COLOURS[c]) <= 0) continue;
                armourSlotCompatibility[ItemSpectriteOrb.ORB_EQUIPMENT_SLOTS[c].ordinal() - 2] = true;
                colours.add(c);
                lines.add(SpectriteHelper.TEXT_COLORS[c] + " " + net.minecraft.client.resources.I18n.func_135052_a((String)ModItems.spectrite_orb.ORB_POTIONS[c].func_76393_a(), (Object[])new Object[0]) + level1);
            }
            lines.add(net.minecraft.client.resources.I18n.func_135052_a((String)("iteminfo." + name + ".l2"), (Object[])new Object[]{cooldown}));
            for (c = 0; c < colours.size(); ++c) {
                lines.add(SpectriteHelper.TEXT_COLORS[(Integer)colours.get(c)] + " " + net.minecraft.client.resources.I18n.func_135052_a((String)ModItems.spectrite_orb.ORB_POTIONS[(Integer)colours.get(c)].func_76393_a(), (Object[])new Object[0]) + level2 + net.minecraft.client.resources.I18n.func_135052_a((String)("iteminfo." + name + ".effect.duration"), (Object[])new Object[]{duration}));
            }
            for (int s = armourSlotCompatibility.length - 1; s >= 0; --s) {
                if (!armourSlotCompatibility[s]) continue;
                EntityEquipmentSlot compatibleArmourSlot = EntityEquipmentSlot.values()[s + 2];
                String compatibleArmourName = compatibleArmourSlot == EntityEquipmentSlot.HEAD ? ModItems.spectrite_helmet.func_77658_a() : (compatibleArmourSlot == EntityEquipmentSlot.CHEST ? ModItems.spectrite_chestplate.func_77658_a() : (compatibleArmourSlot == EntityEquipmentSlot.LEGS ? ModItems.spectrite_leggings.func_77658_a() : ModItems.spectrite_boots.func_77658_a()));
                compatibleArmourName = SpectriteHelper.getMultiColouredString(net.minecraft.client.resources.I18n.func_135052_a((String)(compatibleArmourName + ".name"), (Object[])new Object[0]), false);
                lines.add(net.minecraft.client.resources.I18n.func_135052_a((String)("iteminfo." + name + ".l3"), (Object[])new Object[]{compatibleArmourName}));
            }
            lines.add(net.minecraft.client.resources.I18n.func_135052_a((String)("iteminfo." + name + ".l4"), (Object[])new Object[0]));
            for (String l : lines) {
                list.add(l);
            }
            list.set(0, SpectriteHelper.getMultiColouredString(stack.func_82833_r(), stack.func_77952_i()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        return this.onEntitySpectriteItemUpdate(entityItem);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        worldIn.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187802_ec, SoundCategory.PLAYERS, 0.5f, field_77697_d.nextFloat() * 0.4f + 1.0f);
        if (playerIn.func_184586_b(hand).func_77952_i() > 0) {
            playerIn.func_184811_cZ().func_185145_a((Item)this, (int)SpectriteConfig.items.spectriteOrbCooldown * 20);
            List<Potion> potionsList = this.getPotions(playerIn.func_184586_b(hand));
            if (potionsList.size() == 7) {
                potionsList.add(ModPotions.SPECTRITE_STRENGTH);
            }
            for (Potion p : potionsList) {
                playerIn.func_184589_d(p);
                playerIn.func_70690_d(new PotionEffect(p, (int)SpectriteConfig.items.spectriteOrbDuration * 20, 1));
            }
        } else {
            playerIn.func_184614_ca().func_77964_b(ORB_COLOURS[worldIn.field_73012_v.nextInt(7)]);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(hand));
    }

    public List<Potion> getPotions(ItemStack stack) {
        ArrayList<Potion> potions = new ArrayList<Potion>();
        int itemDamage = stack.func_77952_i();
        for (int c = 0; c < ORB_COLOURS.length; ++c) {
            if ((itemDamage & ORB_COLOURS[c]) != ORB_COLOURS[c]) continue;
            potions.add(this.ORB_POTIONS[c]);
        }
        return potions;
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            int total = 0;
            for (int t = 0; t < ORB_COLOURS.length; ++t) {
                items.add((Object)new ItemStack((Item)this, 1, ORB_COLOURS[t]));
                total |= ORB_COLOURS[t];
            }
            items.add((Object)new ItemStack((Item)this, 1, total));
        }
    }
}

