/*
 * Decompiled with CFR 0.152.
 */
package com.samuel.spectrite.items;

import com.samuel.spectrite.Spectrite;
import com.samuel.spectrite.SpectriteConfig;
import com.samuel.spectrite.helpers.SpectriteHelper;
import com.samuel.spectrite.init.ModItems;
import com.samuel.spectrite.init.ModPotions;
import com.samuel.spectrite.items.IPerfectSpectriteItem;
import com.samuel.spectrite.items.ISpectriteCustomTooltipItem;
import com.samuel.spectrite.items.ItemSpectriteOrb;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSpectriteArmor
extends ItemArmor
implements IPerfectSpectriteItem,
ISpectriteCustomTooltipItem {
    private final int orbSlots;

    public ItemSpectriteArmor(EntityEquipmentSlot equipmentSlotIn) {
        super(Spectrite.SPECTRITE, 0, equipmentSlotIn);
        this.func_185043_a(new ResourceLocation("time"), Spectrite.ItemPropertyGetterSpectrite);
        this.orbSlots = equipmentSlotIn == EntityEquipmentSlot.HEAD ? 3 : (equipmentSlotIn == EntityEquipmentSlot.CHEST ? 2 : 1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addTooltipLines(ItemStack stack, List<String> list) {
        NBTTagCompound orbEffectsCompound;
        int lineCount = 0;
        int potionStartIndex = list.size() - (SpectriteConfig.items.spectriteArmourBonusMode.ordinal() == 0 ? 1 : 0);
        boolean isLastLine = false;
        while (!isLastLine) {
            String curLine = TextFormatting.RED + I18n.func_74838_a((String)("iteminfo." + this.func_77658_a().substring(5) + (SpectriteHelper.isStackSpectriteEnhanced(stack) ? "_enhanced" : "") + "." + SpectriteConfig.items.spectriteArmourBonusMode.ordinal() + ".l" + ++lineCount));
            isLastLine = curLine.endsWith("@");
            list.add(!isLastLine ? curLine : curLine.substring(0, curLine.length() - 1));
        }
        if (stack.func_77942_o() && (orbEffectsCompound = stack.func_179543_a("OrbEffects")) != null) {
            int potionEffectsCount = 0;
            for (String o : orbEffectsCompound.func_150296_c()) {
                if (!orbEffectsCompound.func_74767_n(o)) continue;
                int c = Integer.parseInt(o);
                list.add(potionStartIndex + ++potionEffectsCount, SpectriteHelper.TEXT_COLORS[c] + " " + I18n.func_74838_a((String)ModItems.spectrite_orb.ORB_POTIONS[c].func_76393_a()) + I18n.func_74838_a((String)("iteminfo." + ModItems.spectrite_orb.func_77658_a().substring(5) + ".effect.level.1")));
            }
        }
        list.set(0, this.getMultiColouredDisplayName(stack, stack.func_82833_r()));
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.field_77351_y.func_77557_a(stack.func_77973_b());
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        String domain = "spectrite";
        int curFrame = SpectriteHelper.getCurrentSpectriteFrame(entity.func_130014_f_());
        return String.format("%s:textures/models/armor/spectrite_layer_%d/%d.png", domain, slot == EntityEquipmentSlot.LEGS ? 2 : 1, curFrame);
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        return this.onEntitySpectriteItemUpdate(entityItem);
    }

    public boolean func_179215_a(NBTTagCompound nbt) {
        if (!nbt.func_74764_b("OrbEffects")) {
            NBTTagCompound orbEffectsCompound = new NBTTagCompound();
            for (int c = 0; c < ItemSpectriteOrb.ORB_COLOURS.length; ++c) {
                if (ItemSpectriteOrb.ORB_EQUIPMENT_SLOTS[c] != this.field_77881_a) continue;
                orbEffectsCompound.func_74757_a(new Integer(c).toString(), false);
            }
            nbt.func_74782_a("OrbEffects", (NBTBase)orbEffectsCompound);
        }
        return true;
    }

    public int getNumOrbSlots() {
        return this.orbSlots;
    }

    public List<Potion> getPotions(ItemStack stack) {
        ArrayList<Potion> potions = new ArrayList<Potion>();
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        this.func_179215_a(stack.func_77978_p());
        NBTTagCompound tagCompound = stack.func_179543_a("OrbEffects");
        int[] orbColours = ItemSpectriteOrb.ORB_COLOURS;
        for (int c = 0; c < orbColours.length; ++c) {
            String key = new Integer(c).toString();
            if (!tagCompound.func_74764_b(key) || !tagCompound.func_74767_n(key)) continue;
            potions.add(ModItems.spectrite_orb.ORB_POTIONS[c]);
        }
        return potions;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (!world.field_72995_K) {
            float healthIncrease = 0.0f;
            int armourCount = 0;
            int enhancedCount = 0;
            int spectriteResistanceLevel = 0;
            for (ItemStack stack : player.func_184193_aE()) {
                if (stack == null || !(stack.func_77973_b() instanceof ItemSpectriteArmor)) continue;
                float armourHealthIncrease = ((ItemSpectriteArmor)stack.func_77973_b()).getHealthIncreaseValue(false);
                ++armourCount;
                if (SpectriteHelper.isStackSpectriteEnhanced(stack)) {
                    ++enhancedCount;
                    armourHealthIncrease *= 2.0f;
                }
                healthIncrease += armourHealthIncrease;
            }
            if (healthIncrease > 0.0f) {
                boolean allEnhanced;
                SpectriteConfig.EnumSpectriteArmourBonusMode spectriteArmourBonusMode = SpectriteConfig.items.spectriteArmourBonusMode;
                boolean bl = allEnhanced = enhancedCount == 4;
                if (player.func_110138_aP() - 20.0f != healthIncrease) {
                    player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(20.0f + healthIncrease));
                }
                if (armourCount == 4 && player.func_71024_bL().func_75116_a() > 0) {
                    if (spectriteArmourBonusMode.ordinal() > 2) {
                        if (player.func_70660_b(MobEffects.field_76424_c) == null) {
                            player.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 220, SpectriteConfig.items.spectriteArmourBonusMode.ordinal() - (!allEnhanced ? 3 : 2), true, true));
                        }
                        if (player.func_70660_b(MobEffects.field_76420_g) == null) {
                            player.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 220, SpectriteConfig.items.spectriteArmourBonusMode.ordinal() - (!allEnhanced ? 3 : 2), true, true));
                        }
                        if (player.func_70660_b(MobEffects.field_76429_m) == null) {
                            player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 220, SpectriteConfig.items.spectriteArmourBonusMode.ordinal() - (!allEnhanced ? 3 : 2), true, true));
                        }
                        if (player.func_70660_b(MobEffects.field_76426_n) == null) {
                            player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 220, SpectriteConfig.items.spectriteArmourBonusMode.ordinal() - (!allEnhanced ? 3 : 2), true, true));
                        }
                        ++spectriteResistanceLevel;
                    }
                    if (allEnhanced) {
                        ++spectriteResistanceLevel;
                    }
                    if (player.func_70660_b(ModPotions.SPECTRITE_RESISTANCE) == null) {
                        player.func_70690_d(new PotionEffect(ModPotions.SPECTRITE_RESISTANCE, 16, spectriteResistanceLevel, true, true));
                    }
                }
            }
        }
    }

    public float getHealthIncreaseValue(boolean ignoreConfig) {
        float healthIncreaseValue = this.field_77881_a == EntityEquipmentSlot.HEAD ? 4.0f : (this.field_77881_a == EntityEquipmentSlot.CHEST ? 8.0f : (this.field_77881_a == EntityEquipmentSlot.LEGS ? 6.0f : 2.0f));
        if (!ignoreConfig) {
            healthIncreaseValue *= SpectriteConfig.items.spectriteArmourBonusMode.getHealthIncreaseMultiplier();
        }
        return healthIncreaseValue;
    }
}

