/*
 * Decompiled with CFR 0.152.
 */
package com.samuel.spectrite.init;

import com.samuel.spectrite.Spectrite;
import com.samuel.spectrite.entities.EntitySpectriteAreaEffectCloud;
import com.samuel.spectrite.entities.EntitySpectriteArrow;
import com.samuel.spectrite.entities.EntitySpectriteBlaze;
import com.samuel.spectrite.entities.EntitySpectriteCreeper;
import com.samuel.spectrite.entities.EntitySpectriteCrystal;
import com.samuel.spectrite.entities.EntitySpectriteEnderman;
import com.samuel.spectrite.entities.EntitySpectriteGolem;
import com.samuel.spectrite.entities.EntitySpectriteSkeleton;
import com.samuel.spectrite.entities.EntitySpectriteTippedArrow;
import com.samuel.spectrite.entities.EntitySpectriteWither;
import com.samuel.spectrite.entities.EntitySpectriteWitherSkeleton;
import com.samuel.spectrite.entities.EntitySpectriteWitherSkull;
import com.samuel.spectrite.helpers.SpectriteHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModEntities {
    private static int entityID = 0;
    private static Map<String, IForgeRegistryEntry> registeredEntities = new HashMap<String, IForgeRegistryEntry>();

    public static void initEntities(Spectrite mod) {
        ModEntities.registerEntity("SpectriteArrow", EntitySpectriteArrow.class, mod, false);
        ModEntities.registerEntity("SpectriteGolem", EntitySpectriteGolem.class, mod, true);
        ModEntities.registerEntity("SpectriteCreeper", EntitySpectriteCreeper.class, mod, true);
        ModEntities.registerEntity("SpectriteSkeleton", EntitySpectriteSkeleton.class, mod, true);
        ModEntities.registerEntity("SpectriteWitherSkeleton", EntitySpectriteWitherSkeleton.class, mod, true);
        ModEntities.registerEntity("SpectriteBlaze", EntitySpectriteBlaze.class, mod, true);
        ModEntities.registerEntity("SpectriteEnderman", EntitySpectriteEnderman.class, mod, true);
        ModEntities.registerEntity("SpectriteWither", EntitySpectriteWither.class, mod, false);
        ModEntities.registerEntity("SpectriteWitherSkull", EntitySpectriteWitherSkull.class, mod, false);
        ModEntities.registerEntity("SpectriteAreaEffectCloud", EntitySpectriteAreaEffectCloud.class, mod, false);
        ModEntities.registerEntity("SpectriteTippedArrow", EntitySpectriteTippedArrow.class, mod, false);
        ModEntities.registerEntity("SpectriteCrystal", EntitySpectriteCrystal.class, mod, false);
    }

    @SubscribeEvent
    public void onMissingMapping(RegistryEvent.MissingMappings<EntityEntry> e) {
        for (RegistryEvent.MissingMappings.Mapping mapping : e.getAllMappings()) {
            String resourcePath;
            if (!"spectritemod".equals(mapping.key.func_110624_b()) || !registeredEntities.containsKey(resourcePath = mapping.key.func_110623_a())) continue;
            mapping.remap((IForgeRegistryEntry)((EntityEntry)registeredEntities.get(resourcePath)));
        }
    }

    private static void registerEntity(String name, Class<? extends Entity> clazz, Spectrite mod, boolean addSpawnEgg) {
        ResourceLocation location = new ResourceLocation(String.format("%s:%s", "spectrite", name));
        if (addSpawnEgg) {
            EntityRegistry.registerModEntity((ResourceLocation)location, clazz, (String)name, (int)entityID++, (Object)mod, (int)128, (int)1, (boolean)true, (int)0, (int)0);
        } else {
            EntityRegistry.registerModEntity((ResourceLocation)location, clazz, (String)name, (int)entityID++, (Object)mod, (int)128, (int)1, (boolean)true);
        }
        SpectriteHelper.populateRegisteredObjectsList(registeredEntities, ForgeRegistries.ENTITIES.getValue(location));
    }
}

