/*
 * Decompiled with CFR 0.152.
 */
package com.samuel.spectrite.init;

import com.google.common.base.Predicate;
import com.samuel.spectrite.enchantments.EnchantmentSpectriteEnhance;
import com.samuel.spectrite.helpers.SpectriteHelper;
import com.samuel.spectrite.items.IPerfectSpectriteItem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModEnchantments {
    public static EnumEnchantmentType PERFECT_SPECTRITE = EnumHelper.addEnchantmentType((String)"perfect_spectrite", (Predicate)new Predicate<Item>(){

        public boolean apply(Item item) {
            return item instanceof IPerfectSpectriteItem;
        }
    });
    public static EnchantmentSpectriteEnhance spectrite_enhance;
    private static Map<String, IForgeRegistryEntry> registeredEnchantments;

    public static void initEnchantments() {
        spectrite_enhance = new EnchantmentSpectriteEnhance(Enchantment.Rarity.VERY_RARE, PERFECT_SPECTRITE, new EntityEquipmentSlot[]{EntityEquipmentSlot.CHEST, EntityEquipmentSlot.FEET, EntityEquipmentSlot.HEAD, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.MAINHAND, EntityEquipmentSlot.OFFHAND});
        spectrite_enhance.setRegistryName("spectrite", "spectrite_enhance");
        SpectriteHelper.populateRegisteredObjectsList(registeredEnchantments, new IForgeRegistryEntry[]{spectrite_enhance});
    }

    @SubscribeEvent
    public void onRegisterEnchantments(RegistryEvent.Register<Enchantment> event) {
        event.getRegistry().register((IForgeRegistryEntry)spectrite_enhance);
    }

    @SubscribeEvent
    public void onMissingMapping(RegistryEvent.MissingMappings<Enchantment> e) {
        for (RegistryEvent.MissingMappings.Mapping mapping : e.getAllMappings()) {
            String resourcePath;
            if (!"spectritemod".equals(mapping.key.func_110624_b()) || !registeredEnchantments.containsKey(resourcePath = mapping.key.func_110623_a())) continue;
            mapping.remap((IForgeRegistryEntry)((Enchantment)registeredEnchantments.get(resourcePath)));
        }
    }

    static {
        registeredEnchantments = new HashMap<String, IForgeRegistryEntry>();
    }
}

