/*
 * Decompiled with CFR 0.152.
 */
package com.samuel.spectrite.helpers;

import com.samuel.spectrite.SpectriteConfig;
import com.samuel.spectrite.entities.EntitySpectriteBlaze;
import com.samuel.spectrite.entities.EntitySpectriteCreeper;
import com.samuel.spectrite.entities.EntitySpectriteCrystal;
import com.samuel.spectrite.entities.EntitySpectriteEnderman;
import com.samuel.spectrite.entities.EntitySpectriteGolem;
import com.samuel.spectrite.entities.EntitySpectriteSkeleton;
import com.samuel.spectrite.entities.EntitySpectriteWitherSkeleton;
import com.samuel.spectrite.entities.ISpectriteMob;
import com.samuel.spectrite.init.ModEnchantments;
import com.samuel.spectrite.init.ModItems;
import com.samuel.spectrite.init.ModPotions;
import com.samuel.spectrite.items.IPerfectSpectriteItem;
import com.samuel.spectrite.items.ItemSpectriteBow;
import com.samuel.spectrite.items.ItemSpectriteBowSpecial;
import com.samuel.spectrite.items.ItemSpectriteOrb;
import com.samuel.spectrite.items.ItemSpectriteShield;
import com.samuel.spectrite.items.ItemSpectriteShieldSpecial;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.block.material.MapColor;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SpectriteHelper {
    public static final TextFormatting[] TEXT_COLORS = new TextFormatting[]{TextFormatting.RED, TextFormatting.GOLD, TextFormatting.YELLOW, TextFormatting.GREEN, TextFormatting.BLUE, TextFormatting.DARK_PURPLE, TextFormatting.LIGHT_PURPLE};
    private static final MapColor[] MAP_COLORS = new MapColor[]{MapColor.field_151645_D, MapColor.field_193562_N, MapColor.field_151673_t, MapColor.field_151672_u, MapColor.field_151649_A, MapColor.field_151678_z, MapColor.field_151671_v};
    private static final HashMap<Integer, Integer[]> ORB_TEXT_COLOUR_INDEXES_CACHE = new HashMap();
    private static final Map<World, Set<WeakReference<EntitySpectriteCrystal>>> SPECTRITE_CRYSTALS_CACHE = new WeakHashMap<World, Set<WeakReference<EntitySpectriteCrystal>>>();

    public static int getCurrentSpectriteFrame(World worldIn) {
        if (worldIn == null) {
            return Math.round((System.currentTimeMillis() >> 6) % 36L);
        }
        float time = (float)MathHelper.func_76123_f((float)((float)((worldIn.func_82737_E() >> 1) % 36L) * 0.2777f * 1000.0f)) / 10000.0f;
        return Math.round(time * 36.0f);
    }

    public static float[] getCurrentSpectriteRGBColour(float offsetLevel) {
        float b;
        float g;
        float r;
        int hueFrame = Math.round((System.currentTimeMillis() >> 5) % 180L);
        if (offsetLevel >= 0.0f) {
            hueFrame = (hueFrame + (int)offsetLevel) % 180;
        }
        float f = hueFrame >= 120 && hueFrame < 150 ? 0.033333335f * (float)(hueFrame - 120) : (hueFrame < 30 || hueFrame >= 150 ? 1.0f : (r = hueFrame < 60 ? 0.033333335f * (float)(30 - (hueFrame - 30)) : 0.0f));
        float f2 = hueFrame < 30 ? 0.033333335f * (float)hueFrame : (hueFrame < 90 ? 1.0f : (g = hueFrame < 120 ? 0.033333335f * (float)(30 - (hueFrame - 90)) : 0.0f));
        float f3 = hueFrame >= 60 && hueFrame < 90 ? 0.033333335f * (float)(hueFrame - 60) : (hueFrame >= 90 && hueFrame < 150 ? 1.0f : (b = hueFrame >= 150 ? 0.033333335f * (float)(30 - (hueFrame - 150)) : 0.0f));
        if (offsetLevel < 0.0f) {
            r = 1.0f - r;
            g = 1.0f - g;
            b = 1.0f - b;
        }
        return new float[]{r, g, b};
    }

    public static int getCurrentSpectriteColour(int offsetLevel) {
        int hueFrame = Math.round((System.currentTimeMillis() >> 5) % 180L);
        int r = MathHelper.func_76141_d((float)(hueFrame >= 120 && hueFrame < 150 ? 8.5f * (float)(hueFrame - 120) : (hueFrame < 30 || hueFrame >= 150 ? 255.0f : (hueFrame < 60 ? 8.5f * (float)(30 - (hueFrame - 30)) : 0.0f))));
        int g = MathHelper.func_76141_d((float)(hueFrame < 30 ? 8.5f * (float)hueFrame : (hueFrame < 90 ? 255.0f : (hueFrame < 120 ? 8.5f * (float)(30 - (hueFrame - 90)) : 0.0f))));
        int b = MathHelper.func_76141_d((float)(hueFrame >= 60 && hueFrame < 90 ? 8.5f * (float)(hueFrame - 60) : (hueFrame >= 90 && hueFrame < 150 ? 255.0f : (hueFrame >= 150 ? 8.5f * (float)(30 - (hueFrame - 150)) : 0.0f))));
        int tempR = r;
        switch (offsetLevel) {
            case 1: {
                r = g;
                g = b;
                b = tempR;
                break;
            }
            case 2: {
                int tempG = g;
                r = b;
                g = tempR;
                b = tempG;
                break;
            }
        }
        return (r << 16) + (g << 8) + b + 0;
    }

    public static String getMultiColouredString(String text, boolean rotateTextColour) {
        StringBuilder formattedText = new StringBuilder();
        int textColourCount = TEXT_COLORS.length;
        int colourIndex = rotateTextColour ? Math.round((System.currentTimeMillis() >> 7) % 7L) : 0;
        for (int c = 0; c < text.length(); ++c) {
            formattedText.append(TEXT_COLORS[(c + colourIndex) % textColourCount]).append(String.valueOf(text.charAt(c)));
        }
        return formattedText.toString();
    }

    public static String getMultiColouredString(String text, int orbDamage) {
        if (orbDamage < 127) {
            StringBuilder formattedText = new StringBuilder();
            if (orbDamage > 0) {
                Integer[] textColourIndexes;
                if (ORB_TEXT_COLOUR_INDEXES_CACHE.containsKey(orbDamage)) {
                    textColourIndexes = ORB_TEXT_COLOUR_INDEXES_CACHE.get(orbDamage);
                } else {
                    ArrayList<Integer> textColourIndexesList = new ArrayList<Integer>();
                    int[] orbColours = ItemSpectriteOrb.ORB_COLOURS;
                    for (int c = 0; c < orbColours.length; ++c) {
                        if ((orbDamage & orbColours[c]) != orbColours[c]) continue;
                        textColourIndexesList.add(c);
                    }
                    textColourIndexes = textColourIndexesList.toArray(new Integer[0]);
                    ORB_TEXT_COLOUR_INDEXES_CACHE.put(orbDamage, textColourIndexes);
                }
                int textColourCount = textColourIndexes.length;
                for (int c = 0; c < text.length(); ++c) {
                    formattedText.append(TEXT_COLORS[textColourIndexes[c % textColourCount]]).append(String.valueOf(text.charAt(c)));
                }
            } else {
                formattedText.append(text);
            }
            return formattedText.toString();
        }
        return SpectriteHelper.getMultiColouredString(text, true);
    }

    public static MapColor getSpectriteMapColour(World worldIn, BlockPos pos) {
        int posOffset = pos.func_177958_n() + pos.func_177956_o() + pos.func_177952_p();
        return MAP_COLORS[(posOffset + (int)(worldIn.func_72820_D() >> 2)) % 7];
    }

    public static boolean isStackSpectriteEnhanced(ItemStack stack) {
        boolean ret = false;
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof IPerfectSpectriteItem) {
            NBTTagList enchantmentTags = stack.func_77986_q();
            for (int ec = 0; ec < enchantmentTags.func_74745_c(); ++ec) {
                if (enchantmentTags.func_150305_b(ec).func_74765_d("id") != Enchantment.func_185258_b((Enchantment)ModEnchantments.spectrite_enhance)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    public static int getPlayerReceivedSpectriteDamageDecreaseForDifficulty(EnumDifficulty difficulty) {
        return 3 - difficulty.ordinal();
    }

    public static int getSpectriteDamageAmplifierAfterStrength(int amplifier, @Nullable Entity attacker) {
        PotionEffect strengthEffect = attacker != null && attacker instanceof EntityLivingBase ? ((EntityLivingBase)attacker).func_70660_b(ModPotions.SPECTRITE_STRENGTH) : null;
        int strengthLevel = strengthEffect == null ? -1 : strengthEffect.func_76458_c();
        return amplifier + (strengthLevel + 1);
    }

    public static int getSpectriteDamageAmplifierAfterResistance(int amplifier, EntityLivingBase target) {
        PotionEffect resistanceEffect = target.func_70660_b(ModPotions.SPECTRITE_RESISTANCE);
        int resistanceLevel = resistanceEffect == null ? -1 : resistanceEffect.func_76458_c();
        return amplifier - (resistanceLevel + 1);
    }

    public static boolean canBlockDamageSource(EntityPlayer player, DamageSource damageSourceIn) {
        Vec3d vec3d;
        if (!damageSourceIn.func_76363_c() && player.func_184585_cz() && (vec3d = damageSourceIn.func_188404_v()) != null) {
            Vec3d vec3d1 = player.func_70676_i(1.0f);
            Vec3d vec3d2 = vec3d.func_72444_a(new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v)).func_72432_b();
            vec3d2 = new Vec3d(vec3d2.field_72450_a, 0.0, vec3d2.field_72449_c);
            if (vec3d2.func_72430_b(vec3d1) < 0.0) {
                return true;
            }
        }
        return false;
    }

    public static void damageBow(EntityLivingBase entity, ItemStack arrowStack, PotionType potionType) {
        ItemStack bowStack = entity.func_184607_cu();
        if (!bowStack.func_190926_b() && bowStack.func_77973_b() instanceof ItemBow) {
            ItemBow bowItem = (ItemBow)bowStack.func_77973_b();
            int bowDamage = -1;
            if (potionType != null && !potionType.func_185170_a().isEmpty()) {
                for (PotionEffect pe : potionType.func_185170_a()) {
                    Potion potion = pe.func_188419_a();
                    if (potion != ModPotions.SPECTRITE_DAMAGE && potion != ModPotions.SPECTRITE_STRENGTH && potion != ModPotions.SPECTRITE_RESISTANCE && potion != ModPotions.SPECTRITE) continue;
                    bowDamage += 5 << pe.func_76458_c() + 1;
                }
            } else {
                int n = bowDamage = arrowStack.func_77973_b() == ModItems.spectrite_arrow_special ? 100 : 33;
            }
            if (bowItem instanceof ItemSpectriteBow) {
                bowDamage = !(bowItem instanceof ItemSpectriteBowSpecial) ? (int)((double)bowDamage * 0.1) : (int)((double)bowDamage * 0.033);
            }
            bowDamage = new Float(bowDamage).intValue();
            entity.func_184607_cu().func_77972_a(bowDamage, entity);
        }
    }

    public static void damageShield(EntityPlayer player, float damage) {
        ItemStack activeItemStack = player.func_184607_cu();
        if (damage >= 3.0f) {
            int i = 1 + MathHelper.func_76141_d((float)damage);
            activeItemStack.func_77972_a(i, (EntityLivingBase)player);
            if (player.func_184607_cu().func_190926_b()) {
                EnumHand enumhand = player.func_184600_cs();
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)activeItemStack, (EnumHand)enumhand);
                if (enumhand == EnumHand.MAIN_HAND) {
                    player.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                } else {
                    player.func_184201_a(EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
                }
                player.func_184602_cy();
                player.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + player.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            }
        }
    }

    public static int getSpectriteShieldTier(ItemStack shieldStack) {
        Item item = shieldStack.func_77973_b();
        return item instanceof ItemSpectriteShieldSpecial ? (SpectriteHelper.isStackSpectriteEnhanced(shieldStack) ? 3 : 2) : (item instanceof ItemSpectriteShield ? 1 : 0);
    }

    public static void populateRegisteredObjectsList(Map<String, IForgeRegistryEntry> registeredObjects, IForgeRegistryEntry ... objects) {
        for (IForgeRegistryEntry o : objects) {
            registeredObjects.put(o.getRegistryName().func_110623_a(), o);
        }
    }

    public static boolean isSpectriteReplaceableMob(EntityLivingBase entity) {
        if (entity.func_184222_aU() && !(entity instanceof ISpectriteMob)) {
            boolean isDirectReplacement;
            if (entity instanceof EntitySpider || entity instanceof EntitySlime || entity instanceof EntityGuardian) {
                return false;
            }
            boolean bl = isDirectReplacement = entity instanceof AbstractSkeleton || entity instanceof EntityCreeper || entity instanceof EntityBlaze || entity instanceof EntityEnderman || entity instanceof EntityIronGolem;
            if (entity.field_70131_O >= 0.6f && ((double)entity.func_110138_aP() < 100.0 || entity instanceof EntityIronGolem && !((EntityIronGolem)entity).func_70850_q())) {
                return isDirectReplacement || entity instanceof IMob;
            }
        }
        return false;
    }

    public static EntityLiving getSpectriteReplacementEntity(EntityLivingBase entity) {
        World world = entity.func_130014_f_();
        Class<?> spectriteClass = entity.getClass();
        Class vanillaClass = null;
        EntityLiving spectriteEntity = null;
        if (EntityCreeper.class.isAssignableFrom(spectriteClass)) {
            vanillaClass = EntityCreeper.class;
        } else if (EntityBlaze.class.isAssignableFrom(spectriteClass)) {
            vanillaClass = EntityBlaze.class;
        } else if (EntityEnderman.class.isAssignableFrom(spectriteClass)) {
            vanillaClass = EntityEnderman.class;
        } else if (EntityIronGolem.class.isAssignableFrom(spectriteClass)) {
            vanillaClass = EntityIronGolem.class;
        } else {
            switch (spectriteClass.getSimpleName()) {
                case "EntityBasalz": 
                case "EntityBlitz": 
                case "EntityBlizz": {
                    vanillaClass = EntityBlaze.class;
                }
            }
            if (vanillaClass == null && entity.field_70131_O >= entity.field_70130_N * 1.5f) {
                vanillaClass = EntityWitherSkeleton.class.isAssignableFrom(spectriteClass) || EntitySkeleton.class != spectriteClass && world.field_73011_w.getDimension() == -1 ? EntityWitherSkeleton.class : EntitySkeleton.class;
            }
        }
        if (vanillaClass != null) {
            spectriteEntity = SpectriteHelper.getSpectriteReplacementEntity(world, vanillaClass);
        }
        return spectriteEntity;
    }

    public static EntityLiving getSpectriteReplacementEntity(World world, Class<? extends EntityLivingBase> clazz) {
        ISpectriteMob spectriteEntity = null;
        if (EntitySkeleton.class == clazz) {
            spectriteEntity = new EntitySpectriteSkeleton(world);
        } else if (EntityCreeper.class == clazz) {
            spectriteEntity = new EntitySpectriteCreeper(world);
        } else if (EntityWitherSkeleton.class == clazz) {
            spectriteEntity = new EntitySpectriteWitherSkeleton(world);
        } else if (EntityEnderman.class == clazz) {
            spectriteEntity = new EntitySpectriteEnderman(world);
        } else if (EntityBlaze.class == clazz) {
            spectriteEntity = new EntitySpectriteBlaze(world);
        } else if (EntityIronGolem.class == clazz) {
            spectriteEntity = new EntitySpectriteGolem(world);
        }
        return spectriteEntity;
    }

    public static void addCrystalToCache(World world, EntitySpectriteCrystal crystal) {
        if (!SPECTRITE_CRYSTALS_CACHE.containsKey(world)) {
            SPECTRITE_CRYSTALS_CACHE.put(world, new HashSet());
        }
        SPECTRITE_CRYSTALS_CACHE.get(world).add(new WeakReference<EntitySpectriteCrystal>(crystal));
    }

    public static boolean isCrystalInRange(World world, BlockPos pos) {
        Set<WeakReference<EntitySpectriteCrystal>> worldCrystals = SPECTRITE_CRYSTALS_CACHE.get(world);
        if (worldCrystals != null) {
            Iterator<WeakReference<EntitySpectriteCrystal>> worldCrystalsIterator = worldCrystals.iterator();
            while (worldCrystalsIterator.hasNext()) {
                EntitySpectriteCrystal crystal = (EntitySpectriteCrystal)((Object)worldCrystalsIterator.next().get());
                if (crystal == null) {
                    worldCrystalsIterator.remove();
                    continue;
                }
                if (crystal.field_70128_L || !(crystal.func_180425_c().func_185332_f(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) <= (double)SpectriteConfig.blocks.spectriteCrystalEffectRange)) continue;
                return true;
            }
        }
        return false;
    }
}

