/*
 * Decompiled with CFR 0.152.
 */
package com.samuel.spectrite.eventhandlers;

import com.samuel.spectrite.Spectrite;
import com.samuel.spectrite.SpectriteConfig;
import com.samuel.spectrite.blocks.BlockSpectrite;
import com.samuel.spectrite.damagesources.DamageSourceSpectriteIndirectPlayer;
import com.samuel.spectrite.entities.EntitySpectriteAreaEffectCloud;
import com.samuel.spectrite.entities.EntitySpectriteArrow;
import com.samuel.spectrite.entities.EntitySpectriteCrystal;
import com.samuel.spectrite.entities.EntitySpectriteEnderman;
import com.samuel.spectrite.entities.EntitySpectriteGolem;
import com.samuel.spectrite.entities.EntitySpectriteTippedArrow;
import com.samuel.spectrite.entities.ISpectriteBipedMob;
import com.samuel.spectrite.entities.ISpectriteMob;
import com.samuel.spectrite.etc.ISpectriteTool;
import com.samuel.spectrite.helpers.SpectriteHelper;
import com.samuel.spectrite.init.ModBlocks;
import com.samuel.spectrite.init.ModItems;
import com.samuel.spectrite.init.ModPotions;
import com.samuel.spectrite.init.ModWorldGen;
import com.samuel.spectrite.items.IPerfectSpectriteItem;
import com.samuel.spectrite.items.ItemSpectriteArmor;
import com.samuel.spectrite.items.ItemSpectriteArrow;
import com.samuel.spectrite.items.ItemSpectriteBow;
import com.samuel.spectrite.items.ItemSpectriteLegendBlade;
import com.samuel.spectrite.items.ItemSpectriteShield;
import com.samuel.spectrite.items.ItemSpectriteSkull;
import com.samuel.spectrite.items.ItemSpectriteSword;
import com.samuel.spectrite.items.ItemSpectriteWitherRod;
import com.samuel.spectrite.packets.PacketSyncSpectriteDungeonSpawnPos;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTippedArrow;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SpectriteGeneralEventHandler {
    private static boolean skipAttackPlayer = false;
    private static Field healthField = null;
    private static Field immuneToFireField = null;
    private static Field potionField_tippedArrow = null;
    private static Field potionField_areaEffectCloud = null;
    private static Method getArrowStackMethod = null;
    private static Field primaryEffectField = null;
    private static Field secondaryEffectField = null;
    private static Field paymentField = null;
    private static Field customNameField = null;
    private static Field potionEffectDurationField = null;
    private static Map<UUID, Map<Tuple<ResourceLocation, Integer>, Tuple<Integer, Long>>> entityBadPotionEffectsMap = new HashMap<UUID, Map<Tuple<ResourceLocation, Integer>, Tuple<Integer, Long>>>();

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onEntitySpawn(EntityJoinWorldEvent e) {
        if (!e.getWorld().field_72995_K) {
            if (e.getEntity() instanceof EntityLiving) {
                EntityLiving spectriteEntity;
                boolean isCrystalInRange;
                EntityLivingBase entity = (EntityLivingBase)e.getEntity();
                boolean isSpectriteReplaceable = SpectriteHelper.isSpectriteReplaceableMob(entity);
                if (isSpectriteReplaceable && (!(isCrystalInRange = SpectriteHelper.isCrystalInRange(e.getWorld(), entity.func_180425_c())) && SpectriteConfig.mobs.spectriteMobSpawnRate > 0.0 && (double)((int)entity.func_110124_au().getLeastSignificantBits()) % (100.0 / SpectriteConfig.mobs.spectriteMobSpawnRate) == 0.0 || isCrystalInRange && SpectriteConfig.mobs.spectriteMobCrystalSpawnRate > 0.0 && (double)((int)entity.func_110124_au().getLeastSignificantBits()) % (100.0 / SpectriteConfig.mobs.spectriteMobCrystalSpawnRate) == 0.0) && (spectriteEntity = SpectriteHelper.getSpectriteReplacementEntity(entity)) != null) {
                    e.setCanceled(true);
                    spectriteEntity.func_70012_b(entity.field_70142_S, entity.field_70137_T, entity.field_70136_U, entity.field_70177_z, entity.field_70125_A);
                    e.getWorld().func_72838_d((Entity)spectriteEntity);
                    spectriteEntity.func_180482_a(e.getWorld().func_175649_E(entity.func_180425_c()), null);
                }
            } else if (e.getEntity() instanceof EntityItem) {
                EntityItem entityItem = (EntityItem)e.getEntity();
                if (!entityItem.func_92059_d().func_190926_b() && entityItem.func_92059_d().func_77973_b() instanceof IPerfectSpectriteItem) {
                    if (healthField == null) {
                        healthField = ObfuscationReflectionHelper.findField(EntityItem.class, (String)"field_70291_e");
                    }
                    if (immuneToFireField == null) {
                        immuneToFireField = ObfuscationReflectionHelper.findField(Entity.class, (String)"field_70178_ae");
                    }
                    try {
                        healthField.set(entityItem, 5000);
                        immuneToFireField.set(entityItem, true);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            } else if (e.getEntity() instanceof EntityTippedArrow) {
                EntityTippedArrow arrow = (EntityTippedArrow)e.getEntity();
                if (potionField_tippedArrow == null) {
                    potionField_tippedArrow = ObfuscationReflectionHelper.findField(EntityTippedArrow.class, (String)"field_184560_g");
                }
                if (getArrowStackMethod == null) {
                    getArrowStackMethod = ObfuscationReflectionHelper.findMethod(EntityTippedArrow.class, (String)"func_184550_j", ItemStack.class, (Class[])new Class[0]);
                }
                try {
                    EntityLivingBase shootingEntity;
                    Potion potion;
                    PotionType potionType = (PotionType)potionField_tippedArrow.get(arrow);
                    if (!potionType.func_185170_a().isEmpty() && ((potion = ((PotionEffect)potionType.func_185170_a().get(0)).func_188419_a()).equals(ModPotions.SPECTRITE) || potion.equals(ModPotions.SPECTRITE_DAMAGE) || potion.equals(ModPotions.SPECTRITE_STRENGTH) || potion.equals(ModPotions.SPECTRITE_RESISTANCE))) {
                        e.setCanceled(true);
                        Object arrowStackObj = getArrowStackMethod.invoke((Object)arrow, new Object[0]);
                        if (arrowStackObj != null) {
                            ItemTippedArrow arrowItem = (ItemTippedArrow)((ItemStack)arrowStackObj).func_77973_b();
                            ItemStack newStack = new ItemStack((Item)arrowItem);
                            EntitySpectriteTippedArrow newArrow = new EntitySpectriteTippedArrow((EntityTippedArrow)arrowItem.func_185052_a(e.getWorld(), newStack, arrow.field_70250_c != null ? (EntityLivingBase)arrow.field_70250_c : null), potionType);
                            e.getWorld().func_72838_d((Entity)newArrow);
                            if (arrow.field_70250_c != null && arrow.field_70250_c instanceof EntityLivingBase) {
                                SpectriteHelper.damageBow((EntityLivingBase)arrow.field_70250_c, newStack, potionType);
                            }
                        }
                    } else if (arrow.field_70250_c != null && arrow.field_70250_c instanceof EntityLivingBase && !(shootingEntity = (EntityLivingBase)arrow.field_70250_c).func_184592_cb().func_190926_b() && shootingEntity.func_184592_cb().func_77973_b().getClass() == ItemSpectriteArrow.class) {
                        e.setCanceled(true);
                        EntitySpectriteArrow spectriteArrow = (EntitySpectriteArrow)ModItems.spectrite_arrow.func_185052_a(e.getWorld(), shootingEntity.func_184592_cb(), shootingEntity);
                        float velocity = Math.min(e.getWorld().field_73012_v.nextFloat() + 0.25f, 1.0f);
                        spectriteArrow.func_184547_a((Entity)shootingEntity, shootingEntity.field_70125_A, shootingEntity.field_70177_z, 0.0f, velocity * 3.0f, 1.0f);
                        if (velocity == 1.0f) {
                            spectriteArrow.func_70243_d(true);
                        }
                        e.getWorld().func_72838_d((Entity)spectriteArrow);
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            } else if (e.getEntity() instanceof EntityPlayer) {
                if (e.getWorld().func_175624_G() != WorldType.field_77138_c && e.getWorld().func_72940_L() >= 30 && SpectriteConfig.spectriteDungeon.generateSpectriteDungeon) {
                    Spectrite.Network.sendTo((IMessage)new PacketSyncSpectriteDungeonSpawnPos(ModWorldGen.spectriteDungeon.getSpawnPos()), (EntityPlayerMP)e.getEntity());
                }
            } else if (e.getEntity() instanceof EntityAreaEffectCloud) {
                EntityAreaEffectCloud entity = (EntityAreaEffectCloud)e.getEntity();
                if (potionField_areaEffectCloud == null) {
                    potionField_areaEffectCloud = ObfuscationReflectionHelper.findField(EntityAreaEffectCloud.class, (String)"field_184502_e");
                }
                try {
                    Potion potion;
                    PotionType potionType = (PotionType)potionField_areaEffectCloud.get(entity);
                    if (!potionType.func_185170_a().isEmpty() && ((potion = ((PotionEffect)potionType.func_185170_a().get(0)).func_188419_a()).equals(ModPotions.SPECTRITE) || potion.equals(ModPotions.SPECTRITE_DAMAGE) || potion.equals(ModPotions.SPECTRITE_STRENGTH) || potion.equals(ModPotions.SPECTRITE_RESISTANCE))) {
                        e.setCanceled(true);
                        EntitySpectriteAreaEffectCloud newEntity = new EntitySpectriteAreaEffectCloud(e.getWorld(), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                        newEntity.setOwner(entity.func_184494_w());
                        newEntity.setRadius(3.0f);
                        newEntity.setRadiusOnUse(-0.5f);
                        newEntity.setWaitTime(10);
                        newEntity.setRadiusPerTick(-newEntity.getRadius() / (float)newEntity.getDuration());
                        newEntity.setPotionType(potionType);
                        newEntity.addEffect((PotionEffect)potionType.func_185170_a().get(0));
                        e.getWorld().func_72838_d((Entity)newEntity);
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            } else if (e.getEntity() instanceof EntitySpectriteCrystal) {
                SpectriteHelper.addCrystalToCache(e.getWorld(), (EntitySpectriteCrystal)e.getEntity());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onLivingAttack(LivingAttackEvent e) {
        Entity attacker = e.getSource().func_76346_g();
        EntityLivingBase target = e.getEntityLiving();
        if (!target.field_70170_p.field_72995_K) {
            if (target instanceof EntityPlayer && e.getAmount() > 0.0f) {
                boolean bl = skipAttackPlayer = !skipAttackPlayer;
                if (skipAttackPlayer) {
                    return;
                }
            }
            if (!e.getSource().func_82725_o() && attacker instanceof EntityLivingBase) {
                Item heldItem;
                ItemStack heldItemStack = ((EntityLivingBase)attacker).func_184586_b(EnumHand.MAIN_HAND);
                Item item = heldItem = !heldItemStack.func_190926_b() ? heldItemStack.func_77973_b() : null;
                if (attacker instanceof EntitySpectriteGolem || attacker instanceof EntitySpectriteEnderman || heldItem instanceof ItemSpectriteSword || heldItem instanceof IPerfectSpectriteItem) {
                    World world = e.getEntityLiving().func_130014_f_();
                    if ((attacker instanceof EntitySpectriteGolem || attacker instanceof EntitySpectriteEnderman || heldItem instanceof ItemSpectriteSword || heldItem instanceof ISpectriteTool || heldItem instanceof ItemSpectriteWitherRod) && (!(attacker instanceof EntityPlayer) || ((EntityPlayer)attacker).func_184811_cZ().func_185143_a(heldItem, 0.0f) == 0.0f && !attacker.func_70093_af() && target.func_70089_S())) {
                        int power;
                        boolean enhanced = false;
                        if (!(attacker instanceof ISpectriteMob) || attacker instanceof ISpectriteBipedMob) {
                            enhanced = SpectriteHelper.isStackSpectriteEnhanced(heldItemStack);
                            power = (heldItem instanceof IPerfectSpectriteItem ? 2 : 1) + (!(heldItem instanceof ItemSpectriteLegendBlade) ? 0 : 1) + (heldItem instanceof ItemSword ? 1 : 0) - (heldItem == ModItems.spectrite_wither_rod ? 1 : 0);
                            heldItemStack.func_77972_a(power, (EntityLivingBase)attacker);
                        } else {
                            power = 4;
                        }
                        Spectrite.Proxy.performDispersedSpectriteDamage(world, power, -1, new Vec3d(target.field_70165_t, target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 2.0f), target.field_70161_v), attacker, null, world.field_73012_v);
                        target.field_70172_ad = 0;
                        if (attacker instanceof EntityPlayer && !((EntityPlayer)attacker).func_184812_l_()) {
                            ((EntityPlayer)attacker).func_184811_cZ().func_185145_a(heldItem, (int)Math.round(SpectriteConfig.items.spectriteWeaponCooldown * (double)(enhanced && heldItem instanceof ItemSword ? 10 : 20)));
                        }
                    }
                    if (target instanceof EntityPlayer && !target.func_184607_cu().func_190926_b() && target.func_184585_cz() && SpectriteHelper.canBlockDamageSource((EntityPlayer)target, e.getSource()) && target.func_184607_cu().func_77973_b() instanceof ItemSpectriteShield) {
                        SpectriteHelper.damageShield((EntityPlayer)target, e.getAmount());
                        e.setCanceled(true);
                        if (!e.getSource().func_76352_a() && attacker instanceof EntityLivingBase) {
                            ((EntityLivingBase)attacker).func_70653_a((Entity)target, 0.5f, target.field_70165_t - attacker.field_70165_t, target.field_70161_v - attacker.field_70161_v);
                            target.field_70170_p.func_72960_a((Entity)target, (byte)29);
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onLivingHurt(LivingHurtEvent e) {
        PotionEffect attackerBerserkEffect;
        Entity attacker;
        float damage;
        EntityLivingBase target = e.getEntityLiving();
        if (!target.field_70170_p.field_72995_K && e.getSource().func_94541_c()) {
            int skullType;
            ItemStack helmetStack;
            if (e.getEntityLiving() instanceof ISpectriteMob) {
                e.setCanceled(true);
            } else if (target.func_184582_a(EntityEquipmentSlot.HEAD) != null && (helmetStack = e.getEntityLiving().func_184582_a(EntityEquipmentSlot.HEAD)).func_77973_b() instanceof ItemSpectriteSkull && (skullType = ((ItemSpectriteSkull)helmetStack.func_77973_b()).getSkullType()) > 0) {
                damage = e.getAmount() - (float)(skullType * 10);
                if (damage > 0.0f) {
                    e.setAmount(damage);
                } else {
                    e.setCanceled(true);
                }
            }
        }
        if ((attacker = e.getSource().func_76364_f()) instanceof EntityLivingBase && (attackerBerserkEffect = ((EntityLivingBase)attacker).func_70660_b(ModPotions.BERSERK)) != null) {
            int level = attackerBerserkEffect.func_76458_c() + 1;
            target.func_70653_a(attacker, (float)level * 0.5f, (double)MathHelper.func_76126_a((float)(attacker.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(attacker.field_70177_z * ((float)Math.PI / 180)))));
            target.field_70159_w *= 0.6;
            target.field_70179_y *= 0.6;
        }
        if (e.getSource() != DamageSource.field_76380_i && e.getEntityLiving().func_70660_b(ModPotions.ENDURANCE) != null) {
            int amplifier = e.getEntityLiving().func_70660_b(ModPotions.ENDURANCE).func_76458_c() + 1;
            damage = e.getAmount();
            damage = amplifier == 1 ? (damage -= damage * 0.25f) : (damage /= (float)(1 << amplifier - 1));
            if (damage > 0.0f) {
                e.setAmount(damage);
            } else {
                e.setCanceled(true);
            }
        }
        if (e.getSource() == DamageSource.field_76379_h && e.getEntityLiving().func_70660_b(ModPotions.LIGHTWEIGHT) != null) {
            e.setAmount(CombatRules.func_188401_b((float)e.getAmount(), (float)(5.0f * (float)(e.getEntityLiving().func_70660_b(ModPotions.LIGHTWEIGHT).func_76458_c() + 1))));
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onLivingJump(LivingEvent.LivingJumpEvent e) {
        PotionEffect activeJumpBoostEffect;
        EntityLivingBase entity = e.getEntityLiving();
        PotionEffect activeLightweightEffect = entity.func_70660_b(ModPotions.LIGHTWEIGHT);
        if (activeLightweightEffect != null && ((activeJumpBoostEffect = entity.func_70660_b(MobEffects.field_76430_j)) == null || activeJumpBoostEffect.func_76458_c() < activeLightweightEffect.func_76458_c())) {
            float jumpBoost = (float)(activeLightweightEffect.func_76458_c() - (activeJumpBoostEffect == null ? 0 : activeJumpBoostEffect.func_76458_c()) + 1) * 0.1f;
            entity.field_70181_x += (double)jumpBoost;
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onLivingFall(LivingFallEvent e) {
        EntityLivingBase entity = e.getEntityLiving();
        PotionEffect activeLightweightEffect = entity.func_70660_b(ModPotions.LIGHTWEIGHT);
        if (activeLightweightEffect != null) {
            float distance = e.getDistance();
            PotionEffect activeJumpBoostEffect = entity.func_70660_b(MobEffects.field_76430_j);
            if (activeJumpBoostEffect == null || activeJumpBoostEffect.func_76458_c() < activeLightweightEffect.func_76458_c()) {
                distance -= (float)(activeLightweightEffect.func_76458_c() - (activeJumpBoostEffect == null ? 0 : activeJumpBoostEffect.func_76458_c()) + 1);
            }
            e.setDistance(distance);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onBlockPlaced(BlockEvent.PlaceEvent e) {
        block17: {
            Block block;
            block18: {
                block = e.getPlacedBlock().func_177230_c();
                if (block != Blocks.field_150423_aK) break block18;
                BlockPattern golemPattern = BlockSpectrite.getGolemPattern();
                BlockPattern.PatternHelper patternHelper = golemPattern.func_177681_a(e.getWorld(), e.getPos());
                if (patternHelper == null) break block17;
                World world = e.getWorld();
                for (int j = 0; j < golemPattern.func_177684_c(); ++j) {
                    for (int k = 0; k < golemPattern.func_177685_b(); ++k) {
                        world.func_180501_a(patternHelper.func_177670_a(j, k, 0).func_177508_d(), Blocks.field_150350_a.func_176223_P(), 2);
                    }
                }
                BlockPos blockpos = patternHelper.func_177670_a(1, 2, 0).func_177508_d();
                EntitySpectriteGolem entitySpectriteGolem = new EntitySpectriteGolem(world, true);
                entitySpectriteGolem.func_70012_b((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.05, (double)blockpos.func_177952_p() + 0.5, 0.0f, 0.0f);
                world.func_72838_d((Entity)entitySpectriteGolem);
                for (EntityPlayerMP player : world.func_72872_a(EntityPlayerMP.class, entitySpectriteGolem.func_174813_aQ().func_186662_g(5.0))) {
                    CriteriaTriggers.field_192133_m.func_192229_a(player, (Entity)entitySpectriteGolem);
                }
                for (int j1 = 0; j1 < 120; ++j1) {
                    Spectrite.Proxy.spawnSpectriteSpellParticle(world, (double)blockpos.func_177958_n() + world.field_73012_v.nextDouble(), (double)blockpos.func_177956_o() + world.field_73012_v.nextDouble() * 3.9, (double)blockpos.func_177952_p() + world.field_73012_v.nextDouble(), 0.0, 0.0, 0.0, 0.0f);
                }
                for (int k1 = 0; k1 < golemPattern.func_177684_c(); ++k1) {
                    for (int l1 = 0; l1 < golemPattern.func_177685_b(); ++l1) {
                        BlockWorldState blockworldstate1 = patternHelper.func_177670_a(k1, l1, 0);
                        world.func_175722_b(blockworldstate1.func_177508_d(), Blocks.field_150350_a, false);
                    }
                }
                break block17;
            }
            if (block == ModBlocks.spectrite_glass) {
                World world = e.getWorld();
                BlockPos pos = e.getPos();
                while (pos.func_177956_o() > 0) {
                    TileEntity te;
                    IBlockState state = world.func_180495_p(pos = pos.func_177977_b());
                    if (state.func_177230_c() != Blocks.field_150461_bJ || (te = world.func_175625_s(pos)).getClass() != TileEntityBeacon.class) continue;
                    if (primaryEffectField == null) {
                        primaryEffectField = ObfuscationReflectionHelper.findField(TileEntityBeacon.class, (String)"field_146013_m");
                        secondaryEffectField = ObfuscationReflectionHelper.findField(TileEntityBeacon.class, (String)"field_146010_n");
                        paymentField = ObfuscationReflectionHelper.findField(TileEntityBeacon.class, (String)"field_146011_o");
                        customNameField = ObfuscationReflectionHelper.findField(TileEntityBeacon.class, (String)"field_146008_p");
                    }
                    try {
                        Potion primaryEffect = (Potion)primaryEffectField.get(te);
                        Potion secondaryEffect = (Potion)secondaryEffectField.get(te);
                        ItemStack payment = (ItemStack)paymentField.get(te);
                        String customName = (String)customNameField.get(te);
                        world.func_175656_a(pos, ModBlocks.fast_updating_beacon.func_176223_P());
                        te = world.func_175625_s(pos);
                        primaryEffectField.set(te, primaryEffect);
                        secondaryEffectField.set(te, secondaryEffect);
                        paymentField.set(te, payment);
                        customNameField.set(te, customName);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    break;
                }
            } else if (block == Blocks.field_150461_bJ) {
                World world = e.getWorld();
                BlockPos pos = e.getPos();
                while (pos.func_177956_o() < 256) {
                    TileEntity te;
                    IBlockState state = world.func_180495_p(pos = pos.func_177984_a());
                    if (state.func_177230_c() != ModBlocks.spectrite_glass || (te = world.func_175625_s(e.getPos())).getClass() != TileEntityBeacon.class) continue;
                    if (primaryEffectField == null) {
                        primaryEffectField = ObfuscationReflectionHelper.findField(TileEntityBeacon.class, (String)"field_146013_m");
                        secondaryEffectField = ObfuscationReflectionHelper.findField(TileEntityBeacon.class, (String)"field_146010_n");
                        paymentField = ObfuscationReflectionHelper.findField(TileEntityBeacon.class, (String)"field_146011_o");
                        customNameField = ObfuscationReflectionHelper.findField(TileEntityBeacon.class, (String)"field_146008_p");
                    }
                    try {
                        Potion primaryEffect = (Potion)primaryEffectField.get(te);
                        Potion secondaryEffect = (Potion)secondaryEffectField.get(te);
                        ItemStack payment = (ItemStack)paymentField.get(te);
                        String customName = (String)customNameField.get(te);
                        world.func_175656_a(e.getPos(), ModBlocks.fast_updating_beacon.func_176223_P());
                        te = world.func_175625_s(e.getPos());
                        primaryEffectField.set(te, primaryEffect);
                        secondaryEffectField.set(te, secondaryEffect);
                        paymentField.set(te, payment);
                        customNameField.set(te, customName);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    break;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onBlockBreak(BlockEvent.BreakEvent e) {
        Block block = e.getState().func_177230_c();
        if (block == ModBlocks.spectrite_glass) {
            World world = e.getWorld();
            BlockPos beaconPos = e.getPos();
            boolean hasBeacon = false;
            while (beaconPos.func_177956_o() > 0) {
                IBlockState state = world.func_180495_p(beaconPos = beaconPos.func_177977_b());
                if (state.func_177230_c() == ModBlocks.fast_updating_beacon) {
                    hasBeacon = true;
                    break;
                }
                if (state.func_177230_c() != ModBlocks.spectrite_glass) continue;
                break;
            }
            if (hasBeacon) {
                IBlockState state;
                BlockPos pos = e.getPos();
                while (pos.func_177956_o() < 256 && (state = world.func_180495_p(pos = pos.func_177984_a())).func_177230_c() != ModBlocks.spectrite_glass) {
                }
                if (pos.func_177956_o() == 256) {
                    TileEntity te = world.func_175625_s(beaconPos);
                    if (primaryEffectField == null) {
                        primaryEffectField = ObfuscationReflectionHelper.findField(TileEntityBeacon.class, (String)"field_146013_m");
                        secondaryEffectField = ObfuscationReflectionHelper.findField(TileEntityBeacon.class, (String)"field_146010_n");
                        paymentField = ObfuscationReflectionHelper.findField(TileEntityBeacon.class, (String)"field_146011_o");
                        customNameField = ObfuscationReflectionHelper.findField(TileEntityBeacon.class, (String)"field_146008_p");
                    }
                    try {
                        Potion primaryEffect = (Potion)primaryEffectField.get(te);
                        Potion secondaryEffect = (Potion)secondaryEffectField.get(te);
                        ItemStack payment = (ItemStack)paymentField.get(te);
                        String customName = (String)customNameField.get(te);
                        world.func_175656_a(beaconPos, Blocks.field_150461_bJ.func_176223_P());
                        te = world.func_175625_s(beaconPos);
                        primaryEffectField.set(te, primaryEffect);
                        secondaryEffectField.set(te, secondaryEffect);
                        paymentField.set(te, payment);
                        customNameField.set(te, customName);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onHarvestBlock(BlockEvent.HarvestDropsEvent e) {
        int fortuneLevel;
        EntityPlayer harvester;
        PotionEffect activeProsperityEffect;
        if (!e.getWorld().field_72995_K && !e.isSilkTouching() && e.getHarvester() != null && (activeProsperityEffect = (harvester = e.getHarvester()).func_70660_b(ModPotions.PROSPERITY)) != null && (fortuneLevel = e.getFortuneLevel()) < activeProsperityEffect.func_76458_c()) {
            float dropChance = e.getDropChance();
            e.setDropChance(0.0f);
            e.getState().func_177230_c().func_180653_a(e.getWorld(), e.getPos(), e.getState(), dropChance, activeProsperityEffect.func_76458_c());
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onHittingUnderwaterBlock(PlayerEvent.BreakSpeed e) {
        PotionEffect activeAmphibiousEffect;
        if (e.getEntityLiving().func_70090_H() && !EnchantmentHelper.func_185287_i((EntityLivingBase)e.getEntityLiving()) && (activeAmphibiousEffect = e.getEntityLiving().func_70660_b(ModPotions.AMPHIBIOUS)) != null) {
            int amplifier = Math.min(activeAmphibiousEffect.func_76458_c(), 1);
            e.setNewSpeed(e.getOriginalSpeed() * (2.5f * (float)(amplifier + 1)));
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onSpectriteEntityUpdate(LivingEvent.LivingUpdateEvent e) {
        EntityLivingBase entity = e.getEntityLiving();
        if (!entity.func_130014_f_().field_72995_K) {
            PotionEffect activeAmphibiousEffect;
            int amplifier;
            PotionEffect activeResilienceEffect;
            if (entity instanceof ISpectriteMob) {
                if (entity.func_70660_b(ModPotions.SPECTRITE_STRENGTH) == null) {
                    entity.func_70690_d(new PotionEffect(ModPotions.SPECTRITE_STRENGTH, 16, entity instanceof ISpectriteBipedMob && ((ISpectriteBipedMob)entity).isHasSpectriteStrength() ? 1 : 0, true, true));
                }
                if (entity.func_70660_b(ModPotions.SPECTRITE_RESISTANCE) == null) {
                    entity.func_70690_d(new PotionEffect(ModPotions.SPECTRITE_RESISTANCE, 16, entity instanceof ISpectriteBipedMob && ((ISpectriteBipedMob)entity).isHasSpectriteResistance() ? 1 : 0, true, true));
                }
            } else if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_71024_bL().func_75116_a() > 0) {
                ItemStack orbStackMain = null;
                ItemStack orbStackOff = null;
                boolean hasOrbMain = !entity.func_184614_ca().func_190926_b() && (orbStackMain = entity.func_184614_ca()).func_77973_b() == ModItems.spectrite_orb;
                boolean hasOrbOff = !entity.func_184592_cb().func_190926_b() && (orbStackOff = entity.func_184592_cb()).func_77973_b() == ModItems.spectrite_orb;
                ArrayList<Potion> potions = new ArrayList<Potion>();
                if ((hasOrbMain || hasOrbOff) && ((EntityPlayer)entity).func_184811_cZ().func_185143_a((Item)ModItems.spectrite_orb, 0.0f) == 0.0f) {
                    if (hasOrbMain) {
                        potions.addAll(ModItems.spectrite_orb.getPotions(orbStackMain));
                    }
                    if (hasOrbOff) {
                        ModItems.spectrite_orb.getPotions(orbStackOff).forEach(p -> {
                            if (!potions.contains(p)) {
                                potions.add((Potion)p);
                            }
                        });
                    }
                }
                if (potions.size() < 7) {
                    for (ItemStack armourStack : entity.func_184193_aE()) {
                        if (!(armourStack.func_77973_b() instanceof ItemSpectriteArmor)) continue;
                        ((ItemSpectriteArmor)armourStack.func_77973_b()).getPotions(armourStack).forEach(p -> {
                            if (!potions.contains(p)) {
                                potions.add((Potion)p);
                            }
                        });
                    }
                }
                if (potions.size() == 7) {
                    potions.add(ModPotions.SPECTRITE_STRENGTH);
                }
                if (!potions.isEmpty()) {
                    ArrayList<Potion> ambientPotions = new ArrayList<Potion>();
                    ArrayList<PotionEffect> ambientEffects = new ArrayList<PotionEffect>();
                    for (Potion potion : potions) {
                        PotionEffect effect = entity.func_70660_b(potion);
                        if (effect != null && !effect.func_82720_e()) continue;
                        ambientPotions.add(potion);
                        if (effect == null) continue;
                        ambientEffects.add(effect);
                    }
                    if (!ambientPotions.isEmpty()) {
                        PotionEffect activeEffect;
                        PotionEffect potionEffect = activeEffect = !ambientEffects.isEmpty() ? (PotionEffect)ambientEffects.get(0) : null;
                        if (activeEffect == null || activeEffect.func_76459_b() == 1) {
                            for (Potion p3 : ambientPotions) {
                                entity.func_184589_d(p3);
                                entity.func_70690_d(new PotionEffect(p3, 60, 0, true, true));
                            }
                        }
                    }
                }
            }
            if ((activeResilienceEffect = entity.func_70660_b(ModPotions.RESILIENCE)) != null) {
                UUID uuid = entity.getPersistentID();
                amplifier = Math.min(activeResilienceEffect.func_76458_c(), 1);
                if (!entityBadPotionEffectsMap.containsKey(uuid)) {
                    entityBadPotionEffectsMap.put(uuid, new HashMap());
                }
                List badEffectsList = entity.func_193076_bZ().entrySet().stream().filter(p -> ((Potion)p.getKey()).func_76398_f() && !entityBadPotionEffectsMap.get(uuid).entrySet().stream().anyMatch(r -> ((Potion)p.getKey()).getRegistryName().equals(((Tuple)r.getKey()).func_76341_a()) && ((PotionEffect)p.getValue()).func_76458_c() == ((Integer)((Tuple)r.getKey()).func_76340_b()).intValue() && amplifier <= (Integer)((Tuple)r.getValue()).func_76341_a() && entity.func_130014_f_().func_72820_D() + (long)((PotionEffect)p.getValue()).func_76459_b() < (Long)((Tuple)r.getValue()).func_76340_b())).map(p -> (Potion)p.getKey()).collect(Collectors.toList());
                for (Potion p4 : badEffectsList) {
                    PotionEffect activeEffect = entity.func_70660_b(p4);
                    entityBadPotionEffectsMap.get(uuid).put((Tuple<ResourceLocation, Integer>)new Tuple((Object)p4.getRegistryName(), (Object)activeEffect.func_76458_c()), (Tuple<Integer, Long>)new Tuple((Object)amplifier, (Object)(entity.func_130014_f_().func_72820_D() + (long)activeEffect.func_76459_b())));
                    int relAmplifier = amplifier;
                    int n = activeEffect.func_76458_c() + 1;
                    if (entityBadPotionEffectsMap.get(uuid).entrySet().stream().anyMatch(r -> p4.getRegistryName().equals(((Tuple)r.getKey()).func_76341_a()) && activeEffect.func_76458_c() == ((Integer)((Tuple)r.getKey()).func_76340_b()).intValue() && (long)activeEffect.func_76459_b() + entity.func_130014_f_().func_72820_D() < (Long)((Tuple)r.getValue()).func_76340_b())) {
                        --relAmplifier;
                    }
                    if (potionEffectDurationField == null) {
                        potionEffectDurationField = ObfuscationReflectionHelper.findField(PotionEffect.class, (String)"field_76460_b");
                    }
                    int newDuration = activeEffect.func_76459_b();
                    newDuration = relAmplifier == 0 ? (newDuration -= newDuration >> n) : (newDuration -= (newDuration >> n + 1) * (3 << n - 1));
                    try {
                        potionEffectDurationField.set(activeEffect, newDuration);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
            if (!(!entity.func_70090_H() || entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75102_a || entity.func_70648_aU() || entity.func_70644_a(MobEffects.field_76427_o) || (activeAmphibiousEffect = entity.func_70660_b(ModPotions.AMPHIBIOUS)) == null)) {
                amplifier = activeAmphibiousEffect.func_76458_c();
                int air = entity.func_70086_ai();
                if (entity.field_70173_aa % (4 << amplifier) > 0 && air % 30 > 4) {
                    entity.func_70050_g(air + 1);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onApplyLootingLevel(LootingLevelEvent e) {
        int lootingLevel = e.getLootingLevel();
        if (lootingLevel < 2) {
            int effectLootingLevel;
            PotionEffect activeProsperityEffect;
            EntityPlayer attacker;
            if (e.getDamageSource() instanceof DamageSourceSpectriteIndirectPlayer) {
                attacker = ((DamageSourceSpectriteIndirectPlayer)e.getDamageSource()).getPlayer();
            } else {
                Entity entity = attacker = e.getDamageSource().func_76364_f() instanceof EntityLivingBase ? e.getDamageSource().func_76364_f() : e.getDamageSource().func_76346_g();
            }
            if (attacker != null && attacker instanceof EntityLivingBase && (activeProsperityEffect = ((EntityLivingBase)attacker).func_70660_b(ModPotions.PROSPERITY)) != null && lootingLevel < (effectLootingLevel = activeProsperityEffect.func_76458_c() + 1)) {
                e.setLootingLevel(effectLootingLevel);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onFOVUpdateEvent(FOVUpdateEvent e) {
        if (e.getEntity() != null && e.getEntity() instanceof EntityPlayer && !e.getEntity().func_184614_ca().func_190926_b() && e.getEntity().func_184614_ca().func_77973_b() instanceof ItemSpectriteBow) {
            EntityPlayer player = e.getEntity();
            int i = player.func_184605_cv();
            float f1 = (float)i / 20.0f;
            f1 = f1 > 1.0f ? 1.0f : (f1 *= f1);
            e.setNewfov(e.getFov() * (1.0f - f1 * 0.15f));
        }
    }
}

