/*
 * Decompiled with CFR 0.152.
 */
package com.samuel.spectrite.etc;

import com.samuel.spectrite.Spectrite;
import com.samuel.spectrite.init.ModBlocks;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SpectriteExplosion
extends Explosion {
    private final boolean causesFire;
    private final boolean damagesTerrain;
    private final boolean overrideSound;
    private final Random random = new Random();
    private final World world;
    private final double x;
    private final double y;
    private final double z;
    private final float size;

    @SideOnly(value=Side.CLIENT)
    public SpectriteExplosion(World worldIn, Entity entityIn, double x, double y, double z, float size, boolean causesFire, boolean damagesTerrain, boolean overrideSound, List<BlockPos> affectedPositions) {
        super(worldIn, entityIn, x, y, z, size, causesFire, damagesTerrain, affectedPositions);
        this.world = worldIn;
        this.size = size;
        this.x = x;
        this.y = y;
        this.z = z;
        this.causesFire = causesFire;
        this.damagesTerrain = damagesTerrain;
        this.overrideSound = overrideSound;
    }

    public SpectriteExplosion(World worldIn, Entity entityIn, double x, double y, double z, float size, boolean flaming, boolean damagesTerrain, boolean overrideSound) {
        super(worldIn, entityIn, x, y, z, size, flaming, damagesTerrain);
        this.world = worldIn;
        this.size = size;
        this.x = x;
        this.y = y;
        this.z = z;
        this.causesFire = flaming;
        this.damagesTerrain = damagesTerrain;
        this.overrideSound = overrideSound;
    }

    public void func_77279_a(boolean spawnParticles) {
        if (!this.overrideSound) {
            this.world.func_184148_a(null, this.x, this.y, this.z, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.world.field_73012_v.nextFloat() - this.world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        }
        Spectrite.Proxy.spawnSpectriteExplosionHugeParticle(this.world, this.x, this.y, this.z, 1.0, 0.0, 0.0, this.size);
        List affectedBlockPositions = this.func_180343_e();
        if (this.damagesTerrain) {
            for (BlockPos blockpos : affectedBlockPositions) {
                IBlockState iblockstate = this.world.func_180495_p(blockpos);
                Block block = iblockstate.func_177230_c();
                if (spawnParticles) {
                    double d0 = (float)blockpos.func_177958_n() + this.world.field_73012_v.nextFloat();
                    double d1 = (float)blockpos.func_177956_o() + this.world.field_73012_v.nextFloat();
                    double d2 = (float)blockpos.func_177952_p() + this.world.field_73012_v.nextFloat();
                    double d3 = d0 - this.x;
                    double d4 = d1 - this.y;
                    double d5 = d2 - this.z;
                    double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
                    d3 /= d6;
                    d4 /= d6;
                    d5 /= d6;
                    double d7 = 0.5 / (d6 / (double)this.size + 0.1);
                    Spectrite.Proxy.spawnSpectriteExplosionParticle(this.world, false, (d0 + this.x) / 2.0, (d1 + this.y) / 2.0, (d2 + this.z) / 2.0, d3 *= (d7 *= (double)(this.world.field_73012_v.nextFloat() * this.world.field_73012_v.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7);
                    Spectrite.Proxy.spawnSpectriteSmokeNormalParticle(this.world, d0, d1, d2, d3, d4, d5);
                }
                if (iblockstate.func_185904_a() == Material.field_151579_a) continue;
                if (block.func_149659_a((Explosion)this)) {
                    block.func_180653_a(this.world, blockpos, this.world.func_180495_p(blockpos), 1.0f / this.size, 0);
                }
                block.onBlockExploded(this.world, blockpos, (Explosion)this);
            }
        }
        if (this.causesFire) {
            for (BlockPos blockpos1 : affectedBlockPositions) {
                if (this.world.func_180495_p(blockpos1).func_185904_a() != Material.field_151579_a || !this.world.func_180495_p(blockpos1.func_177977_b()).func_185913_b() || this.random.nextInt(3) != 0) continue;
                this.world.func_175656_a(blockpos1, ModBlocks.spectrite_fire.func_176223_P());
            }
        }
    }
}

