/*
 * Decompiled with CFR 0.152.
 */
package com.samuel.spectrite.entities;

import com.samuel.spectrite.Spectrite;
import com.samuel.spectrite.SpectriteConfig;
import com.samuel.spectrite.entities.EntitySpectriteFireball;
import com.samuel.spectrite.entities.EntitySpectriteWither;
import com.samuel.spectrite.init.ModDamageSources;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.init.MobEffects;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySpectriteWitherSkull
extends EntitySpectriteFireball
implements IProjectile {
    private static final DataParameter<Boolean> INVULNERABLE = EntityDataManager.func_187226_a(EntitySpectriteWitherSkull.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntitySpectriteWitherSkull(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.3125f, 0.3125f);
    }

    public EntitySpectriteWitherSkull(World worldIn, EntityLivingBase shooter, double accelX, double accelY, double accelZ) {
        super(worldIn, shooter, accelX, accelY, accelZ);
        this.func_70105_a(0.3125f, 0.3125f);
    }

    @Override
    protected float getMotionFactor() {
        return this.isInvulnerable() && this.shootingEntity instanceof EntitySpectriteWither ? 0.73f : super.getMotionFactor();
    }

    @SideOnly(value=Side.CLIENT)
    public EntitySpectriteWitherSkull(World worldIn, double x, double y, double z, double accelX, double accelY, double accelZ) {
        super(worldIn, x, y, z, accelX, accelY, accelZ);
        this.func_70105_a(0.3125f, 0.3125f);
    }

    public void setAim(Entity shooter, float pitch, float yaw, float velocity) {
        float f = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, velocity, 0.0f);
        this.field_70125_A = pitch;
        this.field_70177_z = yaw;
        this.field_70159_w += shooter.field_70159_w;
        this.field_70179_y += shooter.field_70179_y;
        if (!shooter.field_70122_E) {
            this.field_70181_x += shooter.field_70181_x;
        }
        this.accelerationX = this.field_70159_w * 0.1;
        this.accelerationY = this.field_70181_x * 0.1;
        this.accelerationZ = this.field_70179_y * 0.1;
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 57.29577951308232);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    public boolean func_70027_ad() {
        return false;
    }

    public float func_180428_a(Explosion explosionIn, World worldIn, BlockPos pos, IBlockState blockStateIn) {
        float f = super.func_180428_a(explosionIn, worldIn, pos, blockStateIn);
        Block block = blockStateIn.func_177230_c();
        if (this.shootingEntity instanceof EntitySpectriteWither && this.isInvulnerable() && block.canEntityDestroy(blockStateIn, (IBlockAccess)worldIn, pos, (Entity)this) && EntitySpectriteWither.canDestroyBlock(block) && ForgeEventFactory.onEntityDestroyBlock((EntityLivingBase)this.shootingEntity, (BlockPos)pos, (IBlockState)blockStateIn)) {
            f = Math.min(0.8f, f);
        }
        return f;
    }

    @Override
    protected void onImpact(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            int power;
            if (result.field_72308_g != null) {
                if (this.shootingEntity != null) {
                    if (result.field_72308_g.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.shootingEntity), 10.0f)) {
                        if (result.field_72308_g.func_70089_S()) {
                            this.func_174815_a(this.shootingEntity, result.field_72308_g);
                        } else if (this.shootingEntity instanceof EntitySpectriteWither) {
                            this.shootingEntity.func_70691_i(7.0f);
                        }
                    }
                } else {
                    result.field_72308_g.func_70097_a(ModDamageSources.SPECTRITE_DAMAGE, 7.0f);
                }
                if (result.field_72308_g instanceof EntityLivingBase) {
                    int i = 0;
                    if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                        i = 10;
                    } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                        i = 40;
                    }
                    if (i > 0) {
                        ((EntityLivingBase)result.field_72308_g).func_70690_d(new PotionEffect(MobEffects.field_82731_v, 20 * i, 1));
                    }
                }
            }
            int n = power = this.isInvulnerable() ? 3 : 2;
            int spectriteDamagePower = power + (this.shootingEntity instanceof EntitySpectriteWither ? 1 : (SpectriteConfig.items.spectriteWitherRodWeakenSpectriteDamage ? 0 : 1));
            int explosionPower = power + (this.shootingEntity instanceof EntitySpectriteWither ? 1 : (SpectriteConfig.items.spectriteWitherRodWeakenExplosion ? 0 : 1));
            Spectrite.Proxy.performDispersedSpectriteDamage(this.field_70170_p, spectriteDamagePower, explosionPower, result.field_72307_f, this, (Entity)this.shootingEntity, this.field_70146_Z);
            if (this.isInvulnerable() && this.shootingEntity instanceof EntitySpectriteWither) {
                this.spawnLingeringCloud(power);
            }
            this.func_70106_y();
        }
    }

    @Override
    public boolean func_70067_L() {
        return false;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(INVULNERABLE, (Object)false);
    }

    public boolean isInvulnerable() {
        return (Boolean)this.field_70180_af.func_187225_a(INVULNERABLE);
    }

    public void setInvulnerable(boolean invulnerable) {
        this.field_70180_af.func_187227_b(INVULNERABLE, (Object)invulnerable);
    }

    @Override
    protected boolean isFireballFiery() {
        return false;
    }
}

