/*
 * Decompiled with CFR 0.152.
 */
package com.samuel.spectrite.entities;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.samuel.spectrite.Spectrite;
import com.samuel.spectrite.entities.EntitySpectriteGolem;
import com.samuel.spectrite.entities.EntitySpectriteWitherSkull;
import com.samuel.spectrite.entities.ISpectriteMob;
import com.samuel.spectrite.helpers.SpectriteHelper;
import com.samuel.spectrite.init.ModItems;
import com.samuel.spectrite.init.ModPotions;
import com.samuel.spectrite.init.ModSounds;
import com.samuel.spectrite.items.ItemSpectriteSkull;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySpectriteWither
extends EntityMob
implements IRangedAttackMob,
ISpectriteMob {
    private static final DataParameter<Integer> FIRST_HEAD_TARGET = EntityDataManager.func_187226_a(EntitySpectriteWither.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SECOND_HEAD_TARGET = EntityDataManager.func_187226_a(EntitySpectriteWither.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> THIRD_HEAD_TARGET = EntityDataManager.func_187226_a(EntitySpectriteWither.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer>[] HEAD_TARGETS = new DataParameter[]{FIRST_HEAD_TARGET, SECOND_HEAD_TARGET, THIRD_HEAD_TARGET};
    private static final DataParameter<Integer> INVULNERABILITY_TIME = EntityDataManager.func_187226_a(EntitySpectriteWither.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SKULL_COUNT = EntityDataManager.func_187226_a(EntitySpectriteWither.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> RADIAL_SKULL_TICKS = EntityDataManager.func_187226_a(EntitySpectriteWither.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> RADIAL_SPURTS = EntityDataManager.func_187226_a(EntitySpectriteWither.class, (DataSerializer)DataSerializers.field_187198_h);
    private final float[] xRotationHeads = new float[2];
    private final float[] yRotationHeads = new float[2];
    private final float[] xRotOHeads = new float[2];
    private final float[] yRotOHeads = new float[2];
    private final int[] nextHeadUpdate = new int[2];
    private final int[] idleHeadUpdates = new int[2];
    private int blockBreakCounter;
    private float radialStartYaw = -999.0f;
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.PROGRESS).func_186741_a(true);
    private static final Predicate<Entity> NOT_SPECTRITE = p_apply_1_ -> {
        ItemStack helmetStack;
        boolean ret = !(p_apply_1_ instanceof EntityPlayer) ? p_apply_1_ instanceof EntityLivingBase && !(p_apply_1_ instanceof ISpectriteMob) && ((EntityLivingBase)p_apply_1_).func_190631_cK() : (helmetStack = ((EntityPlayer)p_apply_1_).func_184582_a(EntityEquipmentSlot.HEAD)).func_190926_b() || helmetStack.func_77973_b() instanceof ItemSpectriteSkull;
        return ret;
    };

    public EntitySpectriteWither(World worldIn) {
        super(worldIn);
        this.func_70606_j(this.func_110138_aP());
        this.func_70105_a(0.9f, 3.5f);
        this.field_70178_ae = true;
        ((PathNavigateGround)this.func_70661_as()).func_179693_d(true);
        this.field_70728_aV = 350;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIDoNothing());
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackRanged((IRangedAttackMob)this, 1.0, 60, 30.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 0, false, false, NOT_SPECTRITE));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FIRST_HEAD_TARGET, (Object)0);
        this.field_70180_af.func_187214_a(SECOND_HEAD_TARGET, (Object)0);
        this.field_70180_af.func_187214_a(THIRD_HEAD_TARGET, (Object)0);
        this.field_70180_af.func_187214_a(INVULNERABILITY_TIME, (Object)0);
        this.field_70180_af.func_187214_a(SKULL_COUNT, (Object)0);
        this.field_70180_af.func_187214_a(RADIAL_SKULL_TICKS, (Object)-1);
        this.field_70180_af.func_187214_a(RADIAL_SPURTS, (Object)Boolean.FALSE);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Invul", this.getInvulTime());
        compound.func_74768_a("SkullCount", this.getSkullCount());
        compound.func_74768_a("RadialSkullTicks", this.getRadialSkullTicks());
        compound.func_74757_a("RadialSpurts", this.isRadialSpurts());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setInvulTime(compound.func_74762_e("Invul"));
        if (compound.func_74764_b("SkullCount")) {
            this.setSkullCount(compound.func_74762_e("SkullCount"));
            this.setRadialSkullTicks(compound.func_74762_e("RadialSkullTicks"));
            this.setRadialSpurts(compound.func_74767_n("RadialSpurts"));
        }
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    protected SoundEvent func_184639_G() {
        return ModSounds.spectrite_wither_ambient;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return ModSounds.spectrite_wither_hurt;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.spectrite_wither_death;
    }

    public void func_70636_d() {
        Entity entity;
        this.field_70181_x *= (double)0.6f;
        if (!this.field_70170_p.field_72995_K && this.getWatchedTargetId(0) > 0 && (entity = this.field_70170_p.func_73045_a(this.getWatchedTargetId(0))) != null) {
            double d1;
            double d0;
            double d3;
            if (this.field_70163_u < entity.field_70163_u || !this.isArmored() && this.field_70163_u < entity.field_70163_u + 5.0) {
                if (this.field_70181_x < 0.0) {
                    this.field_70181_x = 0.0;
                }
                this.field_70181_x += (0.5 - this.field_70181_x) * (double)0.6f;
            }
            if ((d3 = (d0 = entity.field_70165_t - this.field_70165_t) * d0 + (d1 = entity.field_70161_v - this.field_70161_v) * d1) > 9.0) {
                double d5 = MathHelper.func_76133_a((double)d3);
                this.field_70159_w += (d0 / d5 * 0.5 - this.field_70159_w) * (double)0.6f;
                this.field_70179_y += (d1 / d5 * 0.5 - this.field_70179_y) * (double)0.6f;
            }
        }
        if (this.getRadialSkullTicks() == -1 && this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > (double)0.05f) {
            this.field_70177_z = (float)MathHelper.func_181159_b((double)this.field_70179_y, (double)this.field_70159_w) * 57.295776f - 90.0f;
        }
        super.func_70636_d();
        if (this.getRadialSkullTicks() == -1) {
            for (int i = 0; i < 2; ++i) {
                this.yRotOHeads[i] = this.yRotationHeads[i];
                this.xRotOHeads[i] = this.xRotationHeads[i];
            }
            for (int j = 0; j < 2; ++j) {
                int k = this.getWatchedTargetId(j + 1);
                Entity entity1 = null;
                if (k > 0) {
                    entity1 = this.field_70170_p.func_73045_a(k);
                }
                if (entity1 != null) {
                    double d11 = this.getHeadX(j + 1);
                    double d12 = this.getHeadY(j + 1);
                    double d13 = this.getHeadZ(j + 1);
                    double d6 = entity1.field_70165_t - d11;
                    double d7 = entity1.field_70163_u + (double)entity1.func_70047_e() - d12;
                    double d8 = entity1.field_70161_v - d13;
                    double d9 = MathHelper.func_76133_a((double)(d6 * d6 + d8 * d8));
                    float f = (float)(MathHelper.func_181159_b((double)d8, (double)d6) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(-(MathHelper.func_181159_b((double)d7, (double)d9) * 57.29577951308232));
                    this.xRotationHeads[j] = this.rotlerp(this.xRotationHeads[j], f1, 40.0f);
                    this.yRotationHeads[j] = this.rotlerp(this.yRotationHeads[j], f, 10.0f);
                    continue;
                }
                this.yRotationHeads[j] = this.rotlerp(this.yRotationHeads[j], this.field_70761_aq, 10.0f);
            }
        }
        boolean flag = this.isArmored();
        if (!this.field_70170_p.field_72995_K) {
            for (int l = 0; l < 3; ++l) {
                double d10 = this.getHeadX(l);
                double d2 = this.getHeadY(l);
                double d4 = this.getHeadZ(l);
                Spectrite.Proxy.spawnSpectriteSmokeNormalParticle(this.field_70170_p, d10 + this.field_70146_Z.nextGaussian() * (double)0.3f, d2 + this.field_70146_Z.nextGaussian() * (double)0.3f, d4 + this.field_70146_Z.nextGaussian() * (double)0.3f, 0.0, 0.0, 0.0);
                if (!flag || this.field_70170_p.field_73012_v.nextInt(4) != 0) continue;
                Spectrite.Proxy.spawnSpectriteSpellParticle(this.field_70170_p, d10 + this.field_70146_Z.nextGaussian() * (double)0.3f, d2 + this.field_70146_Z.nextGaussian() * (double)0.3f, d4 + this.field_70146_Z.nextGaussian() * (double)0.3f, 0.7f, 0.7f, 0.5, 0.0f);
            }
            if (this.getInvulTime() > 0) {
                for (int i1 = 0; i1 < 3; ++i1) {
                    Spectrite.Proxy.spawnSpectriteSpellParticle(this.field_70170_p, this.field_70165_t + this.field_70146_Z.nextGaussian(), this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * 3.3f), this.field_70161_v + this.field_70146_Z.nextGaussian(), 0.7f, 0.7f, 0.9f, 0.0f);
                }
            }
        }
    }

    protected void func_70619_bc() {
        boolean radial;
        int radialSkullTicks = this.getRadialSkullTicks();
        boolean bl = radial = radialSkullTicks > -1;
        if (this.getInvulTime() > 0 && !radial) {
            int j1 = this.getInvulTime() - 1;
            if (j1 <= 0) {
                Spectrite.Proxy.newSpectriteExplosion(this.field_70170_p, (Entity)this, this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, 10.0f, true, this.field_70170_p.func_82736_K().func_82766_b("mobGriefing"), true);
                this.field_70170_p.func_184133_a(null, new BlockPos(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v), ModSounds.explosion, SoundCategory.HOSTILE, 1.0f, 1.0f);
                this.field_70170_p.func_175669_a(1023, new BlockPos((Entity)this), 0);
            } else if (j1 == 30) {
                this.field_70170_p.func_184133_a(null, new BlockPos(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v), ModSounds.preexplosion, SoundCategory.HOSTILE, 1.0f, 1.0f);
            }
            this.setInvulTime(j1);
            if (this.field_70173_aa % 10 == 0) {
                this.func_70691_i(25.0f);
            }
        } else {
            int healRate;
            super.func_70619_bc();
            int difficulty = this.field_70170_p.func_175659_aa().ordinal();
            int skullCount = this.getSkullCount();
            block4: for (int i = 1; i < 3; ++i) {
                boolean needsUpdate;
                boolean bl2 = needsUpdate = this.field_70173_aa >= this.nextHeadUpdate[i - 1];
                if (needsUpdate) {
                    this.nextHeadUpdate[i - 1] = this.field_70173_aa + 10 + this.field_70146_Z.nextInt(10);
                    if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL || this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                        int k3 = this.idleHeadUpdates[i - 1];
                        int j3 = i - 1;
                        this.idleHeadUpdates[j3] = this.idleHeadUpdates[i - 1] + 1;
                        if (i == 2 && k3 > 15) {
                            this.setSkullCount(++skullCount);
                            if (skullCount >= 10) {
                                radial = this.startRadialAttack();
                            }
                        }
                        if (!radial && k3 > 15) {
                            double d0 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70165_t - 10.0), (double)(this.field_70165_t + 10.0));
                            double d1 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70163_u - 5.0), (double)(this.field_70163_u + 5.0));
                            double d2 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70161_v - 10.0), (double)(this.field_70161_v + 10.0));
                            this.launchWitherSkullToCoords(i + 1, d0, d1, d2, true);
                            this.idleHeadUpdates[i - 1] = 0;
                        }
                    }
                }
                int k1 = this.getWatchedTargetId(i);
                if (needsUpdate && i == 2 && !radial && k1 > 0) {
                    this.setSkullCount(++skullCount);
                    if (skullCount >= 10) {
                        radial = this.startRadialAttack();
                    }
                }
                if (i == 2 && radial && radialSkullTicks > 20 && (!this.isRadialSpurts() && radialSkullTicks % 4 == 0 || this.isRadialSpurts() && (radialSkullTicks + 4) % 24 < 16)) {
                    this.launchRadialWitherSkulls(this.getInvulTime() > 0);
                    if (!needsUpdate) continue;
                    this.nextHeadUpdate[i - 1] = this.field_70173_aa + 40 + this.field_70146_Z.nextInt(20);
                    this.idleHeadUpdates[i - 1] = 0;
                    continue;
                }
                if (!needsUpdate) continue;
                if (k1 > 0) {
                    Entity entity = this.field_70170_p.func_73045_a(k1);
                    if (entity != null && entity.func_70089_S() && this.func_70068_e(entity) <= 900.0 && this.func_70685_l(entity)) {
                        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75102_a) {
                            this.updateWatchedTargetId(i, 0);
                            continue;
                        }
                        this.launchWitherSkullToEntity(i + 1, (EntityLivingBase)entity);
                        this.nextHeadUpdate[i - 1] = this.field_70173_aa + 40 + this.field_70146_Z.nextInt(20);
                        this.idleHeadUpdates[i - 1] = 0;
                        continue;
                    }
                    this.updateWatchedTargetId(i, 0);
                    continue;
                }
                List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(20.0, 8.0, 20.0), Predicates.and(NOT_SPECTRITE, (Predicate)EntitySelectors.field_180132_d));
                for (int j2 = 0; j2 < 10 && !list.isEmpty(); ++j2) {
                    EntityLivingBase entitylivingbase = (EntityLivingBase)list.get(this.field_70146_Z.nextInt(list.size()));
                    if (entitylivingbase != this && entitylivingbase.func_70089_S() && this.func_70685_l((Entity)entitylivingbase)) {
                        if (entitylivingbase instanceof EntityPlayer) {
                            if (((EntityPlayer)entitylivingbase).field_71075_bZ.field_75102_a) continue block4;
                            this.updateWatchedTargetId(i, entitylivingbase.func_145782_y());
                            continue block4;
                        }
                        this.updateWatchedTargetId(i, entitylivingbase.func_145782_y());
                        continue block4;
                    }
                    list.remove(entitylivingbase);
                }
            }
            if (radial) {
                if (radialSkullTicks < 84) {
                    this.setRadialSkullTicks(++radialSkullTicks);
                    if (this.getInvulTime() > 0) {
                        this.setInvulTime(this.getInvulTime() - 1);
                    }
                } else {
                    this.setRadialSkullTicks(-1);
                    this.setRadialSpurts(false);
                    this.radialStartYaw = -999.0f;
                }
            }
            if (skullCount >= 10) {
                this.setSkullCount(0);
            }
            if (this.func_70638_az() != null) {
                this.updateWatchedTargetId(0, this.func_70638_az().func_145782_y());
            } else {
                this.updateWatchedTargetId(0, 0);
            }
            if (this.blockBreakCounter > 0) {
                --this.blockBreakCounter;
                if (this.blockBreakCounter == 0 && this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                    int i1 = MathHelper.func_76128_c((double)this.field_70163_u);
                    int l1 = MathHelper.func_76128_c((double)this.field_70165_t);
                    int i2 = MathHelper.func_76128_c((double)this.field_70161_v);
                    boolean flag = false;
                    for (int k2 = -1; k2 <= 1; ++k2) {
                        for (int l2 = -1; l2 <= 1; ++l2) {
                            for (int j = 0; j <= 3; ++j) {
                                int i3 = l1 + k2;
                                int k = i1 + j;
                                int l = i2 + l2;
                                BlockPos blockpos = new BlockPos(i3, k, l);
                                IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
                                Block block = iblockstate.func_177230_c();
                                if (block.isAir(iblockstate, (IBlockAccess)this.field_70170_p, blockpos) || !block.canEntityDestroy(iblockstate, (IBlockAccess)this.field_70170_p, blockpos, (Entity)this) || !EntitySpectriteWither.canDestroyBlock(iblockstate.func_177230_c()) || !ForgeEventFactory.onEntityDestroyBlock((EntityLivingBase)this, (BlockPos)blockpos, (IBlockState)iblockstate)) continue;
                                flag = this.field_70170_p.func_175655_b(blockpos, true) || flag;
                            }
                        }
                    }
                    if (flag) {
                        this.field_70170_p.func_180498_a(null, 1022, new BlockPos((Entity)this), 0);
                    }
                }
            }
            switch (difficulty) {
                case 0: 
                case 1: {
                    healRate = 20;
                    break;
                }
                case 2: {
                    healRate = 15;
                    break;
                }
                default: {
                    healRate = 10;
                }
            }
            if (this.field_70173_aa % healRate == 0) {
                this.func_70691_i(1.0f);
            }
            if (radial) {
                if (this.radialStartYaw == -999.0f) {
                    this.radialStartYaw = (this.field_70177_z + 180.0f) % 360.0f - 180.0f;
                }
                if (radialSkullTicks >= 10) {
                    this.field_70181_x = 0.25;
                }
                this.field_70761_aq = radialSkullTicks < 20 || this.isRadialSpurts() && (this.getRadialSkullTicks() + 4) % 24 >= 16 ? (this.field_70177_z = this.radialStartYaw) : (this.isRadialSpurts() ? (this.field_70177_z = (this.radialStartYaw + 22.5f * (float)((radialSkullTicks - 4) % 16)) % 360.0f - 180.0f) : (this.field_70177_z = (this.radialStartYaw + 11.25f * (float)((radialSkullTicks + 12) % 32)) % 360.0f - 180.0f));
            }
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        }
        this.bossInfo.func_186739_a((ITextComponent)new TextComponentString(SpectriteHelper.getMultiColouredString(this.func_145748_c_().func_150260_c(), true)));
    }

    private boolean startRadialAttack() {
        boolean ret;
        EnumDifficulty difficulty = this.field_70170_p.func_175659_aa();
        boolean bl = ret = difficulty == EnumDifficulty.HARD || difficulty == EnumDifficulty.NORMAL && this.func_110143_aJ() <= this.func_110138_aP() * 0.75f;
        if (ret) {
            if (this.func_110143_aJ() <= this.func_110138_aP() * 0.25f) {
                if (difficulty == EnumDifficulty.HARD) {
                    this.setInvulTime(84);
                }
                if (this.field_70146_Z.nextInt(7) == 0) {
                    this.setRadialSpurts(true);
                }
            } else if (this.func_110143_aJ() <= this.func_110138_aP() * 0.5f && difficulty == EnumDifficulty.HARD) {
                this.setRadialSpurts(true);
            }
            this.setRadialSkullTicks(this.getRadialSkullTicks() + 1);
            this.radialStartYaw = (this.field_70177_z + 180.0f) % 360.0f - 180.0f;
            this.func_70624_b(null);
            this.field_70170_p.func_184133_a(null, new BlockPos(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v), ModSounds.charge, SoundCategory.HOSTILE, 1.0f, 1.0f);
        }
        return ret;
    }

    public static boolean canDestroyBlock(Block blockIn) {
        return blockIn != Blocks.field_150357_h && blockIn != Blocks.field_150384_bq && blockIn != Blocks.field_150378_br && blockIn != Blocks.field_150483_bI && blockIn != Blocks.field_185776_dc && blockIn != Blocks.field_185777_dd && blockIn != Blocks.field_180401_cv && blockIn != Blocks.field_185779_df && blockIn != Blocks.field_189881_dj && blockIn != Blocks.field_180384_M && blockIn != Blocks.field_185775_db;
    }

    public void ignite() {
        this.setInvulTime(220);
        this.func_70606_j(this.func_110138_aP() / 3.0f);
    }

    public void func_70110_aj() {
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    private double getHeadX(int p_82214_1_) {
        if (p_82214_1_ <= 0) {
            return this.field_70165_t;
        }
        float f = (this.field_70761_aq + (float)(180 * (p_82214_1_ - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.func_76134_b((float)f);
        return this.field_70165_t + (double)f1 * 1.3;
    }

    private double getHeadY(int p_82208_1_) {
        return p_82208_1_ <= 0 ? this.field_70163_u + 3.0 : this.field_70163_u + 2.2;
    }

    private double getHeadZ(int p_82213_1_) {
        if (p_82213_1_ <= 0) {
            return this.field_70161_v;
        }
        float f = (this.field_70761_aq + (float)(180 * (p_82213_1_ - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.func_76126_a((float)f);
        return this.field_70161_v + (double)f1 * 1.3;
    }

    private float rotlerp(float p_82204_1_, float p_82204_2_, float p_82204_3_) {
        float f = MathHelper.func_76142_g((float)(p_82204_2_ - p_82204_1_));
        if (f > p_82204_3_) {
            f = p_82204_3_;
        }
        if (f < -p_82204_3_) {
            f = -p_82204_3_;
        }
        return p_82204_1_ + f;
    }

    private void launchWitherSkullToEntity(int p_82216_1_, EntityLivingBase p_82216_2_) {
        this.launchWitherSkullToCoords(p_82216_1_, p_82216_2_.field_70165_t, p_82216_2_.field_70163_u + (double)p_82216_2_.func_70047_e() * 0.5, p_82216_2_.field_70161_v, p_82216_1_ == 0 && this.field_70146_Z.nextFloat() < 0.001f);
    }

    private void launchWitherSkullToCoords(int p_82209_1_, double x, double y, double z, boolean invulnerable) {
        this.field_70170_p.func_180498_a(null, 1024, new BlockPos((Entity)this), 0);
        double d0 = this.getHeadX(p_82209_1_);
        double d1 = this.getHeadY(p_82209_1_);
        double d2 = this.getHeadZ(p_82209_1_);
        double d3 = x - d0;
        double d4 = y - d1;
        double d5 = z - d2;
        EntitySpectriteWitherSkull entitySpectriteWitherSkull = new EntitySpectriteWitherSkull(this.field_70170_p, (EntityLivingBase)this, d3, d4, d5);
        if (invulnerable) {
            entitySpectriteWitherSkull.setInvulnerable(true);
        }
        entitySpectriteWitherSkull.field_70163_u = d1;
        entitySpectriteWitherSkull.field_70165_t = d0;
        entitySpectriteWitherSkull.field_70161_v = d2;
        this.field_70170_p.func_72838_d((Entity)entitySpectriteWitherSkull);
    }

    private void launchRadialWitherSkulls(boolean invulnerable) {
        this.field_70170_p.func_180498_a(null, 1024, new BlockPos((Entity)this), 0);
        double d0 = this.field_70165_t;
        double d1 = this.field_70163_u + (double)this.func_70047_e() * 0.5;
        double d2 = this.field_70161_v;
        boolean hasSpaceBelow = true;
        for (int i = 1; i <= 3; ++i) {
            BlockPos pos = this.func_180425_c().func_177979_c(i);
            boolean bl = hasSpaceBelow = hasSpaceBelow && this.field_70170_p.func_180495_p(pos).func_177230_c().func_176205_b((IBlockAccess)this.field_70170_p, pos);
            if (!hasSpaceBelow) break;
        }
        float yaw = this.isRadialSpurts() ? this.radialStartYaw + 22.5f * (float)((this.getRadialSkullTicks() - 4) % 16) % 360.0f - 180.0f : this.radialStartYaw + 22.5f * (float)((this.getRadialSkullTicks() - 4 >> 2) % 16) % 360.0f - 180.0f;
        EntitySpectriteWitherSkull entitySpectriteWitherSkull = new EntitySpectriteWitherSkull(this.field_70170_p, (EntityLivingBase)this, 0.0, 0.0, 0.0);
        entitySpectriteWitherSkull.setAim((Entity)this, hasSpaceBelow ? 45.0f : 90.0f, yaw, 1.0f);
        if (invulnerable) {
            entitySpectriteWitherSkull.setInvulnerable(true);
        }
        entitySpectriteWitherSkull.field_70163_u = d1;
        entitySpectriteWitherSkull.field_70165_t = d0;
        entitySpectriteWitherSkull.field_70161_v = d2;
        this.field_70170_p.func_72838_d((Entity)entitySpectriteWitherSkull);
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        this.launchWitherSkullToEntity(0, target);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source != DamageSource.field_76369_e && !(source.func_76346_g() instanceof EntitySpectriteWither)) {
            boolean success;
            Entity entity;
            if (this.getInvulTime() > 0 && source != DamageSource.field_76380_i) {
                return false;
            }
            if (this.isArmored() && (entity = source.func_76364_f()) instanceof EntityArrow) {
                return false;
            }
            Entity entity1 = source.func_76346_g();
            if (entity1 != null && !(entity1 instanceof EntityPlayer) && entity1 instanceof EntityLivingBase && ((EntityLivingBase)entity1).func_70668_bt() == this.func_70668_bt()) {
                return false;
            }
            if (this.blockBreakCounter <= 0) {
                this.blockBreakCounter = 20;
            }
            int i = 0;
            while (i < this.idleHeadUpdates.length) {
                int n = i++;
                this.idleHeadUpdates[n] = this.idleHeadUpdates[n] + 3;
            }
            boolean bl = success = super.func_70097_a(source, amount) && !source.func_94541_c();
            if (success && amount > 20.0f && this.getRadialSkullTicks() > -1) {
                this.setRadialSkullTicks(-1);
                this.setRadialSpurts(false);
                this.radialStartYaw = -999.0f;
            }
            return success;
        }
        return false;
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        Entity damageSourceEntity;
        Entity entity = damageSourceEntity = source.func_76346_g() != null ? source.func_76346_g() : source.func_76364_f();
        if (damageSourceEntity == null || !(damageSourceEntity instanceof EntityLivingBase)) {
            lootingModifier = -1;
        }
        this.func_70628_a(wasRecentlyHit, lootingModifier);
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        Item[] drops;
        Item[] itemArray;
        if (lootingModifier > -1) {
            Item[] itemArray2 = new Item[4];
            itemArray2[0] = ModItems.spectrite_star;
            itemArray2[1] = ModItems.spectrite_wither_skull;
            itemArray2[2] = ModItems.spectrite_wither_torso;
            itemArray = itemArray2;
            itemArray2[3] = ModItems.spectrite_wither_tail;
        } else {
            Item[] itemArray3 = new Item[1];
            itemArray = itemArray3;
            itemArray3[0] = ModItems.spectrite_star;
        }
        for (Item d : drops = itemArray) {
            EntityItem entityitem = this.func_145779_a(d, 1);
            if (entityitem == null) continue;
            entityitem.func_174873_u();
        }
    }

    protected void func_70623_bb() {
        this.field_70708_bq = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public void func_70690_d(PotionEffect potioneffectIn) {
        if (potioneffectIn.func_188419_a() == ModPotions.SPECTRITE_STRENGTH || potioneffectIn.func_188419_a() == ModPotions.SPECTRITE_RESISTANCE || potioneffectIn.func_188419_a() == ModPotions.SPECTRITE_DAMAGE) {
            super.func_70690_d(potioneffectIn);
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(750.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.6f);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(8.0);
    }

    public boolean func_184191_r(Entity entityIn) {
        return entityIn instanceof ISpectriteMob && (entityIn.getClass() != EntitySpectriteGolem.class || !((EntitySpectriteGolem)entityIn).func_70850_q()) || super.func_184191_r(entityIn);
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadYRotation(int p_82207_1_) {
        return this.yRotationHeads[p_82207_1_];
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadXRotation(int p_82210_1_) {
        return this.xRotationHeads[p_82210_1_];
    }

    public int getInvulTime() {
        return (Integer)this.field_70180_af.func_187225_a(INVULNERABILITY_TIME);
    }

    public void setInvulTime(int time) {
        this.field_70180_af.func_187227_b(INVULNERABILITY_TIME, (Object)time);
    }

    public int getSkullCount() {
        return (Integer)this.field_70180_af.func_187225_a(SKULL_COUNT);
    }

    public void setSkullCount(int skullCount) {
        this.field_70180_af.func_187227_b(SKULL_COUNT, (Object)skullCount);
    }

    public int getRadialSkullTicks() {
        return (Integer)this.field_70180_af.func_187225_a(RADIAL_SKULL_TICKS);
    }

    public void setRadialSkullTicks(int radialSkullTicks) {
        this.field_70180_af.func_187227_b(RADIAL_SKULL_TICKS, (Object)radialSkullTicks);
    }

    public boolean isRadialSpurts() {
        return (Boolean)this.field_70180_af.func_187225_a(RADIAL_SPURTS);
    }

    public void setRadialSpurts(boolean radialSpurts) {
        this.field_70180_af.func_187227_b(RADIAL_SPURTS, (Object)radialSpurts);
    }

    public int getWatchedTargetId(int head) {
        return (Integer)this.field_70180_af.func_187225_a(HEAD_TARGETS[head]);
    }

    public void updateWatchedTargetId(int targetOffset, int newId) {
        this.field_70180_af.func_187227_b(HEAD_TARGETS[targetOffset], (Object)newId);
    }

    public boolean isArmored() {
        return this.func_110143_aJ() <= this.func_110138_aP() / 2.0f;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_184724_a(boolean swingingArms) {
    }

    class AIDoNothing
    extends EntityAIBase {
        public AIDoNothing() {
            this.func_75248_a(7);
        }

        public boolean func_75250_a() {
            return EntitySpectriteWither.this.getInvulTime() > 0;
        }
    }
}

